/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.xml;

import com.aptana.editor.common.CommonUtil;
import com.aptana.editor.common.text.rules.CharacterMapRule;
import com.aptana.editor.common.text.rules.ExtendedWordRule;
import com.aptana.editor.common.text.rules.WhitespaceDetector;
import com.aptana.editor.xml.internal.IXMLScopes;
import com.aptana.editor.xml.text.rules.XMLTagStartRule;
import java.util.ArrayList;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class XMLTagScanner
extends RuleBasedScanner
implements IXMLScopes {
    public XMLTagScanner() {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new MultiLineRule("\"", "\"", this.createToken("string.quoted.double.xml"), '\\'));
        rules.add(new MultiLineRule("'", "'", this.createToken("string.quoted.single.xml"), '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        ExtendedWordRule wordRule = new ExtendedWordRule(new IWordDetector(){

            public boolean isWordPart(char c) {
                return Character.isLetter(c) || c == '-' || c == ':';
            }

            public boolean isWordStart(char c) {
                return Character.isLetter(c);
            }
        }, this.createToken("entity.other.attribute-name.xml"), true){

            protected boolean wordOK(String word, ICharacterScanner scanner) {
                int c = scanner.read();
                scanner.unread();
                return (char)c == '=';
            }
        };
        rules.add(wordRule);
        CharacterMapRule rule = new CharacterMapRule();
        rule.add('>', this.createToken("punctuation.definition.tag.xml"));
        rule.add('=', this.createToken("punctuation.separator.key-value.xml"));
        rules.add(rule);
        rules.add((Object)new XMLTagStartRule(this.createToken("punctuation.definition.tag.xml")));
        rules.add(new WordRule((IWordDetector)new WordDetector(), this.createToken("entity.name.tag.xml"), true));
        this.setRules(rules.toArray(new IRule[rules.size()]));
        this.setDefaultReturnToken(this.createToken("text"));
    }

    protected IToken createToken(String string) {
        return CommonUtil.getToken((String)string);
    }

    static class WordDetector
    implements IWordDetector {
        WordDetector() {
        }

        public boolean isWordStart(char c) {
            return Character.isLetter(c);
        }

        public boolean isWordPart(char c) {
            return Character.isLetterOrDigit(c);
        }
    }
}

