/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.xml;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.text.reconciler.IFoldingComputer;
import com.aptana.editor.xml.OpenTagCloser;
import com.aptana.editor.xml.TagUtil;
import com.aptana.editor.xml.XMLPlugin;
import com.aptana.editor.xml.XMLSourceViewerConfiguration;
import com.aptana.editor.xml.internal.text.XMLFoldingComputer;
import com.aptana.editor.xml.outline.XMLOutlineContentProvider;
import com.aptana.editor.xml.outline.XMLOutlineLabelProvider;
import com.aptana.editor.xml.parsing.ast.XMLElementNode;
import com.aptana.parsing.ast.IParseNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class XMLEditor
extends AbstractThemeableEditor {
    private static final char[] XML_PAIR_MATCHING_CHARS = new char[]{'(', ')', '{', '}', '[', ']', '`', '`', '\'', '\'', '\"', '\"', '<', '>', '\u201c', '\u201d', '\u2018', '\u2019'};
    private Map<Annotation, Position> fTagPairOccurrences;
    private static Collection<String> tagPartitions = new ArrayList<String>();

    static {
        tagPartitions.add("__xml_tag");
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setPreferenceStore(XMLEditor.getChainedPreferenceStore());
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new XMLSourceViewerConfiguration(this.getPreferenceStore(), this));
        this.setDocumentProvider(XMLPlugin.getDefault().getXMLDocumentProvider());
    }

    public static IPreferenceStore getChainedPreferenceStore() {
        return new ChainedPreferenceStore(new IPreferenceStore[]{XMLPlugin.getDefault().getPreferenceStore(), CommonEditorPlugin.getDefault().getPreferenceStore(), EditorsPlugin.getDefault().getPreferenceStore()});
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.installOpenTagCloser();
    }

    protected void installOpenTagCloser() {
        new OpenTagCloser((ITextViewer)this.getSourceViewer()).install();
    }

    public char[] getPairMatchingCharacters() {
        return XML_PAIR_MATCHING_CHARS;
    }

    public ITreeContentProvider getOutlineContentProvider() {
        return new XMLOutlineContentProvider();
    }

    public ILabelProvider getOutlineLabelProvider() {
        return new XMLOutlineLabelProvider();
    }

    protected IPreferenceStore getOutlinePreferenceStore() {
        return XMLPlugin.getDefault().getPreferenceStore();
    }

    public String getContentType() {
        try {
            IContentType baseType;
            IContentType contentType = ((TextFileDocumentProvider)this.getDocumentProvider()).getContentType((Object)this.getEditorInput());
            if (contentType != null && (baseType = contentType.getBaseType()) != null && "org.eclipse.core.runtime.xml".equals(baseType.getId())) {
                return contentType.getId();
            }
        }
        catch (Exception exception) {}
        return "org.eclipse.core.runtime.xml";
    }

    protected void selectionChanged() {
        super.selectionChanged();
        ISelection selection = this.getSelectionProvider().getSelection();
        if (selection.isEmpty()) {
            return;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        int offset = textSelection.getOffset();
        this.highlightTagPair(offset);
    }

    protected IPreferenceStore getPluginPreferenceStore() {
        return XMLPlugin.getDefault().getPreferenceStore();
    }

    private void highlightTagPair(int offset) {
        IRegion match;
        XMLElementNode en;
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.getEditorInput());
        if (annotationModel == null) {
            return;
        }
        if (this.fTagPairOccurrences != null) {
            for (Position pos : this.fTagPairOccurrences.values()) {
                if (!pos.includes(offset)) continue;
                return;
            }
            for (Annotation a : this.fTagPairOccurrences.keySet()) {
                annotationModel.removeAnnotation(a);
            }
            this.fTagPairOccurrences = null;
        }
        HashMap<Annotation, Position> occurrences = new HashMap<Annotation, Position>();
        IDocument document = this.getSourceViewer().getDocument();
        IParseNode node = this.getASTNodeAt(offset, this.getAST());
        if (node instanceof XMLElementNode && !(en = (XMLElementNode)node).isSelfClosing() && (match = TagUtil.findMatchingTag(document, offset, tagPartitions)) != null) {
            occurrences.put(new Annotation("com.aptana.xml.tagPair.occurrences", false, null), new Position(match.getOffset(), match.getLength()));
            try {
                ITypedRegion partition = document.getPartition(offset);
                occurrences.put(new Annotation("com.aptana.xml.tagPair.occurrences", false, null), new Position(partition.getOffset(), partition.getLength()));
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)XMLPlugin.getDefault(), (Throwable)e);
            }
            for (Map.Entry entry : occurrences.entrySet()) {
                annotationModel.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
            }
            this.fTagPairOccurrences = occurrences;
            return;
        }
        this.fTagPairOccurrences = null;
    }

    public IFoldingComputer createFoldingComputer(IDocument document) {
        return new XMLFoldingComputer(this, document);
    }
}

