/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.xml;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.xml.TagUtil;
import com.aptana.editor.xml.XMLPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;

public class OpenTagCloser
implements VerifyKeyListener {
    private static String[] AUTO_CLOSE_TAG = new String[]{"<br>", "<hr>", "<col>", "<img>", "<area>", "<base>", "<link>", "<meta>", "<frame>", "<input>", "<param>", "<DOCTYPE>", "<isindex>", "<basefont>", "<track>", "<keygen>"};
    private ITextViewer textViewer;

    public OpenTagCloser(ITextViewer textViewer) {
        this.textViewer = textViewer;
    }

    public void install() {
        this.textViewer.getTextWidget().addVerifyKeyListener((VerifyKeyListener)this);
    }

    public void verifyKey(VerifyEvent event) {
        if (!this.isAutoInsertEnabled() || !this.isAutoInsertCharacter(event.character)) {
            return;
        }
        IDocument document = this.textViewer.getDocument();
        Point selection = this.textViewer.getSelectedRange();
        int offset = selection.x;
        int length = selection.y;
        if (!this.shouldAutoClose(document, offset, event)) {
            return;
        }
        try {
            char c;
            boolean nextIsLessThan = false;
            if (offset < document.getLength() && (c = document.getChar(offset)) == '>') {
                char d;
                char b = document.getChar(offset - 1);
                if (b != '%' && b != '?' && '>' == event.character) {
                    nextIsLessThan = true;
                    event.doit = false;
                    this.textViewer.setSelectedRange(offset + 1, 0);
                } else if (offset + 1 < document.getLength() && (d = document.getChar(offset + 1)) == '>') {
                    nextIsLessThan = true;
                    event.doit = false;
                    this.textViewer.setSelectedRange(offset + 1, 0);
                }
            }
            StringBuffer buffer = new StringBuffer();
            if ('\"' == event.character || '\'' == event.character) {
                char prevChar = document.getChar(offset - 1);
                char thisChar = document.getChar(offset);
                if (event.character == prevChar && event.character == thisChar) {
                    nextIsLessThan = false;
                } else {
                    buffer.append(event.character);
                    buffer.append(event.character);
                }
            } else if ('/' == event.character) {
                String openTag = this.getOpenTag(document, offset, true);
                if (openTag == null || this.skipOpenTag(openTag)) {
                    return;
                }
                if (!StringUtil.contains((String[])AUTO_CLOSE_TAG, (String)openTag.toLowerCase())) {
                    return;
                }
                if (TagUtil.tagClosed(document, openTag, true, offset)) {
                    return;
                }
                String closeTag = " />";
                buffer.append(closeTag);
            } else {
                String openTag = this.getOpenTag(document, offset, false);
                if (openTag == null || this.skipOpenTag(openTag)) {
                    return;
                }
                String closeTag = this.getMatchingCloseTag(openTag);
                if (closeTag == null) {
                    return;
                }
                boolean overwrite = openTag.endsWith(">>");
                if (nextIsLessThan) {
                    overwrite = true;
                    ++offset;
                }
                if (!overwrite) {
                    buffer.append(event.character);
                }
                Document copy = new Document(document.get());
                copy.replace(offset, length, buffer.toString());
                if (TagUtil.tagClosed((IDocument)copy, openTag)) {
                    return;
                }
                buffer.append(closeTag);
            }
            if (length > 0) {
                document.replace(offset - 1, length, String.valueOf(event.character));
                document.replace(offset - 1, 1, String.valueOf(event.character) + buffer.toString());
            } else {
                document.replace(offset, length, String.valueOf(event.character));
                document.replace(offset, 1, buffer.toString());
            }
            if (nextIsLessThan) {
                this.textViewer.setSelectedRange(offset, 0);
            } else {
                this.textViewer.setSelectedRange(offset + 1, 0);
            }
            event.doit = false;
        }
        catch (BadLocationException e) {
            XMLPlugin.getDefault().getLog().log((IStatus)new Status(4, "com.aptana.editor.xml", e.getMessage(), (Throwable)e));
        }
    }

    protected boolean shouldAutoClose(IDocument document, int offset, VerifyEvent event) {
        ITypedRegion partition = document.getDocumentPartitioner().getPartition(offset - 1);
        if (partition != null) {
            if (!this.validPartition(partition)) {
                return false;
            }
            try {
                int length = Math.min(partition.getLength(), offset - partition.getOffset());
                String tagContents = document.get(partition.getOffset(), length);
                return !this.inString(tagContents, length);
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)XMLPlugin.getDefault(), (Throwable)e);
            }
        }
        return false;
    }

    protected boolean validPartition(ITypedRegion partition) {
        return "__xml_tag".equals(partition.getType());
    }

    private boolean inString(String tagContents, int length) {
        boolean inString = false;
        int i = 0;
        while (i < length) {
            char c = tagContents.charAt(i);
            switch (c) {
                case '\\': {
                    ++i;
                    break;
                }
                case '\"': 
                case '\'': {
                    break;
                }
            }
            ++i;
        }
        return inString;
    }

    protected boolean skipOpenTag(String openTag) {
        return openTag == null || openTag.startsWith("<!") || openTag.startsWith("<?") || openTag.startsWith("<%");
    }

    private String getMatchingCloseTag(String openTag) {
        String closeTag;
        int index = openTag.indexOf(32);
        if (index == -1) {
            index = openTag.indexOf(62);
        }
        if (!(closeTag = "</" + openTag.substring(1, index)).endsWith(">")) {
            closeTag = String.valueOf(closeTag) + ">";
        }
        return closeTag;
    }

    private String getOpenTag(IDocument document, int offset, boolean isSelfClose) throws BadLocationException {
        String toCheck;
        ITypedRegion partition = document.getPartition(offset - 1);
        int length = Math.min(partition.getLength(), offset - partition.getOffset());
        String tagContents = document.get(partition.getOffset(), length);
        int lessThanIndex = 0;
        boolean inString = false;
        int i = 0;
        while (i < length) {
            char c = tagContents.charAt(i);
            switch (c) {
                case '<': {
                    if (inString) break;
                    lessThanIndex = i;
                    break;
                }
                case '\\': {
                    if (!inString) break;
                    ++i;
                    break;
                }
                case '\"': 
                case '\'': {
                    inString = !inString;
                    break;
                }
            }
            ++i;
        }
        if ((tagContents = tagContents.substring(lessThanIndex)).length() > 0 && tagContents.charAt(0) == '<') {
            tagContents = tagContents.substring(1);
        }
        if (tagContents.length() > 0 && tagContents.charAt(tagContents.length() - 1) == '/') {
            return null;
        }
        String tagName = tagContents.trim();
        int spaceIndex = tagName.indexOf(32);
        if (spaceIndex != -1) {
            tagName = tagName.substring(0, spaceIndex);
        }
        if ((toCheck = tagName).endsWith(">")) {
            toCheck = toCheck.substring(0, toCheck.length() - 1);
        }
        if (tagContents.length() == 0 || toCheck.length() == 0 || toCheck.charAt(0) == '/') {
            return null;
        }
        if (!isSelfClose && this.isEmptyTagType(document, toCheck)) {
            return null;
        }
        return new String("<" + tagName + ">");
    }

    protected boolean isEmptyTagType(IDocument doc, String tagName) {
        return false;
    }

    protected boolean isAutoInsertCharacter(char character) {
        return character == '>' || character == '/';
    }

    protected boolean isAutoInsertEnabled() {
        return true;
    }

    protected ITextViewer getTextViewer() {
        return this.textViewer;
    }
}

