/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.index.core;

import com.aptana.core.IFilter;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.index.core.CategoryInfo;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexDocument;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.QueryResult;
import com.aptana.jetty.util.epl.ajax.JSON;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Plugin;

public abstract class IndexReader {
    public static Pattern DELIMITER_PATTERN;
    public static Pattern SUB_DELIMITER_PATTERN;

    public CategoryInfo getCategoryInfo(Index index, String category) {
        List<QueryResult> types;
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        if (index != null && (types = index.query(new String[]{category}, "*", 2)) != null) {
            for (QueryResult query : types) {
                String word = query.getWord();
                int length = word != null ? word.length() : 0;
                lengths.add(length);
            }
        }
        return new CategoryInfo(category, lengths);
    }

    protected abstract String getDelimiter();

    protected Pattern getDelimiterPattern() {
        if (DELIMITER_PATTERN == null) {
            DELIMITER_PATTERN = Pattern.compile(this.getDelimiter());
        }
        return DELIMITER_PATTERN;
    }

    protected List<QueryResult> getQueryResultsForLocation(List<QueryResult> results, final URI location) {
        if (location == null) {
            return results;
        }
        return CollectionsUtil.filter(results, (IFilter)new IFilter<QueryResult>(){

            public boolean include(QueryResult item) {
                boolean result = true;
                if (location != null) {
                    result = item.getDocuments().contains(location.toString());
                }
                return result;
            }
        });
    }

    protected abstract String getSubDelimiter();

    protected Pattern getSubDelimiterPattern() {
        if (SUB_DELIMITER_PATTERN == null) {
            SUB_DELIMITER_PATTERN = Pattern.compile(this.getSubDelimiter());
        }
        return SUB_DELIMITER_PATTERN;
    }

    protected <T extends JSON.Convertible & IndexDocument> T populateElement(T element, QueryResult item) {
        if (item != null && element != null) {
            this.populateElement(element, item.getWord(), item.getDocuments());
        }
        return element;
    }

    protected <T extends JSON.Convertible & IndexDocument> T populateElement(T element, QueryResult item, int columnIndex) {
        if (item != null && element != null && columnIndex >= 0) {
            String key = item.getWord();
            String[] columns = this.getDelimiterPattern().split(key);
            if (columnIndex < columns.length) {
                this.populateElement(element, columns[columnIndex], item.getDocuments());
            }
        }
        return element;
    }

    private <T extends JSON.Convertible & IndexDocument> T populateElement(T element, String value, Set<String> documents) {
        if (element != null && value != null) {
            try {
                Object m = JSON.parse((String)value);
                if (m instanceof Map) {
                    element.fromJSON((Map)m);
                }
                for (String document : documents) {
                    ((IndexDocument)element).addDocument(document);
                }
            }
            catch (Throwable t) {
                String message = MessageFormat.format("An error occurred while processing the following JSON string\n{0}", value);
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (String)message, (Throwable)t);
            }
        }
        return element;
    }
}

