/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.index.core;

import com.aptana.core.IFilter;
import com.aptana.core.IMap;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.index.core.BuildContextType;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.IndexRequestJob;
import com.aptana.index.core.filter.SDocMLFileIndexingFilterManager;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class IndexContainerJob
extends IndexRequestJob {
    public static final String NODE_MODULE_FOLDER = "node_modules";

    protected IndexContainerJob(URI containerURI, IProject project) {
        super(containerURI, project);
    }

    protected IndexContainerJob(String name, URI containerURI, IProject project) {
        super(name, containerURI, project);
    }

    public IStatus run(IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        if (sub.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        Index index = this.getIndex();
        if (index == null) {
            IdeLog.logError((Plugin)IndexPlugin.getDefault(), (String)MessageFormat.format("Index is null for container: {0}", this.getContainerURI()));
            return Status.CANCEL_STATUS;
        }
        IProject project = this.getProject();
        if (!IndexManager.isEnableIndex(project)) {
            return Status.CANCEL_STATUS;
        }
        try {
            Set<IFileStore> files = this.addFiles(this.getContainerFileStore(), (IProgressMonitor)sub.newChild(100));
            if (this.isNeedFilter()) {
                SDocMLFileIndexingFilterManager.getInstance().clearCache();
            }
            if (sub.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            files.addAll(this.getContributedFiles(this.getContainerURI()));
            Set<String> documents = index.queryDocumentNames(null);
            sub.worked(25);
            if (sub.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.removeDeletedFiles(index, documents, files, (IProgressMonitor)sub.newChild(75));
            if (CollectionsUtil.isEmpty(files)) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            long timestamp = 0L;
            if (!CollectionsUtil.isEmpty(documents)) {
                timestamp = index.getIndexFile().lastModified();
            }
            if (sub.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            try {
                files = this.filterFilesByTimestamp(timestamp, files);
                sub.worked(50);
                if (!CollectionsUtil.isEmpty(files)) {
                    this.indexFileStores(index, files, (IProgressMonitor)sub.newChild(750));
                }
            }
            catch (CoreException e) {
                IStatus iStatus = e.getStatus();
                return iStatus;
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
        }
        finally {
            try {
                index.save();
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (String)"An error occurred while saving an index", (Throwable)e);
            }
            sub.done();
        }
        return Status.OK_STATUS;
    }

    protected IFileStore getContainerFileStore() throws CoreException {
        return EFS.getStore((URI)this.getContainerURI());
    }

    private Set<IFileStore> addFiles(IFileStore container, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        HashSet<IFileStore> files = new HashSet<IFileStore>();
        LinkedList<Object> visitQuene = new LinkedList<Object>();
        visitQuene.offer(container);
        try {
            try {
                long start = System.currentTimeMillis();
                int timeout = 5000;
                while (!visitQuene.isEmpty()) {
                    IFileInfo info;
                    if (System.currentTimeMillis() - start > (long)timeout) {
                        throw new RuntimeException("\u83b7\u53d6\u7d22\u5f15\u6587\u4ef6\u5217\u8868\u8d85\u65f6\uff01\uff01\uff01");
                    }
                    IFileStore file = (IFileStore)visitQuene.poll();
                    if (file == null || !(info = file.fetchInfo(0, (IProgressMonitor)sub.newChild(1))).exists()) continue;
                    if (info.isDirectory()) {
                        try {
                            Object[] fileList;
                            if (NODE_MODULE_FOLDER.equals(info.getName()) || ArrayUtil.isEmpty((Object[])(fileList = file.childStores(0, (IProgressMonitor)sub.newChild(2))))) continue;
                            Object[] objectArray = fileList;
                            int n = fileList.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object child = objectArray[n2];
                                visitQuene.offer(child);
                                ++n2;
                            }
                        }
                        catch (CoreException e) {
                            IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
                        }
                        continue;
                    }
                    if (this.isNeedFilter()) {
                        boolean isRemove = SDocMLFileIndexingFilterManager.getInstance().filterFile(file, this.getProject());
                        if (isRemove) continue;
                        files.add(file);
                        continue;
                    }
                    files.add(file);
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
                sub.done();
            }
        }
        finally {
            sub.done();
        }
        return files;
    }

    private void removeDeletedFiles(Index index, Set<String> documents, Set<IFileStore> files, IProgressMonitor monitor) {
        if (CollectionsUtil.isEmpty(documents)) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(files.size() + documents.size()));
        List fileStoreURIs = CollectionsUtil.map(files, (IMap)new IMap<IFileStore, String>(){

            public String map(IFileStore item) {
                return item.toURI().toString();
            }
        });
        HashSet uris = new HashSet(fileStoreURIs);
        sub.worked(files.size());
        for (String docName : documents) {
            if (!uris.contains(docName)) {
                index.remove(URI.create(docName));
            }
            sub.worked(1);
        }
        sub.done();
    }

    protected Set<IFileStore> filterFilesByTimestamp(final long indexLastModified, Set<IFileStore> files) {
        HashSet<IFileStore> filtered = new HashSet<IFileStore>(files.size());
        CollectionsUtil.filter(files, filtered, (IFilter)new IFilter<IFileStore>(){

            public boolean include(IFileStore item) {
                return item.fetchInfo().getLastModified() >= indexLastModified;
            }
        });
        return filtered;
    }

    @Override
    protected BuildContextType getBuildContextType() {
        return BuildContextType.ALL;
    }
}

