/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.index.core;

import com.aptana.core.logging.IdeLog;
import com.aptana.index.core.IFileStoreIndexingParticipant;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexPlugin;
import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Plugin;

public abstract class AbstractFileIndexingParticipant
implements IFileStoreIndexingParticipant,
IExecutableExtension {
    private static final String ATTR_PRIORITY = "priority";
    private int priority;

    protected void addIndex(Index index, URI uri, String category, String word) {
        index.addEntry(category, word, uri);
    }

    protected String getIndexingMessage(URI containerURI, URI uri) {
        String relativePath = null;
        relativePath = containerURI != null ? containerURI.relativize(uri).toString() : uri.toString();
        return MessageFormat.format("Indexing {0}", relativePath);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.priority = 50;
        try {
            String priorityString = config.getAttribute(ATTR_PRIORITY);
            this.priority = Integer.parseInt(priorityString);
        }
        catch (NumberFormatException e) {
            IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
        }
        catch (InvalidRegistryObjectException e) {
            IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
        }
    }
}

