/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.nodejs.service;

import com.pandora.core.log.HBLog;
import com.pandora.nodejs.NodejsClient;
import com.pandora.nodejs.NodejsPlugin;
import com.pandora.nodejs.service.ActionException;
import com.pandora.nodejs.service.ContentType;
import com.pandora.nodejs.service.NodeAction;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.TException;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class NodeService {
    private static final String RESULT = "result";

    public static String format(JSONObject config, ContentType contentType, String content) throws CoreException {
        try {
            return NodeService.action(NodeAction.FORMAT, config, contentType, content).get(RESULT);
        }
        catch (ActionException e) {
            HBLog.logError((Plugin)NodejsPlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    public static String compressor(JSONObject config, ContentType contentType, String content) throws CoreException {
        try {
            return NodeService.action(NodeAction.COMPRESSOR, config, contentType, content).get(RESULT);
        }
        catch (ActionException e) {
            HBLog.logError((Plugin)NodejsPlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    public static String compile(JSONObject config, ContentType contentType, String content) throws ActionException, CoreException {
        return NodeService.action(NodeAction.COMPILE, config, contentType, content).get(RESULT);
    }

    public static Map<String, String> syntaxCheck(JSONObject config, ContentType contentType, String content) throws ActionException, CoreException {
        return NodeService.action(NodeAction.SYNTAX_CHECK, config, contentType, content);
    }

    private static Map<String, String> action(NodeAction action, JSONObject config, ContentType contentType, String content) throws ActionException, CoreException {
        try {
            HashMap<String, String> request = new HashMap<String, String>();
            request.put("action", action.toString().toLowerCase());
            if (config != null) {
                request.put("config", config.toString());
            }
            request.put("type", contentType.name().toLowerCase());
            request.put("content", content);
            Map<String, String> response = NodejsClient.getInstance().request(request);
            if (response != null && response.containsKey("error")) {
                throw new ActionException(response);
            }
            return response;
        }
        catch (TException e) {
            HBLog.logError((Plugin)NodejsPlugin.getDefault(), (Throwable)e);
            if (e.getCause() instanceof SocketTimeoutException) {
                HBLog.logError((Plugin)NodejsPlugin.getDefault(), (String)"\u8fde\u63a5node\u8fdb\u7a0b\u5931\u8d25, \u8bf7\u68c0\u67e5\u9632\u706b\u5899\u662f\u5426\u62e6\u622aHBuidler\u3001rcp\u8fdb\u7a0b \u6216 127.0.0.1\u88abVPN\u5360\u7528");
            }
            throw new CoreException((IStatus)new Status(4, "com.pandora.nodejs", e.getMessage(), (Throwable)e));
        }
    }
}

