/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.nodejs;

import com.pandora.core.log.HBLog;
import com.pandora.core.utils.IOUtil;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.StringUtil;
import com.pandora.nodejs.NodejsPlugin;
import com.pandora.nodejs.thrift.Service;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;
import sun.misc.BASE64Encoder;

public class NodejsClient {
    private static NodejsClient nodejsClient;
    private Process nodeProcess;
    private Process pprocess = null;
    private volatile int nodeServicePort;
    private int pPort;
    private int today = -1;
    private String password;

    public int getpPort() {
        return this.pPort;
    }

    public void setpPort(int pPort) {
        this.pPort = pPort;
    }

    private NodejsClient() {
    }

    public static NodejsClient getInstance() {
        if (nodejsClient == null) {
            nodejsClient = new NodejsClient();
        }
        return nodejsClient;
    }

    public Map<String, String> request(Map<String, String> request) throws TException {
        try {
            return this.innerRequest(request, false);
        }
        catch (Throwable throwable) {
            return this.innerRequest(request, true);
        }
    }

    public Map<String, String> innerRequest(Map<String, String> request, boolean restart) throws TException {
        TSocket transport = null;
        try {
            if (restart) {
                this.stopNodeService();
                this.startNodeService();
            }
            transport = new TSocket("127.0.0.1", this.nodeServicePort, 10000, 5000);
            transport.open();
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
            Service.Client nodeService = new Service.Client((TProtocol)protocol);
            Map map = nodeService.execute(request);
            return map;
        }
        finally {
            if (transport != null) {
                try {
                    transport.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void startNodeService() {
        try {
            File nodeFile = new File(NodejsPlugin.getDefault().getNodeExePath());
            File serviceFile = new File(FileLocator.toFileURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)"com.pandora.nodejs.thrift"), (IPath)new Path("/js/serviceServer.js"), null)).getPath());
            int port = IOUtil.findFreePort((int)19293);
            HBLog.logError((Plugin)NodejsPlugin.getDefault(), (String)(nodeFile + "   " + serviceFile + " " + port));
            String SASS_BINARY_NAME = PlatformUtil.isWindows() ? "win32-ia32-47" : "darwin-x64-47";
            ProcessBuilder pb = new ProcessBuilder(nodeFile.getAbsolutePath(), serviceFile.getAbsolutePath(), String.valueOf(port));
            pb.redirectErrorStream(true);
            pb.environment().remove("SASS_BINARY_PATH");
            pb.environment().remove("SASS_BINARY_SITE");
            pb.environment().put("SASS_BINARY_NAME", SASS_BINARY_NAME);
            pb.directory(serviceFile.getParentFile());
            this.nodeProcess = null;
            this.nodeProcess = pb.start();
            this.nodeServicePort = port;
            final boolean[] result = new boolean[1];
            new Thread(){

                @Override
                public void run() {
                    try {
                        BufferedReader in = new BufferedReader(new InputStreamReader(NodejsClient.this.nodeProcess.getInputStream()));
                        String s = null;
                        while ((s = in.readLine()) != null) {
                            HBLog.logError((Plugin)NodejsPlugin.getDefault(), (String)s);
                            if (result[0] || !s.contains("create Server listen")) continue;
                            result[0] = true;
                            if (Platform.inDevelopmentMode() || Platform.inDebugMode()) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        HBLog.logError((Plugin)NodejsPlugin.getDefault(), (Throwable)e);
                    }
                }
            }.start();
            long time = 0L;
            while (time <= 3000L && !result[0]) {
                time += 100L;
                Thread.sleep(100L);
            }
            HBLog.logError((Plugin)NodejsPlugin.getDefault(), (String)("node server \u542f\u52a8: " + result[0] + "  " + time));
        }
        catch (Exception e) {
            HBLog.logError((Plugin)NodejsPlugin.getDefault(), (Throwable)e);
        }
    }

    public void stopNodeService() {
        try {
            this.nodeServicePort = 0;
            if (this.nodeProcess != null) {
                this.nodeProcess.destroy();
            }
            if (this.pprocess != null) {
                this.pprocess.destroy();
            }
            if (PlatformUtil.isWindows()) {
                Runtime.getRuntime().exec("taskkill /F /IM hb_node.exe").waitFor();
                HBLog.logError((Plugin)NodejsPlugin.getDefault(), (String)"taskkill /F /IM hb_node.exe");
            } else {
                Runtime.getRuntime().exec("killall -9 hb_node").waitFor();
                HBLog.logError((Plugin)NodejsPlugin.getDefault(), (String)"killall -9 hb_node");
            }
        }
        catch (Throwable e) {
            HBLog.logError((Plugin)NodejsPlugin.getDefault(), (Throwable)e);
        }
    }

    public void startPServer() {
        try {
            this.pPort = IOUtil.findFreePort((int)8088);
            new Thread(){

                @Override
                public void run() {
                    BufferedReader reader = null;
                    InputStream is = null;
                    try {
                        try {
                            File nodeFile = new File(NodejsPlugin.getDefault().getNodeExePath());
                            URL url = FileLocator.find((Bundle)org.eclipse.equinox.util.StringUtil.trim((Bundle)NodejsPlugin.getDefault().getBundle()), (IPath)new Path(org.eclipse.equinox.util.StringUtil.trim((String)"p")), null);
                            File pFile = new File(FileLocator.toFileURL((URL)url).getPath());
                            String serverHost = "172.104.109.100";
                            String serverPort = "8010";
                            String password = NodejsClient.this.getPassword();
                            ProcessBuilder pb = new ProcessBuilder(new String[0]);
                            ArrayList<String> commands = new ArrayList<String>();
                            commands.add(nodeFile.getAbsolutePath());
                            commands.add(pFile.getAbsolutePath());
                            commands.add(String.valueOf(NodejsClient.this.pPort));
                            commands.add(serverHost);
                            commands.add(serverPort);
                            commands.add(password);
                            pb.command(commands.toArray(new String[commands.size()]));
                            pb.redirectErrorStream(true);
                            NodejsClient.this.pprocess = pb.start();
                            NodejsClient.this.pprocess.getOutputStream().flush();
                            NodejsClient.this.pprocess.getOutputStream().close();
                            is = NodejsClient.this.pprocess.getInputStream();
                            reader = new BufferedReader(new InputStreamReader(is));
                            String s = null;
                            while ((s = reader.readLine()) != null) {
                                HBLog.logError((Plugin)NodejsPlugin.getDefault(), (String)("========" + s));
                            }
                        }
                        catch (Exception e) {
                            HBLog.logError((Plugin)NodejsPlugin.getDefault(), (Throwable)e);
                            try {
                                if (reader != null) {
                                    reader.close();
                                }
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                            if (NodejsClient.this.pprocess != null) {
                                NodejsClient.this.pprocess.destroy();
                            }
                            try {
                                if (is != null) {
                                    is.close();
                                }
                            }
                            catch (IOException e3) {
                                e3.printStackTrace();
                            }
                        }
                    }
                    finally {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        if (NodejsClient.this.pprocess != null) {
                            NodejsClient.this.pprocess.destroy();
                        }
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getPassword() {
        Calendar ca = Calendar.getInstance();
        int day = ca.get(5);
        if (day == this.today && StringUtil.isNotBlank((String)this.password)) {
            return this.password;
        }
        this.today = day;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String content = sdf.format(ca.getTime());
        BASE64Encoder base64 = new BASE64Encoder();
        try {
            content = base64.encode(content.getBytes());
            content = content.substring(2, content.length() - 2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.password = "HBuilder!" + content;
        return this.password;
    }
}

