/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rcp.splashHandlers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.StartupThreading;

public abstract class BasicSplashHandler
extends org.eclipse.ui.splash.BasicSplashHandler {
    private Color foreground = null;
    private AbsolutePositionProgressMonitorPart monitor;
    private Rectangle messageRect;
    private Rectangle progressRect;

    public IProgressMonitor getBundleProgressMonitor() {
        return this.monitor;
    }

    public void resetBundleProgressMonitor() {
        if (this.monitor != null && !this.monitor.isDisposed()) {
            this.monitor.getParent().dispose();
        }
        this.monitor = null;
    }

    public void dispose() {
        super.dispose();
        if (this.foreground != null) {
            this.foreground.dispose();
        }
    }

    protected void setForeground(RGB foregroundRGB) {
        if (this.monitor != null) {
            return;
        }
        if (this.foreground != null) {
            this.foreground.dispose();
        }
        this.foreground = new Color((Device)this.getSplash().getShell().getDisplay(), foregroundRGB);
    }

    protected Color getForeground() {
        return this.foreground;
    }

    protected void setMessageRect(Rectangle messageRect) {
        this.messageRect = messageRect;
    }

    protected void setProgressRect(Rectangle progressRect) {
        this.progressRect = progressRect;
    }

    protected Composite getContent() {
        return (Composite)this.getBundleProgressMonitor();
    }

    public void updateUI(final Runnable r) {
        Shell splashShell = this.getSplash();
        if (splashShell == null || splashShell.isDisposed()) {
            return;
        }
        Display display = splashShell.getDisplay();
        if (Thread.currentThread() == display.getThread()) {
            r.run();
        } else {
            StartupThreading.StartupRunnable startupRunnable = new StartupThreading.StartupRunnable(){

                public void runWithException() throws Throwable {
                    r.run();
                }
            };
            display.asyncExec((Runnable)startupRunnable);
        }
    }

    class AbsolutePositionProgressMonitorPart
    extends ProgressMonitorPart {
        public AbsolutePositionProgressMonitorPart(Composite parent) {
            super(parent, null);
            this.setLayout(null);
        }

        public ProgressIndicator getProgressIndicator() {
            return this.fProgressIndicator;
        }

        public Label getProgressText() {
            return this.fLabel;
        }

        public void beginTask(final String name, final int totalWork) {
            BasicSplashHandler.this.updateUI(new Runnable(){

                @Override
                public void run() {
                    if (AbsolutePositionProgressMonitorPart.this.isDisposed()) {
                        return;
                    }
                    AbsolutePositionProgressMonitorPart.super.beginTask(name, totalWork);
                }
            });
        }

        public void done() {
            BasicSplashHandler.this.updateUI(new Runnable(){

                @Override
                public void run() {
                    if (AbsolutePositionProgressMonitorPart.this.isDisposed()) {
                        return;
                    }
                    AbsolutePositionProgressMonitorPart.super.done();
                }
            });
        }

        public void internalWorked(final double work) {
            BasicSplashHandler.this.updateUI(new Runnable(){

                @Override
                public void run() {
                    if (AbsolutePositionProgressMonitorPart.this.isDisposed()) {
                        return;
                    }
                    AbsolutePositionProgressMonitorPart.super.internalWorked(work);
                }
            });
        }

        public void setFont(final Font font) {
            BasicSplashHandler.this.updateUI(new Runnable(){

                @Override
                public void run() {
                    if (AbsolutePositionProgressMonitorPart.this.isDisposed()) {
                        return;
                    }
                    AbsolutePositionProgressMonitorPart.super.setFont(font);
                }
            });
        }

        protected void updateLabel() {
            BasicSplashHandler.this.updateUI(new Runnable(){

                @Override
                public void run() {
                    if (AbsolutePositionProgressMonitorPart.this.isDisposed()) {
                        return;
                    }
                    AbsolutePositionProgressMonitorPart.super.updateLabel();
                }
            });
        }
    }
}

