/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rcp;

import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.rcp.InitializationUtils;
import com.aptana.rcp.ReadyFileUtils;
import com.pandora.core.utils.WorkspaceUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.resources.ResourcesPlugin;

public class ExitUtils {
    public static void saveImg() {
        URI uri = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
        String workspace = new File(uri).getPath();
        if (PlatformUtil.isWindows()) {
            new File(String.valueOf(workspace) + "\\.metadata\\.plugins\\org.eclipse.ui.workbench\\exit.png").delete();
            new File(String.valueOf(workspace) + "\\.metadata\\.plugins\\org.eclipse.ui.workbench\\exit.json").delete();
        } else {
            new File(String.valueOf(workspace) + "/.metadata/.plugins/org.eclipse.ui.workbench/exit.png").delete();
            new File(String.valueOf(workspace) + "/.metadata/.plugins/org.eclipse.ui.workbench/exit.json").delete();
        }
    }

    public static void saveJson(String filepath, String json) {
        File jsonFile = new File(filepath);
        if (jsonFile.exists()) {
            jsonFile.delete();
            jsonFile.exists();
        }
        try {
            jsonFile.createNewFile();
            FileWriter out = new FileWriter(jsonFile, true);
            out.write(json);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String decode(char[] in) throws Exception {
        int off = 0;
        char[] out = new char[in.length];
        int outLen = 0;
        while (off < in.length) {
            int c;
            if ((c = in[off++]) == 92) {
                if (in.length <= off) {
                    out[outLen++] = 92;
                    break;
                }
                c = in[off++];
                if (c == 117) {
                    int value = 0;
                    if (in.length > off + 4) {
                        boolean isUnicode = true;
                        int i = 0;
                        while (i < 4) {
                            c = in[off++];
                            switch (c) {
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: {
                                    value = (value << 4) + c - 48;
                                    break;
                                }
                                case 97: 
                                case 98: 
                                case 99: 
                                case 100: 
                                case 101: 
                                case 102: {
                                    value = (value << 4) + 10 + c - 97;
                                    break;
                                }
                                case 65: 
                                case 66: 
                                case 67: 
                                case 68: 
                                case 69: 
                                case 70: {
                                    value = (value << 4) + 10 + c - 65;
                                    break;
                                }
                                default: {
                                    isUnicode = false;
                                }
                            }
                            ++i;
                        }
                        if (isUnicode) {
                            out[outLen++] = (char)value;
                            continue;
                        }
                        off -= 4;
                        out[outLen++] = 92;
                        out[outLen++] = 117;
                        out[outLen++] = in[off++];
                        continue;
                    }
                    out[outLen++] = 92;
                    out[outLen++] = 117;
                    continue;
                }
                switch (c) {
                    case 116: {
                        c = 9;
                        out[outLen++] = c;
                        break;
                    }
                    case 114: {
                        c = 13;
                        out[outLen++] = c;
                        break;
                    }
                    case 110: {
                        c = 10;
                        out[outLen++] = c;
                        break;
                    }
                    case 102: {
                        c = 12;
                        out[outLen++] = c;
                        break;
                    }
                    default: {
                        out[outLen++] = 92;
                        out[outLen++] = c;
                        break;
                    }
                }
                continue;
            }
            out[outLen++] = c;
        }
        return new String(out, 0, outLen);
    }

    public static void changeWorkspace() {
        String tmpdir;
        File source;
        if (StringUtil.isBlank((String)ReadyFileUtils.USERPROFILES)) {
            ExitUtils.initUserProfiles();
        }
        if ((source = new File(tmpdir = String.valueOf(ReadyFileUtils.USERPROFILES) + "/default")).exists()) {
            ExitUtils.saveTrueUser(InitializationUtils.email);
        }
    }

    public static void initUserProfiles() {
        ReadyFileUtils.USERPROFILES = WorkspaceUtil.getUserProfilesDir();
    }

    public static void saveTrueUser(String tureusername) {
        File renameFile;
        File hbuilderUserDir;
        String tmppath = "";
        tmppath = PlatformUtil.isWindows() ? System.getenv().get("APPDATA") : System.getenv().get("HOME");
        File hbuilderDir = new File(String.valueOf(tmppath) + "/HBuilder");
        if (!hbuilderDir.exists()) {
            hbuilderDir.mkdir();
        }
        if (!(hbuilderUserDir = new File(String.valueOf(tmppath) + "/HBuilder/HBuilder User")).exists()) {
            hbuilderUserDir.mkdir();
        }
        if ((renameFile = new File(String.valueOf(tmppath) + "/HBuilder/HBuilder User/RenameFolder.properties")).exists()) {
            renameFile.delete();
        }
        try {
            renameFile.createNewFile();
            FileWriter out = new FileWriter(renameFile, true);
            out.write(tureusername);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copyFile(File sourceFile, File targetFile) {
        BufferedInputStream inBuff = null;
        FilterOutputStream outBuff = null;
        try {
            try {
                int len;
                inBuff = new BufferedInputStream(new FileInputStream(sourceFile));
                outBuff = new BufferedOutputStream(new FileOutputStream(targetFile));
                byte[] b = new byte[5120];
                while ((len = inBuff.read(b)) != -1) {
                    ((BufferedOutputStream)outBuff).write(b, 0, len);
                }
                ((BufferedOutputStream)outBuff).flush();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (inBuff != null) {
                    try {
                        inBuff.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                if (outBuff != null) {
                    try {
                        outBuff.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                block30: {
                    e.printStackTrace();
                    if (inBuff == null) break block30;
                    try {
                        inBuff.close();
                    }
                    catch (IOException e4) {
                        e4.printStackTrace();
                    }
                }
                if (outBuff != null) {
                    try {
                        outBuff.close();
                    }
                    catch (IOException e5) {
                        e5.printStackTrace();
                    }
                }
            }
        }
        finally {
            if (inBuff != null) {
                try {
                    inBuff.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outBuff != null) {
                try {
                    outBuff.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void copyDirectiory(String sourceDir, String targetDir) {
        new File(targetDir).mkdirs();
        File[] file = new File(sourceDir).listFiles();
        int i = 0;
        while (i < file.length) {
            if (file[i].isFile()) {
                File sourceFile = file[i];
                File targetFile = new File(String.valueOf(new File(targetDir).getAbsolutePath()) + File.separator + file[i].getName());
                ExitUtils.copyFile(sourceFile, targetFile);
            }
            if (file[i].isDirectory()) {
                String dir1 = String.valueOf(sourceDir) + "/" + file[i].getName();
                String dir2 = String.valueOf(targetDir) + "/" + file[i].getName();
                ExitUtils.copyDirectiory(dir1, dir2);
            }
            ++i;
        }
    }
}

