/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rcp;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.DragCursors;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dnd.IDragOverListener;
import org.eclipse.ui.internal.dnd.IDropTarget;
import org.eclipse.ui.services.IEvaluationService;

public class EditorPaneDragSupport
implements IDragOverListener {
    public IDropTarget drag(Control currentControl, Object draggedObject, Point position, Rectangle dragRectangle) {
        if (!(draggedObject instanceof EditorPane)) {
            return null;
        }
        Rectangle rect = new Rectangle(position.x, position.y, 600, 450);
        return new EditorPaneDropTarget((EditorPane)draggedObject, rect);
    }

    private static class EditorPaneDropTarget
    implements IDropTarget {
        private EditorPane fEditorPane;
        private Rectangle fDragRectangle;

        public EditorPaneDropTarget(EditorPane editorPane, Rectangle dragRectangle) {
            this.fEditorPane = editorPane;
            this.fDragRectangle = dragRectangle;
        }

        public void drop() {
            IEvaluationService evaluationService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
            IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)new ExecutionEvent(Collections.EMPTY_MAP, null, (Object)evaluationService.getCurrentState()));
            if (activeWorkbenchWindow == null) {
                return;
            }
            try {
                Workbench workbench = (Workbench)activeWorkbenchWindow.getWorkbench();
                String perspId = null;
                IWorkbenchPage page = activeWorkbenchWindow.getActivePage();
                IAdaptable pageInput = workbench.getDefaultPageInput();
                if (page != null && page.getPerspective() != null) {
                    perspId = page.getPerspective().getId();
                    pageInput = page.getInput();
                } else {
                    perspId = workbench.getPerspectiveRegistry().getDefaultPerspective();
                }
                IWorkbenchWindow newWorkbenchWindow = workbench.createWorkbenchWindow(perspId, pageInput);
                int x = this.getSnapRectangle().x;
                int y = this.getSnapRectangle().y;
                int width = activeWorkbenchWindow.getShell().getBounds().width;
                int height = activeWorkbenchWindow.getShell().getBounds().height;
                newWorkbenchWindow.getShell().setBounds(x, y, width, height);
                if (activeWorkbenchWindow.getShell().getMaximized()) {
                    newWorkbenchWindow.getShell().setMaximized(true);
                }
                EditorPane editor = this.fEditorPane;
                IEditorInput input = editor.getEditorReference().getEditorInput();
                boolean editorClosed = editor.getPage().closeEditor(editor.getEditorReference(), true);
                if (editorClosed) {
                    IEditorPart part = newWorkbenchWindow.getActivePage().openEditor(input, editor.getEditorReference().getId());
                    newWorkbenchWindow.getActivePage().setPartState(newWorkbenchWindow.getActivePage().getReference((IWorkbenchPart)part), 1);
                }
                ((WorkbenchWindow)newWorkbenchWindow).open();
            }
            catch (WorkbenchException workbenchException) {}
        }

        public Cursor getCursor() {
            return DragCursors.getCursor((int)5);
        }

        public Rectangle getSnapRectangle() {
            return this.fDragRectangle;
        }
    }
}

