/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.util.Arrays;

public class ComponentSampleModel
extends SampleModel {
    protected int[] bandOffsets;
    protected int[] bankIndices;
    protected int numBands = 1;
    protected int numBanks = 1;
    protected int scanlineStride;
    protected int pixelStride;

    private static native void initIDs();

    public ComponentSampleModel(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        super(n, n2, n3, nArray.length);
        this.dataType = n;
        this.pixelStride = n4;
        this.scanlineStride = n5;
        this.bandOffsets = (int[])nArray.clone();
        this.numBands = this.bandOffsets.length;
        if (n4 < 0) {
            throw new IllegalArgumentException("Pixel stride must be >= 0");
        }
        if (n5 < 0) {
            throw new IllegalArgumentException("Scanline stride must be >= 0");
        }
        if (this.numBands < 1) {
            throw new IllegalArgumentException("Must have at least one band.");
        }
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException("Unsupported dataType.");
        }
        this.bankIndices = new int[this.numBands];
        for (int i = 0; i < this.numBands; ++i) {
            this.bankIndices[i] = 0;
        }
    }

    public ComponentSampleModel(int n, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2) {
        super(n, n2, n3, nArray2.length);
        this.dataType = n;
        this.pixelStride = n4;
        this.scanlineStride = n5;
        this.bandOffsets = (int[])nArray2.clone();
        this.bankIndices = (int[])nArray.clone();
        if (n4 < 0) {
            throw new IllegalArgumentException("Pixel stride must be >= 0");
        }
        if (n5 < 0) {
            throw new IllegalArgumentException("Scanline stride must be >= 0");
        }
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException("Unsupported dataType.");
        }
        int n6 = this.bankIndices[0];
        if (n6 < 0) {
            throw new IllegalArgumentException("Index of bank 0 is less than 0 (" + n6 + ")");
        }
        for (int i = 1; i < this.bankIndices.length; ++i) {
            if (this.bankIndices[i] > n6) {
                n6 = this.bankIndices[i];
                continue;
            }
            if (this.bankIndices[i] >= 0) continue;
            throw new IllegalArgumentException("Index of bank " + i + " is less than 0 (" + n6 + ")");
        }
        this.numBanks = n6 + 1;
        this.numBands = this.bandOffsets.length;
        if (this.bandOffsets.length != this.bankIndices.length) {
            throw new IllegalArgumentException("Length of bandOffsets must equal length of bankIndices.");
        }
    }

    private long getBufferSize() {
        int n = this.bandOffsets[0];
        for (int i = 1; i < this.bandOffsets.length; ++i) {
            n = Math.max(n, this.bandOffsets[i]);
        }
        long l = 0L;
        if (n >= 0) {
            l += (long)(n + 1);
        }
        if (this.pixelStride > 0) {
            l += (long)(this.pixelStride * (this.width - 1));
        }
        if (this.scanlineStride > 0) {
            l += (long)(this.scanlineStride * (this.height - 1));
        }
        return l;
    }

    int[] orderBands(int[] nArray, int n) {
        int n2;
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            nArray2[n2] = n2;
        }
        for (n2 = 0; n2 < nArray3.length; ++n2) {
            int n3 = n2;
            for (int i = n2 + 1; i < nArray3.length; ++i) {
                if (nArray[nArray2[n3]] <= nArray[nArray2[i]]) continue;
                n3 = i;
            }
            nArray3[nArray2[n3]] = n2 * n;
            nArray2[n3] = nArray2[n2];
        }
        return nArray3;
    }

    @Override
    public SampleModel createCompatibleSampleModel(int n, int n2) {
        int n3;
        int[] nArray;
        int n4;
        Object var3_3 = null;
        int n5 = this.bandOffsets[0];
        int n6 = this.bandOffsets[0];
        for (n4 = 1; n4 < this.bandOffsets.length; ++n4) {
            n5 = Math.min(n5, this.bandOffsets[n4]);
            n6 = Math.max(n6, this.bandOffsets[n4]);
        }
        n4 = this.bandOffsets.length;
        int n7 = Math.abs(this.pixelStride);
        int n8 = Math.abs(this.scanlineStride);
        int n9 = Math.abs(n6 -= n5);
        if (n7 > n8) {
            if (n7 > n9) {
                if (n8 > n9) {
                    nArray = new int[this.bandOffsets.length];
                    for (n3 = 0; n3 < n4; ++n3) {
                        nArray[n3] = this.bandOffsets[n3] - n5;
                    }
                    n8 = n9 + 1;
                    n7 = n8 * n2;
                } else {
                    nArray = this.orderBands(this.bandOffsets, n8 * n2);
                    n7 = n4 * n8 * n2;
                }
            } else {
                n7 = n8 * n2;
                nArray = this.orderBands(this.bandOffsets, n7 * n);
            }
        } else if (n7 > n9) {
            nArray = new int[this.bandOffsets.length];
            for (n3 = 0; n3 < n4; ++n3) {
                nArray[n3] = this.bandOffsets[n3] - n5;
            }
            n7 = n9 + 1;
            n8 = n7 * n;
        } else if (n8 > n9) {
            nArray = this.orderBands(this.bandOffsets, n7 * n);
            n8 = n4 * n7 * n;
        } else {
            n8 = n7 * n;
            nArray = this.orderBands(this.bandOffsets, n8 * n2);
        }
        n3 = 0;
        if (this.scanlineStride < 0) {
            n3 += n8 * n2;
            n8 *= -1;
        }
        if (this.pixelStride < 0) {
            n3 += n7 * n;
            n7 *= -1;
        }
        int n10 = 0;
        while (n10 < n4) {
            int n11 = n10++;
            nArray[n11] = nArray[n11] + n3;
        }
        return new ComponentSampleModel(this.dataType, n, n2, n7, n8, this.bankIndices, nArray);
    }

    @Override
    public SampleModel createSubsetSampleModel(int[] nArray) {
        if (nArray.length > this.bankIndices.length) {
            throw new RasterFormatException("There are only " + this.bankIndices.length + " bands");
        }
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.bankIndices[nArray[i]];
            nArray3[i] = this.bandOffsets[nArray[i]];
        }
        return new ComponentSampleModel(this.dataType, this.width, this.height, this.pixelStride, this.scanlineStride, nArray2, nArray3);
    }

    @Override
    public DataBuffer createDataBuffer() {
        DataBuffer dataBuffer = null;
        int n = (int)this.getBufferSize();
        switch (this.dataType) {
            case 0: {
                dataBuffer = new DataBufferByte(n, this.numBanks);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n, this.numBanks);
                break;
            }
            case 2: {
                dataBuffer = new DataBufferShort(n, this.numBanks);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n, this.numBanks);
                break;
            }
            case 4: {
                dataBuffer = new DataBufferFloat(n, this.numBanks);
                break;
            }
            case 5: {
                dataBuffer = new DataBufferDouble(n, this.numBanks);
            }
        }
        return dataBuffer;
    }

    public int getOffset(int n, int n2) {
        int n3 = n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[0];
        return n3;
    }

    public int getOffset(int n, int n2, int n3) {
        int n4 = n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n3];
        return n4;
    }

    @Override
    public final int[] getSampleSize() {
        int[] nArray = new int[this.numBands];
        int n = this.getSampleSize(0);
        for (int i = 0; i < this.numBands; ++i) {
            nArray[i] = n;
        }
        return nArray;
    }

    @Override
    public final int getSampleSize(int n) {
        return DataBuffer.getDataTypeSize(this.dataType);
    }

    public final int[] getBankIndices() {
        return (int[])this.bankIndices.clone();
    }

    public final int[] getBandOffsets() {
        return (int[])this.bandOffsets.clone();
    }

    public final int getScanlineStride() {
        return this.scanlineStride;
    }

    public final int getPixelStride() {
        return this.pixelStride;
    }

    @Override
    public final int getNumDataElements() {
        return this.getNumBands();
    }

    @Override
    public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n3 = this.getTransferType();
        int n4 = this.getNumDataElements();
        int n5 = n2 * this.scanlineStride + n * this.pixelStride;
        switch (n3) {
            case 0: {
                byte[] byArray = object == null ? new byte[n4] : (byte[])object;
                for (int i = 0; i < n4; ++i) {
                    byArray[i] = (byte)dataBuffer.getElem(this.bankIndices[i], n5 + this.bandOffsets[i]);
                }
                object = byArray;
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = object == null ? new short[n4] : (short[])object;
                for (int i = 0; i < n4; ++i) {
                    sArray[i] = (short)dataBuffer.getElem(this.bankIndices[i], n5 + this.bandOffsets[i]);
                }
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[n4] : (int[])object;
                for (int i = 0; i < n4; ++i) {
                    nArray[i] = dataBuffer.getElem(this.bankIndices[i], n5 + this.bandOffsets[i]);
                }
                object = nArray;
                break;
            }
            case 4: {
                float[] fArray = object == null ? new float[n4] : (float[])object;
                for (int i = 0; i < n4; ++i) {
                    fArray[i] = dataBuffer.getElemFloat(this.bankIndices[i], n5 + this.bandOffsets[i]);
                }
                object = fArray;
                break;
            }
            case 5: {
                double[] dArray = object == null ? new double[n4] : (double[])object;
                for (int i = 0; i < n4; ++i) {
                    dArray[i] = dataBuffer.getElemDouble(this.bankIndices[i], n5 + this.bandOffsets[i]);
                }
                object = dArray;
            }
        }
        return object;
    }

    @Override
    public int[] getPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[this.numBands];
        int n3 = n2 * this.scanlineStride + n * this.pixelStride;
        for (int i = 0; i < this.numBands; ++i) {
            nArray2[i] = dataBuffer.getElem(this.bankIndices[i], n3 + this.bandOffsets[i]);
        }
        return nArray2;
    }

    @Override
    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        if (n < 0 || n >= this.width || n3 > this.width || n5 < 0 || n5 > this.width || n2 < 0 || n2 >= this.height || n2 > this.height || n6 < 0 || n6 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n3 * n4 * this.numBands];
        int n7 = n2 * this.scanlineStride + n * this.pixelStride;
        int n8 = 0;
        for (int i = 0; i < n4; ++i) {
            int n9 = n7;
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < this.numBands; ++k) {
                    nArray2[n8++] = dataBuffer.getElem(this.bankIndices[k], n9 + this.bandOffsets[k]);
                }
                n9 += this.pixelStride;
            }
            n7 += this.scanlineStride;
        }
        return nArray2;
    }

    @Override
    public int getSample(int n, int n2, int n3, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = dataBuffer.getElem(this.bankIndices[n3], n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n3]);
        return n4;
    }

    @Override
    public float getSampleFloat(int n, int n2, int n3, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        float f = dataBuffer.getElemFloat(this.bankIndices[n3], n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n3]);
        return f;
    }

    @Override
    public double getSampleDouble(int n, int n2, int n3, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        double d = dataBuffer.getElemDouble(this.bankIndices[n3], n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n3]);
        return d;
    }

    @Override
    public int[] getSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n + n3 > this.width || n2 + n4 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n3 * n4];
        int n6 = n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n5];
        int n7 = 0;
        for (int i = 0; i < n4; ++i) {
            int n8 = n6;
            for (int j = 0; j < n3; ++j) {
                nArray2[n7++] = dataBuffer.getElem(this.bankIndices[n5], n8);
                n8 += this.pixelStride;
            }
            n6 += this.scanlineStride;
        }
        return nArray2;
    }

    @Override
    public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n3 = this.getTransferType();
        int n4 = this.getNumDataElements();
        int n5 = n2 * this.scanlineStride + n * this.pixelStride;
        switch (n3) {
            case 0: {
                byte[] byArray = (byte[])object;
                for (int i = 0; i < n4; ++i) {
                    dataBuffer.setElem(this.bankIndices[i], n5 + this.bandOffsets[i], byArray[i] & 0xFF);
                }
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = (short[])object;
                for (int i = 0; i < n4; ++i) {
                    dataBuffer.setElem(this.bankIndices[i], n5 + this.bandOffsets[i], sArray[i] & 0xFFFF);
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                for (int i = 0; i < n4; ++i) {
                    dataBuffer.setElem(this.bankIndices[i], n5 + this.bandOffsets[i], nArray[i]);
                }
                break;
            }
            case 4: {
                float[] fArray = (float[])object;
                for (int i = 0; i < n4; ++i) {
                    dataBuffer.setElemFloat(this.bankIndices[i], n5 + this.bandOffsets[i], fArray[i]);
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                for (int i = 0; i < n4; ++i) {
                    dataBuffer.setElemDouble(this.bankIndices[i], n5 + this.bandOffsets[i], dArray[i]);
                }
                break;
            }
        }
    }

    @Override
    public void setPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n3 = n2 * this.scanlineStride + n * this.pixelStride;
        for (int i = 0; i < this.numBands; ++i) {
            dataBuffer.setElem(this.bankIndices[i], n3 + this.bandOffsets[i], nArray[i]);
        }
    }

    @Override
    public void setPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        if (n < 0 || n >= this.width || n3 > this.width || n5 < 0 || n5 > this.width || n2 < 0 || n2 >= this.height || n4 > this.height || n6 < 0 || n6 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n7 = n2 * this.scanlineStride + n * this.pixelStride;
        int n8 = 0;
        for (int i = 0; i < n4; ++i) {
            int n9 = n7;
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < this.numBands; ++k) {
                    dataBuffer.setElem(this.bankIndices[k], n9 + this.bandOffsets[k], nArray[n8++]);
                }
                n9 += this.pixelStride;
            }
            n7 += this.scanlineStride;
        }
    }

    @Override
    public void setSample(int n, int n2, int n3, int n4, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        dataBuffer.setElem(this.bankIndices[n3], n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n3], n4);
    }

    @Override
    public void setSample(int n, int n2, int n3, float f, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        dataBuffer.setElemFloat(this.bankIndices[n3], n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n3], f);
    }

    @Override
    public void setSample(int n, int n2, int n3, double d, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        dataBuffer.setElemDouble(this.bankIndices[n3], n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n3], d);
    }

    @Override
    public void setSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        if (n < 0 || n2 < 0 || n + n3 > this.width || n2 + n4 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = n2 * this.scanlineStride + n * this.pixelStride + this.bandOffsets[n5];
        int n7 = 0;
        for (int i = 0; i < n4; ++i) {
            int n8 = n6;
            for (int j = 0; j < n3; ++j) {
                dataBuffer.setElem(this.bankIndices[n5], n8, nArray[n7++]);
                n8 += this.pixelStride;
            }
            n6 += this.scanlineStride;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ComponentSampleModel)) {
            return false;
        }
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)object;
        return this.width == componentSampleModel.width && this.height == componentSampleModel.height && this.numBands == componentSampleModel.numBands && this.dataType == componentSampleModel.dataType && Arrays.equals(this.bandOffsets, componentSampleModel.bandOffsets) && Arrays.equals(this.bankIndices, componentSampleModel.bankIndices) && this.numBands == componentSampleModel.numBands && this.numBanks == componentSampleModel.numBanks && this.scanlineStride == componentSampleModel.scanlineStride && this.pixelStride == componentSampleModel.pixelStride;
    }

    public int hashCode() {
        int n;
        int n2 = 0;
        n2 = this.width;
        n2 <<= 8;
        n2 ^= this.height;
        n2 <<= 8;
        n2 ^= this.numBands;
        n2 <<= 8;
        n2 ^= this.dataType;
        n2 <<= 8;
        for (n = 0; n < this.bandOffsets.length; ++n) {
            n2 ^= this.bandOffsets[n];
            n2 <<= 8;
        }
        for (n = 0; n < this.bankIndices.length; ++n) {
            n2 ^= this.bankIndices[n];
            n2 <<= 8;
        }
        n2 ^= this.numBands;
        n2 <<= 8;
        n2 ^= this.numBanks;
        n2 <<= 8;
        n2 ^= this.scanlineStride;
        n2 <<= 8;
        return n2 ^= this.pixelStride;
    }

    static {
        ColorModel.loadLibraries();
        ComponentSampleModel.initIDs();
    }
}

