/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.http.server;

import com.sun.istack.internal.NotNull;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpsExchange;
import com.sun.xml.internal.ws.api.PropertySet;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.server.PortAddressResolver;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.internal.ws.resources.WsservletMessages;
import com.sun.xml.internal.ws.transport.http.HttpAdapter;
import com.sun.xml.internal.ws.transport.http.WSHTTPConnection;
import com.sun.xml.internal.ws.util.ReadAllStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.ws.WebServiceException;

final class ServerConnectionImpl
extends WSHTTPConnection
implements WebServiceContextDelegate {
    private final HttpExchange httpExchange;
    private int status;
    private final HttpAdapter adapter;
    private LWHSInputStream in;
    private OutputStream out;
    private static final PropertySet.PropertyMap model = ServerConnectionImpl.parse(ServerConnectionImpl.class);

    public ServerConnectionImpl(@NotNull HttpAdapter httpAdapter, @NotNull HttpExchange httpExchange) {
        this.adapter = httpAdapter;
        this.httpExchange = httpExchange;
    }

    @Override
    @PropertySet.Property(value={"javax.xml.ws.http.request.headers", "com.sun.xml.internal.ws.api.message.packet.inbound.transport.headers"})
    @NotNull
    public Map<String, List<String>> getRequestHeaders() {
        return this.httpExchange.getRequestHeaders();
    }

    @Override
    public String getRequestHeader(String string) {
        return this.httpExchange.getRequestHeaders().getFirst(string);
    }

    @Override
    public void setResponseHeaders(Map<String, List<String>> map) {
        Headers headers = this.httpExchange.getResponseHeaders();
        headers.clear();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String string = entry.getKey();
            List<String> list = entry.getValue();
            if (string.equalsIgnoreCase("Content-Length") || string.equalsIgnoreCase("Content-Type")) continue;
            headers.put(string, (List<String>)new ArrayList<String>(list));
        }
    }

    @Override
    @PropertySet.Property(value={"javax.xml.ws.http.response.headers", "com.sun.xml.internal.ws.api.message.packet.outbound.transport.headers"})
    public Map<String, List<String>> getResponseHeaders() {
        return this.httpExchange.getResponseHeaders();
    }

    @Override
    public void setContentTypeResponseHeader(@NotNull String string) {
        this.httpExchange.getResponseHeaders().set("Content-Type", string);
    }

    @Override
    public void setStatus(int n) {
        this.status = n;
    }

    @Override
    @PropertySet.Property(value={"javax.xml.ws.http.response.code"})
    public int getStatus() {
        return this.status;
    }

    @Override
    @NotNull
    public InputStream getInput() {
        if (this.in == null) {
            this.in = new LWHSInputStream(this.httpExchange.getRequestBody());
        }
        return this.in;
    }

    @Override
    @NotNull
    public OutputStream getOutput() throws IOException {
        if (this.out == null) {
            String string = this.httpExchange.getResponseHeaders().getFirst("Content-Length");
            int n = string != null ? Integer.parseInt(string) : 0;
            this.httpExchange.sendResponseHeaders(this.getStatus(), n);
            this.out = new FilterOutputStream(this.httpExchange.getResponseBody()){
                boolean closed;

                @Override
                public void close() throws IOException {
                    if (!this.closed) {
                        this.closed = true;
                        ServerConnectionImpl.this.in.readAll();
                        try {
                            super.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }

                @Override
                public void write(byte[] byArray, int n, int n2) throws IOException {
                    this.out.write(byArray, n, n2);
                }
            };
        }
        return this.out;
    }

    @Override
    @NotNull
    public WebServiceContextDelegate getWebServiceContextDelegate() {
        return this;
    }

    @Override
    public Principal getUserPrincipal(Packet packet) {
        return this.httpExchange.getPrincipal();
    }

    @Override
    public boolean isUserInRole(Packet packet, String string) {
        return false;
    }

    @Override
    @NotNull
    public String getEPRAddress(Packet packet, WSEndpoint wSEndpoint) {
        PortAddressResolver portAddressResolver = this.adapter.owner.createPortAddressResolver(this.getBaseAddress());
        String string = portAddressResolver.getAddressFor(wSEndpoint.getServiceName(), wSEndpoint.getPortName().getLocalPart());
        if (string == null) {
            throw new WebServiceException(WsservletMessages.SERVLET_NO_ADDRESS_AVAILABLE(wSEndpoint.getPortName()));
        }
        return string;
    }

    @Override
    public String getWSDLAddress(@NotNull Packet packet, @NotNull WSEndpoint wSEndpoint) {
        String string = this.getEPRAddress(packet, wSEndpoint);
        if (this.adapter.getEndpoint().getPort() != null) {
            return string + "?wsdl";
        }
        return null;
    }

    @Override
    public boolean isSecure() {
        return this.httpExchange instanceof HttpsExchange;
    }

    @Override
    @PropertySet.Property(value={"javax.xml.ws.http.request.method"})
    @NotNull
    public String getRequestMethod() {
        return this.httpExchange.getRequestMethod();
    }

    @Override
    @PropertySet.Property(value={"javax.xml.ws.http.request.querystring"})
    public String getQueryString() {
        URI uRI = this.httpExchange.getRequestURI();
        String string = uRI.getQuery();
        if (string != null) {
            return string;
        }
        return null;
    }

    @Override
    @PropertySet.Property(value={"javax.xml.ws.http.request.pathinfo"})
    public String getPathInfo() {
        URI uRI = this.httpExchange.getRequestURI();
        String string = uRI.getPath();
        String string2 = this.httpExchange.getHttpContext().getPath();
        if (string.length() > string2.length()) {
            return string.substring(string2.length());
        }
        return null;
    }

    @PropertySet.Property(value={"com.sun.xml.internal.ws.http.exchange"})
    public HttpExchange getExchange() {
        return this.httpExchange;
    }

    @Override
    @NotNull
    public String getBaseAddress() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.httpExchange instanceof HttpsExchange ? "https" : "http");
        stringBuilder.append("://");
        String string = this.httpExchange.getRequestHeaders().getFirst("Host");
        if (string != null) {
            stringBuilder.append(string);
        } else {
            stringBuilder.append(this.httpExchange.getLocalAddress().getHostName());
            stringBuilder.append(":");
            stringBuilder.append(this.httpExchange.getLocalAddress().getPort());
        }
        return stringBuilder.toString();
    }

    @Override
    public String getProtocol() {
        return this.httpExchange.getProtocol();
    }

    @Override
    public void setContentLengthResponseHeader(int n) {
        this.httpExchange.getResponseHeaders().set("Content-Length", "" + n);
    }

    @Override
    protected PropertySet.PropertyMap getPropertyMap() {
        return model;
    }

    private static class LWHSInputStream
    extends FilterInputStream {
        boolean closed;
        boolean readAll;

        LWHSInputStream(InputStream inputStream) {
            super(inputStream);
        }

        void readAll() throws IOException {
            if (!this.closed && !this.readAll) {
                ReadAllStream readAllStream = new ReadAllStream();
                readAllStream.readAll(this.in, 4000000L);
                this.in.close();
                this.in = readAllStream;
                this.readAll = true;
            }
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.readAll();
                super.close();
                this.closed = true;
            }
        }
    }
}

