/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime.reflect;

import com.sun.xml.internal.bind.api.AccessorException;
import com.sun.xml.internal.bind.v2.runtime.XMLSerializer;
import com.sun.xml.internal.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.internal.bind.v2.runtime.reflect.ListIterator;
import com.sun.xml.internal.bind.v2.runtime.reflect.Lister;

final class PrimitiveArrayListerDouble<BeanT>
extends Lister<BeanT, double[], Double, DoubleArrayPack> {
    private PrimitiveArrayListerDouble() {
    }

    static void register() {
        Lister.primitiveArrayListers.put(Double.TYPE, new PrimitiveArrayListerDouble());
    }

    @Override
    public ListIterator<Double> iterator(final double[] dArray, XMLSerializer xMLSerializer) {
        return new ListIterator<Double>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < dArray.length;
            }

            @Override
            public Double next() {
                return dArray[this.idx++];
            }
        };
    }

    @Override
    public DoubleArrayPack startPacking(BeanT BeanT, Accessor<BeanT, double[]> accessor) {
        return new DoubleArrayPack();
    }

    @Override
    public void addToPack(DoubleArrayPack doubleArrayPack, Double d) {
        doubleArrayPack.add(d);
    }

    @Override
    public void endPacking(DoubleArrayPack doubleArrayPack, BeanT BeanT, Accessor<BeanT, double[]> accessor) throws AccessorException {
        accessor.set(BeanT, doubleArrayPack.build());
    }

    @Override
    public void reset(BeanT BeanT, Accessor<BeanT, double[]> accessor) throws AccessorException {
        accessor.set(BeanT, new double[0]);
    }

    static final class DoubleArrayPack {
        double[] buf = new double[16];
        int size;

        DoubleArrayPack() {
        }

        void add(Double d) {
            if (this.buf.length == this.size) {
                double[] dArray = new double[this.buf.length * 2];
                System.arraycopy(this.buf, 0, dArray, 0, this.buf.length);
                this.buf = dArray;
            }
            if (d != null) {
                this.buf[this.size++] = d;
            }
        }

        double[] build() {
            if (this.buf.length == this.size) {
                return this.buf;
            }
            double[] dArray = new double[this.size];
            System.arraycopy(this.buf, 0, dArray, 0, this.size);
            return dArray;
        }
    }
}

