/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.eclipse36.dispatch.configurationProcessors;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.FileUtil;
import com.aptana.core.util.ResourceUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.portal.ui.eclipse36.PortalUI36Plugin;
import com.aptana.portal.ui.eclipse36.dispatch.configurationProcessors.ApplyProfileChangesDialog;
import com.aptana.portal.ui.eclipse36.dispatch.configurationProcessors.Messages;
import com.aptana.portal.ui.eclipse36.dispatch.configurationProcessors.UpgradeSchedulingRule;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureParser;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.model.InstalledIUElement;
import org.eclipse.equinox.internal.p2.ui.model.ProfileElement;
import org.eclipse.equinox.internal.simpleconfigurator.manipulator.SimpleConfiguratorManipulatorUtils;
import org.eclipse.equinox.internal.simpleconfigurator.utils.BundleInfo;
import org.eclipse.equinox.internal.simpleconfigurator.utils.SimpleConfiguratorUtils;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.query.UserVisibleRootQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UninstallOperation;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.IProgressService;
import org.osgi.framework.Version;

public class PluginsConfigurationProcessor {
    protected static final String PLUGIN_VERSION_ATTR = "plugin_version";
    protected static final String PLUGIN_ID_ATTR = "plugin_id";
    protected static final String FEATURE_ID_ATTR = "feature_id";
    protected static final String PLUGIN_POST_CHECK_ATTR = "plugin_post_check";
    private static final String FEATURE_IU_SUFFIX = ".feature.group";
    public static final int INSTALL_JOB_UPGRADE = 128;
    public static final int INSTALL_JOB_PLUGINS = 256;
    public static final int INSTALL_JOB_PHP = 512;
    public static final int INSTALL_JOB_ALL = 896;

    public static void openInstallDialog(String updateSite, String featureID, IProgressMonitor monitor) throws InvocationTargetException {
        String profileId = "_SELF_";
        ProvisioningUI provisioningUI = ProvisioningUI.getDefaultUI();
        Collection<IInstallableUnit> toInstall = PluginsConfigurationProcessor.getInstallationUnits(updateSite, featureID, profileId, provisioningUI);
        if (toInstall.isEmpty()) {
            throw new IllegalStateException(Messages.PluginsConfigurationProcessor_cannotFindInstallationUnits);
        }
        if (monitor.isCanceled()) {
            return;
        }
        InstallOperation op = new InstallOperation(provisioningUI.getSession(), toInstall);
        provisioningUI.openInstallWizard(toInstall, op, null);
    }

    public static void installWithJob(final String updateSite, final Set<String> featureIDs, final String jobName, final int familys, final boolean needRestart, int conflictJobFamily) throws InvocationTargetException {
        final Job runnable = new Job(jobName){

            public boolean belongsTo(Object family) {
                try {
                    if (family != null && family instanceof Integer && (familys & (Integer)family) != 0) {
                        return true;
                    }
                }
                catch (Throwable e) {
                    IdeLog.logError((Plugin)PortalUI36Plugin.getDefault(), (Throwable)e);
                }
                return super.belongsTo(family);
            }

            public IStatus run(IProgressMonitor monitor) {
                block6: {
                    SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
                    sub.setTaskName(jobName);
                    try {
                        try {
                            boolean result = PluginsConfigurationProcessor.installCommon(updateSite, featureIDs, jobName, monitor);
                            if (needRestart && result) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        int retCode = ApplyProfileChangesDialog.promptForRestart(ProvUI.getDefaultParentShell(), true);
                                        if (retCode == 2) {
                                            PlatformUI.getWorkbench().restart();
                                        }
                                    }
                                });
                            }
                            sub.worked(3);
                        }
                        catch (Throwable e) {
                            IdeLog.logError((Plugin)PortalUI36Plugin.getDefault(), (Throwable)e);
                            sub.done();
                            break block6;
                        }
                    }
                    catch (Throwable throwable) {
                        sub.done();
                        throw throwable;
                    }
                    sub.done();
                }
                return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            }
        };
        runnable.setRule((ISchedulingRule)UpgradeSchedulingRule.getSelfInstance());
        if (!PlatformUI.getWorkbench().isClosing()) {
            String name = PluginsConfigurationProcessor.getInstallingJobName(conflictJobFamily);
            boolean show = StringUtil.isEmpty((String)name);
            if (show) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (PlatformUI.getWorkbench().isClosing()) {
                            return;
                        }
                        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                        progressService.showInDialog(Display.getDefault().getActiveShell(), runnable);
                    }
                });
            }
            ProvisioningUI.getDefaultUI().getSession().rememberJob(runnable);
            runnable.schedule();
        }
    }

    public static boolean installCommon(String updateSite, Set<String> featureIDs, String jobName, IProgressMonitor monitor) throws InvocationTargetException, URISyntaxException, ProvisionException {
        if (featureIDs == null || featureIDs.isEmpty()) {
            return false;
        }
        PluginsConfigurationProcessor.endSystemUpdateJob(monitor);
        ProvisioningUI provisioningUI = ProvisioningUI.getDefaultUI();
        URI siteURL = new URI(updateSite);
        IMetadataRepository repo = provisioningUI.loadMetadataRepository(siteURL, true, (IProgressMonitor)new NullProgressMonitor());
        if (repo == null) {
            throw new ProvisionException(String.valueOf(Messages.PluginsConfigurationProcessor_metadataRepoNotFound) + siteURL);
        }
        IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)provisioningUI.getSession().getProvisioningAgent().getService(IArtifactRepositoryManager.SERVICE_NAME);
        IArtifactRepository artifactRepo = artifactManager.loadRepository(siteURL, (IProgressMonitor)new NullProgressMonitor());
        if (artifactRepo == null) {
            throw new ProvisionException(String.valueOf(Messages.PluginsConfigurationProcessor_artifactRepoNotFound) + siteURL);
        }
        if (!artifactManager.isEnabled(siteURL)) {
            artifactManager.setEnabled(siteURL, true);
        }
        ArrayList result = new ArrayList();
        for (String featureID : featureIDs) {
            IQuery query = featureID == null ? QueryUtil.createIUQuery(null, (VersionRange)VersionRange.emptyRange) : QueryUtil.createIUQuery((String)(String.valueOf(featureID) + FEATURE_IU_SUFFIX), (VersionRange)VersionRange.emptyRange);
            IQueryResult roots = repo.query(query, monitor);
            if (roots.isEmpty()) {
                if (monitor.isCanceled()) {
                    return false;
                }
                String profileId = provisioningUI.getProfileId();
                IProfile profile = ProvUI.getProfileRegistry((ProvisioningSession)provisioningUI.getSession()).getProfile(profileId);
                if (profile != null) {
                    roots = profile.query(query, monitor);
                } else {
                    IdeLog.logError((Plugin)PortalUI36Plugin.getDefault(), (String)MessageFormat.format("Error while retrieving the profile for ''{0}'' update site", updateSite), (Throwable)new RuntimeException(MessageFormat.format("The profile for ''{0}'' was null", profileId)));
                }
            }
            if (roots == null || roots.isEmpty()) continue;
            Set units = roots.toUnmodifiableSet();
            result.addAll(units);
            for (IInstallableUnit out : units) {
                for (IInstallableUnit in : units) {
                    if (in.equals((Object)out) || in.compareTo((Object)out) >= 0) continue;
                    result.remove(in);
                }
            }
        }
        if (!result.isEmpty() && !monitor.isCanceled()) {
            ProvisioningContext context = new ProvisioningContext(provisioningUI.getSession().getProvisioningAgent());
            context.setMetadataRepositories(new URI[]{siteURL});
            context.setArtifactRepositories(new URI[]{siteURL});
            InstallOperation op = new InstallOperation(provisioningUI.getSession(), result);
            op.setProvisioningContext(context);
            IStatus status = op.resolveModal(monitor);
            IdeLog.logError((Plugin)PortalUI36Plugin.getDefault(), (String)("\u4e0b\u8f7d\u63d2\u4ef6\uff1a " + featureIDs + ", result: " + status));
            if (status.getSeverity() == 4) {
                IdeLog.logError((Plugin)PortalUI36Plugin.getDefault(), (String)status.toString());
                if (status.isMultiStatus()) {
                    IStatus[] childrens;
                    IStatus[] iStatusArray = childrens = status.getChildren();
                    int n = childrens.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStatus children = iStatusArray[n2];
                        if (children.getCode() == 10005) {
                            return true;
                        }
                        ++n2;
                    }
                }
                throw new ProvisionException(status);
            }
            if (status.getSeverity() == 8) {
                return false;
            }
            if (status.isOK()) {
                status = op.getProvisioningJob(monitor).runModal(monitor);
                if (status.getSeverity() == 4) {
                    throw new ProvisionException(status);
                }
                if (status.isOK()) {
                    return true;
                }
            }
        }
        return false;
    }

    private static Collection<IInstallableUnit> getInstallationUnits(final String updateSite, final String featureID, final String profileId, final ProvisioningUI provisioningUI) throws InvocationTargetException {
        final ArrayList units = new ArrayList();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            /*
             * Unable to fully structure code
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                sub = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                sub.setTaskName(Messages.PluginsConfigurationProcessor_locatingFeatures);
                try {
                    siteURL = new URI(updateSite);
                    repo = provisioningUI.loadMetadataRepository(siteURL, true, (IProgressMonitor)new NullProgressMonitor());
                    if (repo == null) {
                        throw new ProvisionException(String.valueOf(Messages.PluginsConfigurationProcessor_metadataRepoNotFound) + siteURL);
                    }
                    sub.worked(1);
                    artifactManager = (IArtifactRepositoryManager)provisioningUI.getSession().getProvisioningAgent().getService(IArtifactRepositoryManager.SERVICE_NAME);
                    artifactRepo = artifactManager.loadRepository(siteURL, (IProgressMonitor)new NullProgressMonitor());
                    if (artifactRepo == null) {
                        throw new ProvisionException(String.valueOf(Messages.PluginsConfigurationProcessor_artifactRepoNotFound) + siteURL);
                    }
                    if (!artifactManager.isEnabled(siteURL)) {
                        artifactManager.setEnabled(siteURL, true);
                    }
                    sub.worked(1);
                    query = featureID == null ? QueryUtil.createIUQuery(null, (VersionRange)VersionRange.emptyRange) : QueryUtil.createIUQuery((String)(String.valueOf(featureID) + ".feature.group"), (VersionRange)VersionRange.emptyRange);
                    roots = repo.query(query, monitor);
                    if (!roots.isEmpty()) ** GOTO lbl27
                    if (monitor.isCanceled()) {
                        return;
                    }
                    try {
                        profile = ProvUI.getProfileRegistry((ProvisioningSession)provisioningUI.getSession()).getProfile(profileId);
                        if (profile != null) {
                            roots = profile.query(query, monitor);
                        } else {
                            IdeLog.logError((Plugin)PortalUI36Plugin.getDefault(), (String)MessageFormat.format("Error while retrieving the profile for ''{0}'' update site", new Object[]{updateSite}), (Throwable)new RuntimeException(MessageFormat.format("The profile for ''{0}'' was null", new Object[]{profileId})));
                        }
lbl27:
                        // 3 sources

                        units.addAll(roots.toSet());
                        sub.worked(2);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    sub.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(true, true, runnable);
        }
        catch (InterruptedException interruptedException) {}
        ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>();
        result.addAll(units);
        if (!result.isEmpty()) {
            for (IInstallableUnit out : units) {
                for (IInstallableUnit in : units) {
                    if (in.equals((Object)out) || in.compareTo((Object)out) >= 0) continue;
                    result.remove(in);
                }
            }
        }
        return result;
    }

    public static List<String> getInstalledRootFeatures() {
        ProvisioningUI ui = ProvisioningUI.getDefaultUI();
        IProfileRegistry registry = ProvUI.getProfileRegistry((ProvisioningSession)ui.getSession());
        IProfile profile = registry.getProfile(ui.getProfileId());
        if (profile == null) {
            return CollectionUtils.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        UserVisibleRootQuery query = new UserVisibleRootQuery();
        IQueryResult queryResult = profile.query((IQuery)query, null);
        Set set = queryResult.toUnmodifiableSet();
        if (set != null) {
            for (IInstallableUnit iu : set) {
                result.add(iu.getId());
            }
        }
        return result;
    }

    public static boolean isInstilled(String id) {
        IProfileRegistry registry = ProvUI.getProfileRegistry((ProvisioningSession)ProvisioningUI.getDefaultUI().getSession());
        IProfile profile = registry.getProfile(ProvisioningUI.getDefaultUI().getProfileId());
        return PluginsConfigurationProcessor.getInstilledIInstallableUnit(id, profile) != null;
    }

    public static IInstallableUnit getInstilledIInstallableUnit(String id, IProfile profile) {
        IQueryResult alreadyInstalled;
        if (StringUtil.isBlank((String)id)) {
            return null;
        }
        if (id != null && !id.endsWith(FEATURE_IU_SUFFIX)) {
            id = (String.valueOf(id) + FEATURE_IU_SUFFIX).toLowerCase();
        }
        if (profile != null && (alreadyInstalled = profile.query(QueryUtil.createIUQuery((String)id), null)) != null && !alreadyInstalled.isEmpty()) {
            return (IInstallableUnit)alreadyInstalled.iterator().next();
        }
        return null;
    }

    public static List<IInstallableUnit> getAllInstalledFeatures() {
        final ArrayList<IInstallableUnit> allInstalledFeatures = new ArrayList<IInstallableUnit>();
        try {
            String profileId = ProvisioningUI.getDefaultUI().getProfileId();
            if (profileId != null) {
                ProfileElement pe = new ProfileElement(null, profileId);
                pe.fetchDeferredChildren((Object)pe, new IElementCollector(){

                    public void done() {
                    }

                    public void add(Object[] elements, IProgressMonitor monitor) {
                        Object[] objectArray = elements;
                        int n = elements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object[] children;
                            Object element = objectArray[n2];
                            IInstallableUnit iu = (IInstallableUnit)ProvUI.getAdapter((Object)element, IInstallableUnit.class);
                            if (iu != null) {
                                allInstalledFeatures.add(iu);
                            }
                            if (element instanceof InstalledIUElement && (children = ((InstalledIUElement)element).getChildren(element)) != null && children.length > 0) {
                                this.add(children, monitor);
                            }
                            ++n2;
                        }
                    }

                    public void add(Object element, IProgressMonitor monitor) {
                        this.add(new Object[]{element}, monitor);
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PortalUI36Plugin.getDefault(), (Throwable)e);
        }
        return allInstalledFeatures;
    }

    private static List<IInstallableUnit> getRootInstalledFeatures() {
        final ArrayList<IInstallableUnit> allInstalledFeatures = new ArrayList<IInstallableUnit>();
        try {
            String profileId = ProvisioningUI.getDefaultUI().getProfileId();
            if (profileId != null) {
                ProfileElement pe = new ProfileElement(null, profileId);
                pe.fetchDeferredChildren((Object)pe, new IElementCollector(){

                    public void done() {
                    }

                    public void add(Object[] elements, IProgressMonitor monitor) {
                        Object[] objectArray = elements;
                        int n = elements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object element = objectArray[n2];
                            IInstallableUnit iu = (IInstallableUnit)ProvUI.getAdapter((Object)element, IInstallableUnit.class);
                            if (iu != null) {
                                allInstalledFeatures.add(iu);
                            }
                            ++n2;
                        }
                    }

                    public void add(Object element, IProgressMonitor monitor) {
                        this.add(new Object[]{element}, monitor);
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PortalUI36Plugin.getDefault(), (Throwable)e);
        }
        return allInstalledFeatures;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void repairBundlesInfo() {
        Profile profile;
        SimpleProfileRegistry registry;
        block35: {
            List nowBundles;
            HashMap<String, FeatureEntry> featureNeedPlugins;
            File bundlesInfoFile;
            File installLocation;
            block34: {
                block33: {
                    if (Platform.inDevelopmentMode()) {
                        return;
                    }
                    registry = null;
                    profile = null;
                    ProvisioningUI ui = ProvisioningUI.getDefaultUI();
                    registry = (SimpleProfileRegistry)ProvUI.getProfileRegistry((ProvisioningSession)ui.getSession());
                    profile = (Profile)registry.getProfile(ui.getProfileId());
                    if (profile != null) break block33;
                    try {
                        if (registry == null || profile == null) return;
                        registry.unlockProfile((IProfile)profile);
                        return;
                    }
                    catch (Throwable e) {
                        IdeLog.logError((Plugin)PortalUI36Plugin.getDefault(), (Throwable)e);
                    }
                    return;
                }
                registry.lockProfile(profile);
                installLocation = ResourceUtil.resourcePathToFile((URL)Platform.getInstallLocation().getURL());
                bundlesInfoFile = new File(installLocation, "configuration/org.eclipse.equinox.simpleconfigurator/bundles.info");
                List<IInstallableUnit> allInstalledFeatures = PluginsConfigurationProcessor.getAllInstalledFeatures();
                featureNeedPlugins = new HashMap<String, FeatureEntry>();
                FeatureParser featureParser = new FeatureParser();
                for (IInstallableUnit installedFeature : allInstalledFeatures) {
                    FeatureEntry[] entrys;
                    Feature feature;
                    String id = installedFeature.getId().replace(FEATURE_IU_SUFFIX, "");
                    File file = new File(installLocation, "features/" + id + "_" + installedFeature.getVersion());
                    if (!file.exists() || (feature = featureParser.parse(file)) == null || (entrys = feature.getEntries()) == null) continue;
                    FeatureEntry[] featureEntryArray = entrys;
                    int n = entrys.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FeatureEntry entry = featureEntryArray[n2];
                        if (entry.isPlugin()) {
                            if (featureNeedPlugins.containsKey(entry.getId())) {
                                FeatureEntry hasFeature = (FeatureEntry)featureNeedPlugins.get(entry.getId());
                                if (new Version(hasFeature.getVersion()).compareTo(new Version(entry.getVersion())) < 0) {
                                    featureNeedPlugins.put(entry.getId(), entry);
                                }
                            } else {
                                featureNeedPlugins.put(entry.getId(), entry);
                            }
                        }
                        ++n2;
                    }
                }
                nowBundles = SimpleConfiguratorUtils.readConfiguration((URL)bundlesInfoFile.toURI().toURL(), (URI)installLocation.toURI());
                if (nowBundles != null && !nowBundles.isEmpty()) break block34;
                IdeLog.logError((Plugin)PortalUI36Plugin.getDefault(), (String)"\u65e0\u6cd5\u8bfb\u53d6bundles.info\u4fe1\u606f");
                try {
                    if (registry == null || profile == null) return;
                    registry.unlockProfile((IProfile)profile);
                    return;
                }
                catch (Throwable e) {
                    IdeLog.logError((Plugin)PortalUI36Plugin.getDefault(), (Throwable)e);
                }
                return;
            }
            try {
                try {
                    LinkedHashMap<String, Object> nowBundlesMap = new LinkedHashMap<String, Object>();
                    for (BundleInfo nowBundleInfo : nowBundles) {
                        if (nowBundlesMap.containsKey(nowBundleInfo.getSymbolicName())) {
                            ((List)nowBundlesMap.get(nowBundleInfo.getSymbolicName())).add(nowBundleInfo);
                            continue;
                        }
                        ArrayList list = new ArrayList();
                        list.add(nowBundleInfo);
                        nowBundlesMap.put(nowBundleInfo.getSymbolicName(), list);
                    }
                    boolean hasAdd = false;
                    for (String id : featureNeedPlugins.keySet()) {
                        FeatureEntry featureEntry = (FeatureEntry)featureNeedPlugins.get(id);
                        if (nowBundlesMap.containsKey(id)) {
                            List list = (List)nowBundlesMap.get(id);
                            boolean hasSame = false;
                            for (BundleInfo info : list) {
                                if (!info.getVersion().equals(featureEntry.getVersion())) continue;
                                hasSame = true;
                                break;
                            }
                            if (hasSame) continue;
                        }
                        StringBuilder location = new StringBuilder("plugins/").append(featureEntry.getId()).append("_").append(featureEntry.getVersion());
                        location = featureEntry.isUnpack() ? location.append("/") : location.append(".jar");
                        if (!new File(installLocation, location.toString()).exists()) continue;
                        IdeLog.logError((Plugin)PortalUI36Plugin.getDefault(), (String)("\u6dfb\u52a0\u7f3a\u5c11\u7684\u63d2\u4ef6\u4fe1\u606f: " + featureEntry));
                        List<BundleInfo> list = nowBundlesMap.containsKey(id) ? (List)nowBundlesMap.get(id) : new ArrayList();
                        list.add(new BundleInfo(featureEntry.getId(), featureEntry.getVersion(), new URI(location.toString()), 4, false));
                        nowBundlesMap.put(id, list);
                        hasAdd = true;
                    }
                    ArrayList result = new ArrayList();
                    if (hasAdd) {
                        Collection lists = nowBundlesMap.values();
                        for (List list : lists) {
                            result.addAll(list);
                        }
                    } else {
                        result.addAll(nowBundles);
                    }
                    Collections.sort(result, new Comparator<BundleInfo>(){

                        @Override
                        public int compare(BundleInfo o1, BundleInfo o2) {
                            int result = o1.getSymbolicName().compareTo(o2.getSymbolicName());
                            if (result == 0) {
                                return new Version(o2.getVersion()).compareTo(new Version(o1.getVersion()));
                            }
                            return result;
                        }
                    });
                    if (result.size() < nowBundles.size() || result.equals(nowBundles)) break block35;
                    File backUp = new File(bundlesInfoFile.getParent(), String.valueOf(bundlesInfoFile.getName()) + ".bak");
                    backUp.delete();
                    FileUtil.copyFile((File)bundlesInfoFile, (File)backUp);
                    try {
                        SimpleConfiguratorManipulatorUtils.writeConfiguration((BundleInfo[])result.toArray(new BundleInfo[result.size()]), (File)bundlesInfoFile);
                        IdeLog.logError((Plugin)PortalUI36Plugin.getDefault(), (String)"\u4fee\u590d\u63d2\u4ef6\u4fe1\u606f");
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)PortalUI36Plugin.getDefault(), (String)"\u4fee\u590dbundles.info\u5931\u8d25, \u8fdb\u884c\u8fd8\u539f", (Throwable)e);
                        if (backUp == null || !backUp.exists() || bundlesInfoFile == null) break block35;
                        FileUtil.copyFile((File)backUp, (File)bundlesInfoFile);
                    }
                }
                catch (Throwable e) {
                    IdeLog.logError((Plugin)PortalUI36Plugin.getDefault(), (Throwable)e);
                    try {
                        if (registry == null || profile == null) return;
                        registry.unlockProfile((IProfile)profile);
                        return;
                    }
                    catch (Throwable e2) {
                        IdeLog.logError((Plugin)PortalUI36Plugin.getDefault(), (Throwable)e2);
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (registry == null || profile == null) throw throwable;
                    registry.unlockProfile(profile);
                    throw throwable;
                }
                catch (Throwable e) {
                    IdeLog.logError((Plugin)PortalUI36Plugin.getDefault(), (Throwable)e);
                }
                throw throwable;
            }
        }
        try {
            if (registry == null || profile == null) return;
            registry.unlockProfile((IProfile)profile);
            return;
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)PortalUI36Plugin.getDefault(), (Throwable)e);
        }
    }

    public static String getInstallingJobName(int family) {
        Job[] jobs = Job.getJobManager().find((Object)family);
        if (jobs != null && jobs.length > 0) {
            Job[] jobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                Job job = jobArray[n2];
                if (job.getState() == 4 || job.getState() == 2 || job.getState() == 1) {
                    return job.getName();
                }
                ++n2;
            }
        }
        return null;
    }

    public static IStatus uninstall(List<String> ids, IProgressMonitor monitor) {
        PluginsConfigurationProcessor.endSystemUpdateJob(monitor);
        ProvisioningUI provisioningUI = ProvisioningUI.getDefaultUI();
        ProvisioningSession session = provisioningUI.getSession();
        List<IInstallableUnit> ies = PluginsConfigurationProcessor.getRootInstalledFeatures();
        if (ies == null || ies.isEmpty()) {
            return Status.CANCEL_STATUS;
        }
        ArrayList<IInstallableUnit> ius = new ArrayList<IInstallableUnit>();
        block0: for (IInstallableUnit element : ies) {
            for (String id : ids) {
                if (!element.getId().equals(id) && !element.getId().equals(String.valueOf(id) + FEATURE_IU_SUFFIX)) continue;
                ius.add(element);
                ids.remove(id);
                continue block0;
            }
        }
        UninstallOperation op = new UninstallOperation(session, ius);
        op.setProfileId(provisioningUI.getProfileId());
        IStatus status = op.resolveModal(monitor);
        if (status.getSeverity() == 8) {
            return status;
        }
        if (status.getSeverity() == 4) {
            IdeLog.logError((Plugin)PortalUI36Plugin.getDefault(), (String)status.getMessage());
            return status;
        }
        status = op.getProvisioningJob(monitor).runModal(monitor);
        return status;
    }

    public static void endSystemUpdateJob(IProgressMonitor monitor) {
        try {
            ArrayList updateJobs = new ArrayList();
            Object[] jobs = Job.getJobManager().find(LoadMetadataRepositoryJob.LOAD_FAMILY);
            CollectionsUtil.addToList(updateJobs, (Object[])jobs);
            try {
                Field field = ProvisioningJob.class.getDeclaredField("JOB_FAMILY");
                field.setAccessible(true);
                Object jobFamily = field.get(null);
                jobs = Job.getJobManager().find(jobFamily);
                CollectionsUtil.addToList(updateJobs, (Object[])jobs);
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)PortalUI36Plugin.getDefault(), (Throwable)e);
            }
            if (updateJobs != null && !updateJobs.isEmpty()) {
                IdeLog.logError((Plugin)PortalUI36Plugin.getDefault(), (String)"\u5173\u95ed\u7cfb\u7edf\u5347\u7ea7\u4efb\u52a1");
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"\u7b49\u5f85\u5176\u4ed6\u64cd\u4f5c\u5b8c\u6210", (int)updateJobs.size());
                for (Job job : updateJobs) {
                    try {
                        job.cancel();
                        job.join();
                        sub.worked(1);
                    }
                    catch (Throwable e) {
                        IdeLog.logError((Plugin)PortalUI36Plugin.getDefault(), (Throwable)e);
                    }
                }
                sub.done();
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)PortalUI36Plugin.getDefault(), (Throwable)e);
        }
    }
}

