/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations.util;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.presentations.SystemMenuCloseAll;
import org.eclipse.ui.internal.presentations.SystemMenuCloseLeft;
import org.eclipse.ui.internal.presentations.SystemMenuCloseOthers;
import org.eclipse.ui.internal.presentations.SystemMenuCloseRight;
import org.eclipse.ui.internal.presentations.UpdatingActionContributionItem;
import org.eclipse.ui.internal.presentations.util.StandardViewSystemMenu;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;

public class StandardEditorSystemMenu
extends StandardViewSystemMenu {
    private SystemMenuCloseOthers closeOthers;
    private SystemMenuCloseLeft closeLeft;
    private SystemMenuCloseRight closeRight;
    private SystemMenuCloseAll closeAll;
    private ActionFactory.IWorkbenchAction openAgain;

    public StandardEditorSystemMenu(IStackPresentationSite site) {
        super(site);
        this.closeOthers = new SystemMenuCloseOthers(site);
        this.closeLeft = new SystemMenuCloseLeft(site);
        this.closeRight = new SystemMenuCloseRight(site);
        this.closeAll = new SystemMenuCloseAll(site);
        this.openAgain = ActionFactory.NEW_EDITOR.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        this.menuManager.add((IContributionItem)new UpdatingActionContributionItem(this.closeOthers));
        this.menuManager.add((IContributionItem)new UpdatingActionContributionItem(this.closeLeft));
        this.menuManager.add((IContributionItem)new UpdatingActionContributionItem(this.closeRight));
        this.menuManager.add((IContributionItem)new UpdatingActionContributionItem(this.closeAll));
        this.menuManager.add((IContributionItem)new Separator());
        this.menuManager.add((IAction)this.openAgain);
    }

    String getMoveMenuText() {
        return WorkbenchMessages.EditorPane_moveEditor;
    }

    public void show(Control parent, Point displayCoordinates, IPresentablePart currentSelection) {
        this.closeOthers.setTarget(currentSelection);
        this.closeLeft.setTarget(currentSelection);
        this.closeRight.setTarget(currentSelection);
        this.closeAll.setTarget(currentSelection);
        super.show(parent, displayCoordinates, currentSelection);
    }

    public void dispose() {
        if (this.openAgain != null) {
            this.openAgain.dispose();
            this.openAgain = null;
        }
        super.dispose();
    }
}

