/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import java.util.LinkedList;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.internal.DefaultStackPresentationSite;
import org.eclipse.ui.internal.presentations.ISelfUpdatingAction;
import org.eclipse.ui.internal.presentations.util.AbstractTabFolder;
import org.eclipse.ui.internal.presentations.util.AbstractTabItem;
import org.eclipse.ui.internal.presentations.util.TabbedStackPresentation;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;

public class SystemMenuCloseRight
extends Action
implements ISelfUpdatingAction {
    private IStackPresentationSite stackPresentation;
    private IPresentablePart current;

    public SystemMenuCloseRight(IStackPresentationSite stackPresentation) {
        this.stackPresentation = stackPresentation;
        this.setText("\u5173\u95ed\u53f3\u4fa7\u6240\u6709(&R)");
    }

    public void dispose() {
        this.stackPresentation = null;
    }

    public void run() {
        LinkedList<Object> others = new LinkedList<Object>();
        TabbedStackPresentation tabbedStackPresentation = (TabbedStackPresentation)((DefaultStackPresentationSite)this.stackPresentation).getPresentation();
        AbstractTabFolder tabFolder = tabbedStackPresentation.getTabFolder();
        AbstractTabItem[] items = tabFolder.getItems();
        int currentIndex = 0;
        int i = items.length - 1;
        while (i >= 0) {
            AbstractTabItem item = items[i];
            if (item.getData().equals(this.current)) {
                currentIndex = i;
            } else if (i < currentIndex && !item.isShowing() || i > currentIndex) {
                others.add(item.getData());
            }
            --i;
        }
        this.stackPresentation.close(others.toArray(new IPresentablePart[others.size()]));
    }

    public void update() {
    }

    public boolean shouldBeVisible() {
        return this.isEnabled();
    }

    public void setTarget(IPresentablePart current) {
        this.current = current;
        try {
            TabbedStackPresentation tabbedStackPresentation = (TabbedStackPresentation)((DefaultStackPresentationSite)this.stackPresentation).getPresentation();
            AbstractTabFolder tabFolder = tabbedStackPresentation.getTabFolder();
            AbstractTabItem[] items = tabFolder.getItems();
            if (items == null || items.length < 2) {
                this.setEnabled(false);
            } else if (items[0].equals(current)) {
                this.setEnabled(false);
            } else {
                boolean leftHasShow = false;
                boolean hasNotShow = false;
                int currentIndex = items.length - 1;
                int i = 0;
                while (i < items.length) {
                    AbstractTabItem item = items[i];
                    if (item.getData().equals(current)) {
                        currentIndex = i;
                    } else if (!item.isShowing()) {
                        hasNotShow = true;
                    } else if (i < currentIndex && item.isShowing()) {
                        leftHasShow = true;
                    }
                    ++i;
                }
                if (items[items.length - 1].getData().equals(current)) {
                    this.setEnabled(leftHasShow && hasNotShow);
                } else {
                    this.setEnabled(leftHasShow);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setEnabled(false);
        }
    }
}

