/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class WorkbenchHelper {
    private static List parts = new ArrayList();

    public static void setViewBackground(Control control) {
        if (control == null || control.isDisposed()) {
            return;
        }
        try {
            String key = "org.eclipse.ui.workbench.ACTIVE_NOFOCUS_TAB_BG_END";
            String colorValue = JFacePreferences.getPreferenceStore().getString(key);
            RGB rgb = StringConverter.asRGB((String)colorValue);
            Color color = new Color((Device)control.getDisplay(), rgb);
            control.setBackground(color);
            parts.add(control);
            color.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void resetPartBackground() {
        int length = parts.size();
        int i = 0;
        while (i < length) {
            Object part = parts.get(i);
            if (part instanceof Composite) {
                Composite ctl = (Composite)part;
                WorkbenchHelper.setDefaultBackground((Control)ctl);
            }
            ++i;
        }
        parts.clear();
    }

    public static void setDefaultBackground(Control control) {
        if (control == null || control.isDisposed()) {
            return;
        }
        RGB rgb = StringConverter.asRGB((String)"255,252,245");
        Color color = new Color((Device)control.getDisplay(), rgb);
        control.setBackground(color);
        color.dispose();
    }
}

