/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui;

import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class StartupUtil {
    static Set postEmptyStartups = new TreeSet();
    static Set postPostEmptyStartups = new TreeSet();
    static Set postLayoutStartups = new TreeSet();
    static Set postPostLayoutStartups = new TreeSet();
    static StartRunable endAll = null;
    public static final int POST_EMPTY = 0;
    public static final int POST_POST_EMPTY = 1;
    public static final int POST_LAYOUT = 2;
    public static final int POST_POST_LAYOUT = 3;
    public static final int END_ALL = 10;
    public static boolean lazy = true;
    private static int last = 100;

    public static void addLazyRunable(int type, StartRunable runable) {
        if (StartupUtil.isLazyMode()) {
            if (type == 10) {
                endAll = runable;
            } else {
                StartupUtil.getStartups(type).add(runable);
            }
        } else {
            runable.run();
        }
    }

    private static Set getStartups(int type) {
        switch (type) {
            case 0: {
                return postEmptyStartups;
            }
            case 1: {
                return postPostEmptyStartups;
            }
            case 2: {
                return postLayoutStartups;
            }
            case 3: {
                return postPostLayoutStartups;
            }
            case 10: {
                HashSet<StartRunable> set = new HashSet<StartRunable>();
                set.add(endAll);
                return set;
            }
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u56de\u8c03\u7c7b\u578b\uff1a" + type);
    }

    public static void startup(int type) {
        Iterator startupsIt = StartupUtil.getStartups(type).iterator();
        try {
            while (startupsIt.hasNext()) {
                Runnable runable;
                Object o = startupsIt.next();
                startupsIt.remove();
                if (o instanceof UIStartRunable) {
                    runable = (UIStartRunable)o;
                    Display.getDefault().syncExec(runable);
                    continue;
                }
                if (!(o instanceof StartRunable)) continue;
                runable = (Runnable)o;
                runable.run();
            }
        }
        catch (ConcurrentModificationException e) {
            StartupUtil.startup(type);
        }
        StartupUtil.clearStartup(type);
    }

    public static void clearStartup(int type) {
        StartupUtil.getStartups(type).clear();
    }

    public static boolean isLazyMode() {
        return PlatformUI.getWorkbench().isStarting() && lazy;
    }

    public static int last() {
        return last++;
    }

    public static abstract class StartRunable
    implements Runnable,
    Comparable {
        private static int NUM = 10;
        private String name;
        private int order = NUM++;

        public StartRunable(String name) {
            this.name = name;
        }

        public StartRunable(String name, int order) {
            this.name = name;
            if (order >= 0) {
                this.order = order;
            }
        }

        public String toString() {
            return String.valueOf(this.name != null ? this.name : super.toString()) + " : " + this.order;
        }

        public int compareTo(Object o) {
            if (this == o) {
                return 0;
            }
            if (o instanceof StartRunable) {
                int result = this.order - ((StartRunable)o).order;
                return result == 0 ? 1 : result;
            }
            return 1;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + this.order;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StartRunable other = (StartRunable)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.order == other.order;
        }
    }

    public static abstract class UIStartRunable
    extends StartRunable {
        public UIStartRunable(String name) {
            super(name);
        }

        public UIStartRunable(String name, int order) {
            super(name, order);
        }
    }
}

