/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.projects.templates;

import com.pandora.core.log.HBLog;
import com.pandora.core.utils.FileUtil;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.StringUtil;
import com.pandora.projects.core.Activator;
import com.pandora.projects.templates.FileTemplate;
import com.pandora.projects.templates.TemplateType;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class FileTemplatesManager {
    private static final String README_FILE_NAME = "readme.txt";
    private static final String OS_NAME = "os.name";
    private static final String OS_NAME_LINUX = "linux";
    private static final String OS_NAME_MAC = "mac";
    private static final String USER_HOME_PROPERTY = "user.home";
    private static final String USER_TEMPLATES_DIRECTORY_GENERAL = "/HBuilder settings/Templates/";
    private static final String USER_TEMPLATES_DIRECTORY_MACOSX = "/Documents/HBuilder settings/Templates/";
    public static final String TEMPLATE_FILE_PATH = "/templates/file/";
    public static final String TEMPLATE_GROUP_PATH = "/templates/group/";
    private static FileTemplatesManager fileTemplatesManager = new FileTemplatesManager();

    private FileTemplatesManager() {
        File userpath = new File(this.getUserTemplatePath("", null));
        if (!userpath.exists()) {
            userpath.mkdirs();
        }
    }

    public static FileTemplatesManager getInstance() {
        return fileTemplatesManager;
    }

    public List<FileTemplate> getAllTemplates(String fileExtension, TemplateType templateType) {
        List<FileTemplate> list = Collections.emptyList();
        if (StringUtil.isNotEmpty((String)fileExtension)) {
            try {
                list = this.getSysTemplates(fileExtension, templateType);
                list.addAll(this.getUserTemplates(fileExtension, templateType));
                Collections.sort(list);
            }
            catch (IOException e) {
                HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
            }
        }
        return list;
    }

    private List<FileTemplate> getSysTemplates(final String fileExtension, final TemplateType templateType) throws IOException {
        URL url = Activator.getDefault().getBundle().getResource(String.valueOf(templateType == TemplateType.FILE ? TEMPLATE_FILE_PATH : TEMPLATE_GROUP_PATH) + fileExtension);
        if (url == null) {
            return new ArrayList<FileTemplate>();
        }
        File path = new File(FileLocator.toFileURL((URL)url).getFile());
        final ArrayList<FileTemplate> list = new ArrayList<FileTemplate>();
        path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isFile() && (templateType == TemplateType.FILE && pathname.getName().toLowerCase().endsWith("." + fileExtension) || templateType == TemplateType.GROUP && pathname.getName().toLowerCase().endsWith(".zip"))) {
                    String name = pathname.getName();
                    if (name.indexOf(".") >= 0) {
                        name = pathname.getName().substring(0, pathname.getName().lastIndexOf(46));
                    }
                    try {
                        list.add(new FileTemplate(name, pathname.getName(), fileExtension, true, pathname, templateType));
                    }
                    catch (Exception exception) {}
                }
                return false;
            }
        });
        Collections.sort(list);
        return list;
    }

    public File getReadmeFile(TemplateType templateType) throws IOException {
        URL url = Activator.getDefault().getBundle().getResource(String.valueOf(templateType == TemplateType.FILE ? TEMPLATE_FILE_PATH : TEMPLATE_GROUP_PATH) + README_FILE_NAME);
        if (url == null) {
            return null;
        }
        return new File(FileLocator.toFileURL((URL)url).getFile());
    }

    private List<FileTemplate> getUserTemplates(final String fileExtension, final TemplateType templateType) throws IOException {
        File path = new File(this.getUserTemplatePath(fileExtension, templateType));
        final ArrayList<FileTemplate> list = new ArrayList<FileTemplate>();
        path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name;
                if (pathname.isFile() && (templateType == TemplateType.FILE || templateType == TemplateType.GROUP && pathname.getName().toLowerCase().endsWith(".zip")) && !(name = pathname.getName()).equals(FileTemplatesManager.README_FILE_NAME)) {
                    if (name.indexOf(".") > 0) {
                        name = pathname.getName().substring(0, pathname.getName().lastIndexOf(46));
                    }
                    try {
                        list.add(new FileTemplate(name, pathname.getName(), fileExtension, false, pathname, templateType));
                    }
                    catch (Exception exception) {}
                }
                return false;
            }
        });
        Collections.sort(list);
        return list;
    }

    public String getUserTemplatePath(String fileExtension, TemplateType templateType) {
        String OS = null;
        if (Platform.isRunning()) {
            OS = Platform.getOS();
        } else {
            OS = System.getProperty(OS_NAME).toLowerCase();
            if (OS.contains(OS_NAME_MAC)) {
                OS = "macosx";
            } else if (OS.contains(OS_NAME_LINUX)) {
                OS = OS_NAME_LINUX;
            }
        }
        if (StringUtil.isNotBlank((String)fileExtension) && templateType == TemplateType.GROUP) {
            fileExtension = String.valueOf(fileExtension) + ".group";
        }
        String userHome = System.getProperty(USER_HOME_PROPERTY);
        if (OS.equals("macosx") || OS.equals(OS_NAME_LINUX)) {
            return String.valueOf(userHome) + USER_TEMPLATES_DIRECTORY_MACOSX + fileExtension;
        }
        return String.valueOf(userHome) + USER_TEMPLATES_DIRECTORY_GENERAL + fileExtension;
    }

    public File createUserTemplatePath(String fileExtension, TemplateType templateType) throws IOException {
        File systemReadme;
        File path = new File(FileTemplatesManager.getInstance().getUserTemplatePath(fileExtension, templateType));
        path.mkdirs();
        File readme = new File(path, README_FILE_NAME);
        if (!readme.exists() && (systemReadme = this.getReadmeFile(templateType)) != null && systemReadme.exists()) {
            FileUtil.copyFile((File)systemReadme, (File)readme);
        }
        return path;
    }

    public String getEncode(FileTemplate template) {
        String encode = "gb2312";
        if (!template.isSystem() && !PlatformUtil.isWindows()) {
            encode = "utf-8";
        }
        return encode;
    }
}

