/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.stats.core.dto;

import com.pandora.core.utils.ProductUtils;

public class EnvironmentInfo {
    private String osName = null;
    private String osbit = null;
    private String jvmVersion = null;
    private String ideVersion = null;
    private String osVersion = null;
    private static EnvironmentInfo info = null;

    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    private EnvironmentInfo() {
    }

    public static EnvironmentInfo getDefault() {
        if (info == null) {
            info = new EnvironmentInfo();
            EnvironmentInfo.init();
        }
        return info;
    }

    private static void init() {
        String osName = System.getProperty("os.name");
        String osbit = System.getProperty("os.arch");
        String jvmVersion = System.getProperty("java.version");
        String osVersion = System.getProperty("os.version");
        info.setOsName(osName);
        info.setOsbit(osbit);
        info.setJvmVersion(jvmVersion);
        info.setIdeVersion(ProductUtils.getProductVersion());
        info.setOsVersion(osVersion);
    }

    public String getOsName() {
        return String.valueOf(this.osName) + " " + this.osVersion;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public String getOsbit() {
        return this.osbit;
    }

    public void setOsbit(String osbit) {
        this.osbit = osbit;
    }

    public String getJvmVersion() {
        return this.jvmVersion;
    }

    public void setJvmVersion(String jvmVersion) {
        this.jvmVersion = jvmVersion;
    }

    public String getIdeVersion() {
        return this.ideVersion;
    }

    public void setIdeVersion(String ideVersion) {
        this.ideVersion = ideVersion;
    }

    public String toString() {
        return "EnvironmentInfo [osName=" + this.osName + ", osbit=" + this.osbit + ", jvmVersion=" + this.jvmVersion + ", ideVersion=" + this.ideVersion + "]";
    }
}

