/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.stats.core;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.pandora.core.stats.DD;
import com.pandora.core.utils.PropertiesHelper;
import com.pandora.stats.core.Activator;
import com.pandora.stats.core.api.Stats;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class DefaultIDEListenter
implements IStartup,
IResourceChangeListener,
IResourceDeltaVisitor {
    private Map<String, String> projectMap = new HashMap<String, String>();
    private final IPartListener fPartListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
            try {
                IEditorPart editorPart;
                if (part instanceof IEditorPart && "com.pandora.editor.php".equals((editorPart = (IEditorPart)part).getEditorSite().getId())) {
                    Stats.addOperateInfo("OF", editorPart.getTitle(), "com.pandora.editor.php");
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
            }
        }
    };

    public DefaultIDEListenter() {
        this.projectMap.put("org.eclipse.jdt.core.javanature", "NPJ");
        this.projectMap.put("com.pandora.projects.ui.MKeyNature", "NPH");
        this.projectMap.put("com.aptana.editor.php.phpNature", "NPP");
        this.projectMap.put("com.aptana.projects.webnature", "NPW");
    }

    public void earlyStartup() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DefaultIDEListenter.this.addIDEListener();
            }
        });
        this.uploadScheduleConfiguration();
    }

    public void uploadScheduleConfiguration() {
        try {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            if (store.getBoolean("uploadScheduleConfiguration")) {
                return;
            }
            String PROPFILEPATH = String.valueOf(System.getenv().get("APPDATA")) + "/HBuilder/configuration.properties";
            File propFile = new File(PROPFILEPATH);
            if (propFile.exists()) {
                Properties props = PropertiesHelper.load((File)propFile);
                Stats.addOperateInfo("Schedule", "Schedule", props.toString());
                store.setValue("uploadScheduleConfiguration", true);
                if (store instanceof ScopedPreferenceStore) {
                    ((ScopedPreferenceStore)store).save();
                }
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
        }
    }

    public void addIDEListener() {
        try {
            this.addResourceListener();
            this.addPartListener();
            this.addBundleListener();
        }
        catch (Exception e) {
            Stats.addExceptionInfo(e);
        }
    }

    protected void addBundleListener() {
        Bundle b = Activator.getDefault().getBundle();
        if (b == null) {
            return;
        }
        BundleContext bc = b.getBundleContext();
        if (bc == null) {
            return;
        }
        final HashSet<String> recordBundles = new HashSet<String>();
        recordBundles.add("com.aptana.editor.php");
        Bundle[] bundleArray = bc.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle sBundle = bundleArray[n2];
            if (recordBundles.contains(sBundle.getSymbolicName())) {
                Stats.addOperateInfo(DD.BUNDLE, "started", sBundle.getSymbolicName());
            }
            ++n2;
        }
        bc.addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getType() == 2 && recordBundles.contains(event.getBundle().getSymbolicName())) {
                    Stats.addOperateInfo(DD.BUNDLE, "started", event.getBundle().getSymbolicName());
                }
            }
        });
    }

    private void addCommandListener() {
        this.getCommandService().addExecutionListener(new IExecutionListener(){

            public void preExecute(String commandId, ExecutionEvent event) {
            }

            public void postExecuteSuccess(String commandId, Object returnValue) {
                Stats.addOperateInfo("COMMAND", commandId, "" + returnValue);
            }

            public void postExecuteFailure(String commandId, ExecutionException exception) {
                Stats.addOperateInfo("COMMAND", commandId, exception == null ? "failure" : exception.getMessage());
            }

            public void notHandled(String commandId, NotHandledException exception) {
                Stats.addOperateInfo("COMMAND", commandId, exception == null ? "notHandled" : exception.getMessage());
            }
        });
    }

    private ICommandService getCommandService() {
        return (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
    }

    protected void addResourceListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 7);
    }

    private void addPartListener() {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null) {
                IWorkbenchWindow[] windows;
                IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
                int n = windows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IPartService partService = window.getPartService();
                    if (partService != null) {
                        partService.addPartListener(this.fPartListener);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {}
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            if (event.getDelta() != null) {
                event.getDelta().accept((IResourceDeltaVisitor)this);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (delta.getResource() instanceof IProject) {
            if (delta.getKind() == 1) {
                this.handleResourceAdded(delta.getResource());
            }
            return false;
        }
        return !(delta.getResource() instanceof IFolder) && !(delta.getResource() instanceof IFile);
    }

    private void handleResourceAdded(IResource res) throws CoreException {
        if (res == null) {
            return;
        }
        if (res instanceof IProject) {
            String[] natureIds;
            IProject p = (IProject)res;
            IProjectDescription desc = p.getDescription();
            String natureId = null;
            if (desc != null && (natureIds = p.getDescription().getNatureIds()).length > 0) {
                natureId = natureIds[0];
            }
            if (natureId != null) {
                Stats.addOperateInfo("project", this.projectMap.get(natureId) == null ? "NPA" : this.projectMap.get(natureId), natureId);
            } else {
                Stats.addOperateInfo("project", "NPA", natureId);
            }
        } else {
            boolean cfr_ignored_0 = res instanceof IFile;
        }
    }
}

