/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal.views;

import com.aptana.debug.core.util.DebugUtil;
import com.aptana.js.debug.core.model.IJSDebugTarget;
import com.aptana.js.debug.ui.internal.JSDebugModelPresentation;
import com.aptana.js.debug.ui.internal.actions.OpenScriptSourceAction;
import com.aptana.js.debug.ui.internal.scripts.ScriptsContentProvider;
import com.aptana.js.debug.ui.internal.scripts.ScriptsViewer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class ScriptsView
extends AbstractDebugView
implements IDebugEventSetListener {
    private static final String GOTO_FILE_ACTION = "GotoFile";
    private ISelectionListener selectionListener;
    private IDebugTarget currentTarget;
    private boolean currentTerminated;

    protected Viewer createViewer(Composite parent) {
        ScriptsViewer treeViewer = new ScriptsViewer(parent, 268501762);
        treeViewer.setContentProvider((IContentProvider)new ScriptsContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new JSDebugModelPresentation());
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.getSite().getPage().addPostSelectionListener("org.eclipse.debug.ui.DebugView", this.getSelectionListener());
        return treeViewer;
    }

    public void dispose() {
        this.getSite().getPage().removePostSelectionListener("org.eclipse.debug.ui.DebugView", this.getSelectionListener());
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        super.dispose();
    }

    protected void createActions() {
        OpenScriptSourceAction action = new OpenScriptSourceAction((ISelectionProvider)this.getViewer());
        this.setAction(GOTO_FILE_ACTION, (IAction)action);
        this.setAction("Double_Click_ActionId", (IAction)action);
    }

    protected String getHelpContextId() {
        return null;
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add(this.getAction(GOTO_FILE_ACTION));
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add(this.getAction(GOTO_FILE_ACTION));
    }

    protected void becomesHidden() {
        this.setViewerInput(null);
        super.becomesHidden();
    }

    protected void becomesVisible() {
        super.becomesVisible();
        this.setViewerInput(this.getCurrentDebugTarget());
    }

    private ISelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    if (!ScriptsView.this.isAvailable() || !ScriptsView.this.isVisible()) {
                        return;
                    }
                    ScriptsView.this.setViewerInput(ScriptsView.this.getCurrentDebugTarget());
                }
            };
        }
        return this.selectionListener;
    }

    private void setViewerInput(IDebugTarget target) {
        if (!(target instanceof IJSDebugTarget) || ((IJSDebugTarget)target).isTerminated()) {
            target = null;
        }
        if (this.currentTarget == null && target == null) {
            return;
        }
        if (this.currentTarget != null && this.currentTarget.equals(target)) {
            return;
        }
        this.currentTarget = target;
        this.getViewer().setInput((Object)target);
        this.showViewer();
    }

    protected IDebugTarget getCurrentDebugTarget() {
        Object debugInput;
        IViewPart debugViewPart;
        IAdaptable adaptable = DebugUITools.getDebugContext();
        if (adaptable == null && (debugViewPart = this.getSite().getPage().findView("org.eclipse.debug.ui.DebugView")) != null && (debugInput = ((AbstractDebugView)debugViewPart).getViewer().getInput()) instanceof ILaunchManager) {
            IDebugTarget[] debugTargets = ((ILaunchManager)debugInput).getDebugTargets();
            if (debugTargets.length > 0) {
                adaptable = debugTargets[0];
            } else {
                IProcess[] debugProcesses = ((ILaunchManager)debugInput).getProcesses();
                if (debugProcesses.length > 0) {
                    adaptable = debugProcesses[0];
                }
            }
        }
        return (IDebugTarget)DebugUtil.findAdapter((IAdaptable)adaptable, IDebugTarget.class);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            Object source = event.getSource();
            if (this.currentTarget == null || this.currentTerminated) {
                if (event.getKind() == 4 && source instanceof IDebugTarget) {
                    this.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (ScriptsView.this.currentTarget == null || ScriptsView.this.currentTerminated) {
                                ScriptsView.this.currentTerminated = false;
                                ScriptsView.this.setViewerInput(ScriptsView.this.getCurrentDebugTarget());
                            }
                        }
                    });
                }
            } else if (event.getKind() == 8 && source instanceof IDebugTarget) {
                this.currentTerminated = true;
            }
            if (this.currentTarget != null && source == this.currentTarget) {
                switch (event.getKind()) {
                    case 16: {
                        if (event.getDetail() != 512) break;
                        this.getViewer().getControl().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ScriptsView.this.getViewer().refresh();
                            }
                        });
                    }
                }
            }
            ++n2;
        }
    }
}

