/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal.views;

import com.aptana.debug.core.util.DebugUtil;
import com.aptana.js.debug.core.model.xhr.IXHRService;
import com.aptana.js.debug.ui.internal.views.Messages;
import com.aptana.js.debug.ui.internal.xhr.AJAXMonitorPage;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.PageBook;

public class AJAXMonitorView
extends AbstractDebugView
implements IDebugEventSetListener {
    private ISelectionListener selectionListener;
    private IXHRService current;
    private boolean currentTerminated;

    protected void configureToolBar(IToolBarManager tbm) {
    }

    protected void createActions() {
    }

    protected Viewer createViewer(Composite parent) {
        throw new IllegalArgumentException("should not be called");
    }

    protected void fillContextMenu(IMenuManager menu) {
    }

    protected String getHelpContextId() {
        return null;
    }

    protected IPage createDefaultPage(PageBook book) {
        AJAXMonitorPage page = new AJAXMonitorPage();
        page.createControl((Composite)book);
        this.setViewer(page.getViewer());
        this.initPage((IPageBookViewPage)page);
        this.updateTitle();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.getSite().getPage().addPostSelectionListener("org.eclipse.debug.ui.DebugView", this.getSelectionListener());
        return page;
    }

    private void updateTitle() {
        int count = 0;
        if (this.current != null) {
            count = this.current.getTransfersCount();
        }
        this.setContentDescription(MessageFormat.format(Messages.AJAXMonitorView_items_0, count));
    }

    public void dispose() {
        this.getSite().getPage().removePostSelectionListener("org.eclipse.debug.ui.DebugView", this.getSelectionListener());
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        super.dispose();
    }

    protected IXHRService getCurrentXHRService() {
        IDebugTarget target;
        Object debugInput;
        IViewPart debugViewPart;
        IAdaptable adaptable = DebugUITools.getDebugContext();
        if (adaptable == null && (debugViewPart = this.getSite().getPage().findView("org.eclipse.debug.ui.DebugView")) != null && (debugInput = ((AbstractDebugView)debugViewPart).getViewer().getInput()) instanceof ILaunchManager) {
            IDebugTarget[] debugTargets = ((ILaunchManager)debugInput).getDebugTargets();
            if (debugTargets.length > 0) {
                adaptable = debugTargets[0];
            } else {
                IProcess[] debugProcesses = ((ILaunchManager)debugInput).getProcesses();
                if (debugProcesses.length > 0) {
                    adaptable = debugProcesses[0];
                }
            }
        }
        if ((target = (IDebugTarget)DebugUtil.findAdapter((IAdaptable)adaptable, IDebugTarget.class)) != null) {
            return (IXHRService)target.getAdapter(IXHRService.class);
        }
        return null;
    }

    private void setViewerInput(IXHRService input) {
        if (this.current == null && input == null) {
            return;
        }
        if (this.current != null && this.current.equals(input)) {
            return;
        }
        this.current = input;
        this.getViewer().setInput((Object)input);
        this.updateTitle();
        this.showViewer();
    }

    protected void becomesHidden() {
        this.getViewer().setInput(null);
        this.showViewer();
        super.becomesHidden();
    }

    protected void becomesVisible() {
        super.becomesVisible();
        if (this.current != null) {
            this.getViewer().setInput((Object)this.current);
            this.showViewer();
        } else {
            this.setViewerInput(this.getCurrentXHRService());
        }
        if (this.getViewer().getSelection().isEmpty() && this.current != null && this.current.getTransfersCount() > 0) {
            this.getViewer().setSelection((ISelection)new StructuredSelection((Object)this.current.getTransfers()[0]));
        }
    }

    private ISelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    if (!AJAXMonitorView.this.isAvailable() || !AJAXMonitorView.this.isVisible()) {
                        return;
                    }
                    AJAXMonitorView.this.setViewerInput(AJAXMonitorView.this.getCurrentXHRService());
                }
            };
        }
        return this.selectionListener;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                Object data;
                DebugEvent event;
                block12: {
                    Object source;
                    block11: {
                        block9: {
                            event = debugEventArray[n2];
                            source = event.getSource();
                            data = event.getData();
                            if (this.current != null && !this.currentTerminated) break block9;
                            if (event.getKind() == 4 && (source instanceof IDebugTarget || source instanceof IProcess)) {
                                this.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (AJAXMonitorView.this.current == null || AJAXMonitorView.this.currentTerminated) {
                                            AJAXMonitorView.this.currentTerminated = false;
                                            AJAXMonitorView.this.setViewerInput(AJAXMonitorView.this.getCurrentXHRService());
                                        }
                                    }
                                });
                            }
                            break block10;
                        }
                        if (event.getKind() != 8 || !(source instanceof IDebugTarget) && !(source instanceof IProcess)) break block11;
                        this.currentTerminated = true;
                        break block12;
                    }
                    if (source != this.current) break block10;
                }
                switch (event.getKind()) {
                    case 16: {
                        this.getViewer().getControl().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (data != null) {
                                    ((StructuredViewer)AJAXMonitorView.this.getViewer()).update((Object)AJAXMonitorView.this.current, null);
                                } else {
                                    AJAXMonitorView.this.updateTitle();
                                    ((StructuredViewer)AJAXMonitorView.this.getViewer()).refresh((Object)AJAXMonitorView.this.current);
                                }
                            }
                        });
                        break;
                    }
                }
            }
            ++n2;
        }
    }
}

