/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal.propertypages;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.resources.IUniformResourceMarker;
import com.aptana.debug.core.util.DebugUtil;
import com.aptana.debug.ui.DebugUiPlugin;
import com.aptana.js.debug.core.model.IJSLineBreakpoint;
import com.aptana.js.debug.ui.JSDebugUIPlugin;
import com.aptana.js.debug.ui.internal.propertypages.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class JSLineBreakpointPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Button fEnabledButton;
    private Button fHitCountButton;
    private Text fHitCountText;
    private Button fEnableConditionButton;
    private Text fConditionEditor;
    private Button fConditionIsTrue;
    private Button fConditionHasChanged;
    private List<String> fErrorMessages = new ArrayList<String>();
    private static final String fgHitCountErrorMessage = Messages.JSLineBreakpointPropertyPage_HitCountMustBePositiveInteger;
    private static final String fgEmptyConditionErrorMessage = Messages.JSLineBreakpointPropertyPage_EnterCondition;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite mainComposite = this.createComposite(parent, 1);
        this.createLabels(mainComposite);
        try {
            this.createEnabledButton(mainComposite);
            this.createHitCountEditor(mainComposite);
            this.createTypeSpecificEditors(mainComposite);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (Throwable)e);
        }
        this.setValid(true);
        return mainComposite;
    }

    private void createLabels(Composite parent) {
        IJSLineBreakpoint breakpoint = this.getBreakpoint();
        Composite labelComposite = this.createComposite(parent, 2);
        IMarker marker = breakpoint.getMarker();
        String fileName = marker instanceof IUniformResourceMarker ? DebugUtil.getPath((Object)((IUniformResourceMarker)marker).getUniformResource()) : marker.getResource().getFullPath().toString();
        if (fileName != null) {
            this.createLabel(labelComposite, Messages.JSLineBreakpointPropertyPage_File);
            this.createLabel(labelComposite, fileName);
        }
        this.createTypeSpecificLabels(labelComposite);
    }

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composit = new Composite(parent, 0);
        composit.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composit.setLayout((Layout)layout);
        composit.setLayoutData((Object)new GridData(768));
        return composit;
    }

    protected Text createText(Composite parent, String initialValue) {
        Composite textComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        textComposite.setLayout((Layout)layout);
        textComposite.setLayoutData((Object)new GridData(768));
        textComposite.setFont(parent.getFont());
        Text text = new Text(textComposite, 2052);
        text.setText(initialValue);
        text.setFont(parent.getFont());
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    protected Text createMultiText(Composite parent, String initialValue) {
        Composite textComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        textComposite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        textComposite.setLayoutData((Object)data);
        textComposite.setFont(parent.getFont());
        Text text = new Text(textComposite, 2050);
        text.setText(initialValue);
        text.setFont(parent.getFont());
        text.setLayoutData((Object)new GridData(1808));
        return text;
    }

    private void createEnabledButton(Composite parent) throws CoreException {
        this.fEnabledButton = this.createCheckButton(parent, Messages.JSLineBreakpointPropertyPage_Enabled);
        this.fEnabledButton.setSelection(this.getBreakpoint().isEnabled());
    }

    protected Button createCheckButton(Composite parent, String text) {
        Button button = new Button(parent, 16416);
        button.setText(text);
        button.setFont(parent.getFont());
        button.setLayoutData((Object)new GridData());
        return button;
    }

    protected Button createRadioButton(Composite parent, String text) {
        Button button = new Button(parent, 16400);
        button.setText(text);
        button.setFont(parent.getFont());
        button.setLayoutData((Object)new GridData());
        return button;
    }

    private void createHitCountEditor(Composite parent) throws CoreException {
        IJSLineBreakpoint breakpoint = this.getBreakpoint();
        Composite hitCountComposite = this.createComposite(parent, 2);
        this.fHitCountButton = this.createCheckButton(hitCountComposite, Messages.JSLineBreakpointPropertyPage_HitCount);
        this.fHitCountButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JSLineBreakpointPropertyPage.this.fHitCountText.setEnabled(JSLineBreakpointPropertyPage.this.fHitCountButton.getSelection());
                JSLineBreakpointPropertyPage.this.hitCountChanged();
            }
        });
        int hitCount = breakpoint.getHitCount();
        String hitCountString = "";
        if (hitCount > 0) {
            hitCountString = Integer.toString(hitCount);
            this.fHitCountButton.setSelection(true);
        } else {
            this.fHitCountButton.setSelection(false);
        }
        this.fHitCountText = this.createText(hitCountComposite, hitCountString);
        if (hitCount <= 0) {
            this.fHitCountText.setEnabled(false);
        }
        this.fHitCountText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JSLineBreakpointPropertyPage.this.hitCountChanged();
            }
        });
    }

    private void hitCountChanged() {
        if (!this.fHitCountButton.getSelection()) {
            this.removeErrorMessage(fgHitCountErrorMessage);
            return;
        }
        String hitCountText = this.fHitCountText.getText();
        int hitCount = -1;
        try {
            hitCount = Integer.parseInt(hitCountText);
        }
        catch (NumberFormatException numberFormatException) {
            this.addErrorMessage(fgHitCountErrorMessage);
            return;
        }
        if (hitCount < 1) {
            this.addErrorMessage(fgHitCountErrorMessage);
        } else if (fgHitCountErrorMessage.equals(this.getErrorMessage())) {
            this.removeErrorMessage(fgHitCountErrorMessage);
        }
    }

    private void conditionChanged() {
        if (!this.fEnableConditionButton.getSelection()) {
            this.removeErrorMessage(fgEmptyConditionErrorMessage);
            return;
        }
        String conditionText = this.fConditionEditor.getText();
        if (conditionText.length() == 0) {
            this.addErrorMessage(fgEmptyConditionErrorMessage);
            return;
        }
        if (fgEmptyConditionErrorMessage.equals(this.getErrorMessage())) {
            this.removeErrorMessage(fgEmptyConditionErrorMessage);
        }
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setFont(parent.getFont());
        label.setLayoutData((Object)new GridData());
        return label;
    }

    private IJSLineBreakpoint getBreakpoint() {
        return (IJSLineBreakpoint)this.getElement();
    }

    private void createTypeSpecificLabels(Composite parent) {
        IJSLineBreakpoint breakpoint = this.getBreakpoint();
        StringBuffer lineNumber = new StringBuffer(4);
        try {
            int lNumber = breakpoint.getLineNumber();
            if (lNumber > 0) {
                lineNumber.append(lNumber);
            }
        }
        catch (CoreException ce) {
            IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (Throwable)ce);
        }
        if (lineNumber.length() > 0) {
            this.createLabel(parent, Messages.JSLineBreakpointPropertyPage_LineNumber);
            this.createLabel(parent, lineNumber.toString());
        }
    }

    private void createTypeSpecificEditors(Composite parent) throws CoreException {
        this.createConditionEditor(parent);
    }

    private void createConditionEditor(Composite parent) throws CoreException {
        IJSLineBreakpoint breakpoint = this.getBreakpoint();
        Group conditionComposite = new Group(parent, 0);
        conditionComposite.setFont(parent.getFont());
        conditionComposite.setLayoutData((Object)new GridData(1808));
        conditionComposite.setLayout((Layout)new GridLayout());
        this.fEnableConditionButton = this.createCheckButton((Composite)conditionComposite, Messages.JSLineBreakpointPropertyPage_EnableCondition);
        this.fEnableConditionButton.setSelection(breakpoint.isConditionEnabled());
        this.fEnableConditionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSLineBreakpointPropertyPage.this.setConditionEnabled(JSLineBreakpointPropertyPage.this.fEnableConditionButton.getSelection());
                JSLineBreakpointPropertyPage.this.conditionChanged();
            }
        });
        this.fConditionEditor = this.createMultiText((Composite)conditionComposite, breakpoint.getCondition());
        this.fConditionEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JSLineBreakpointPropertyPage.this.conditionChanged();
            }
        });
        this.fConditionIsTrue = this.createRadioButton((Composite)conditionComposite, Messages.JSLineBreakpointPropertyPage_conditionIsTrue);
        this.fConditionHasChanged = this.createRadioButton((Composite)conditionComposite, Messages.JSLineBreakpointPropertyPage_valueOfConditionChanges);
        if (breakpoint.isConditionSuspendOnTrue()) {
            this.fConditionIsTrue.setSelection(true);
        } else {
            this.fConditionHasChanged.setSelection(true);
        }
        this.setConditionEnabled(this.fEnableConditionButton.getSelection());
    }

    private void setConditionEnabled(boolean enabled) {
        this.fConditionEditor.setEnabled(enabled);
        this.fConditionIsTrue.setEnabled(enabled);
        this.fConditionHasChanged.setEnabled(enabled);
    }

    public void addErrorMessage(String message) {
        if (message == null) {
            return;
        }
        this.fErrorMessages.remove(message);
        this.fErrorMessages.add(message);
        this.setErrorMessage(message);
        this.setValid(false);
    }

    public void removeErrorMessage(String message) {
        this.fErrorMessages.remove(message);
        if (this.fErrorMessages.isEmpty()) {
            this.setErrorMessage(null);
            this.setValid(true);
        } else {
            this.setErrorMessage(this.fErrorMessages.get(this.fErrorMessages.size() - 1));
        }
    }

    public boolean performOk() {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                JSLineBreakpointPropertyPage.this.doStore();
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wr, null, 0, null);
        }
        catch (CoreException e) {
            DebugUiPlugin.errorDialog((String)Messages.JSLineBreakpointPropertyPage_ExceptionWhileSavingBreakpointProperties, (Throwable)e);
            IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (Throwable)e);
        }
        return super.performOk();
    }

    protected void doStore() throws CoreException {
        IJSLineBreakpoint breakpoint = this.getBreakpoint();
        boolean enabled = this.fEnabledButton.getSelection();
        breakpoint.setEnabled(enabled);
        boolean hitCountEnabled = this.fHitCountButton.getSelection();
        int hitCount = -1;
        if (hitCountEnabled) {
            try {
                hitCount = Integer.parseInt(this.fHitCountText.getText());
            }
            catch (NumberFormatException e) {
                IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (String)MessageFormat.format(Messages.JSLineBreakpointPropertyPage_PageAllowedInputOfInvalidStringForHitCountValue_0, this.fHitCountText.getText()), (Throwable)e);
            }
        }
        breakpoint.setHitCount(hitCount);
        boolean enableCondition = this.fEnableConditionButton.getSelection();
        String condition = this.fConditionEditor.getText();
        boolean suspendOnTrue = this.fConditionIsTrue.getSelection();
        if (breakpoint.isConditionEnabled() != enableCondition) {
            breakpoint.setConditionEnabled(enableCondition);
        }
        if (!condition.equals(breakpoint.getCondition())) {
            breakpoint.setCondition(condition);
        }
        if (breakpoint.isConditionSuspendOnTrue() != suspendOnTrue) {
            breakpoint.setConditionSuspendOnTrue(suspendOnTrue);
        }
    }
}

