/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal.launchConfigurations;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.IBrowserUtil;
import com.aptana.debug.ui.internal.ActiveResourcePathGetterAdapter;
import com.aptana.js.debug.core.JSLaunchConfigurationHelper;
import com.aptana.js.debug.ui.JSDebugUIPlugin;
import com.aptana.js.debug.ui.internal.launchConfigurations.Messages;
import com.aptana.ui.launchings.AbstractLaunchBrowserSettingsTab;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class LaunchBrowserSettingsTab
extends AbstractLaunchBrowserSettingsTab {
    private Listener dirtyListener;
    private Image image;
    private Button rbCurrentPage;
    private Button rbInternalServer;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        composite.setFont(parent.getFont());
        this.dirtyListener = new Listener(){

            public void handleEvent(Event event) {
                LaunchBrowserSettingsTab.this.updateEnablement();
                LaunchBrowserSettingsTab.this.setDirty(true);
                LaunchBrowserSettingsTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.createBrowserSection(composite);
        this.createStartActionSection(composite);
        this.createServerSection(composite);
        this.hookListeners(true);
    }

    private void createStartActionSection(Composite parent) {
        Group group = new Group(parent, 0x800004);
        group.setText(Messages.LaunchBrowserSettingsTab_StartAction);
        group.setFont(parent.getFont());
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        group.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).margins(10, 3).create());
        this.rbCurrentPage = new Button((Composite)group, 16);
        this.rbCurrentPage.setText(Messages.LaunchBrowserSettingsTab_UseCurrentPage);
        this.rbCurrentPage.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).create());
    }

    private void createServerSection(Composite parent) {
        Group group = new Group(parent, 0x800000);
        group.setText(Messages.LaunchBrowserSettingsTab_Server);
        group.setFont(parent.getFont());
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).margins(10, 3).create());
        this.rbInternalServer = new Button((Composite)group, 16);
        this.rbInternalServer.setText(Messages.LaunchBrowserSettingsTab_UseBuiltInWebServer);
        this.rbInternalServer.setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 1).create());
    }

    private void hookListeners(boolean hook) {
        if (hook) {
            this.fBrowserExeCombo.addListener(24, this.dirtyListener);
            this.rbCurrentPage.addListener(13, this.dirtyListener);
            this.rbInternalServer.addListener(13, this.dirtyListener);
        } else {
            this.fBrowserExeCombo.removeListener(24, this.dirtyListener);
            this.rbCurrentPage.removeListener(13, this.dirtyListener);
            this.rbInternalServer.removeListener(13, this.dirtyListener);
        }
    }

    private void updateEnablement() {
        boolean startUrlEnabled = false;
        this.rbInternalServer.setEnabled(!startUrlEnabled);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        JSLaunchConfigurationHelper.setBrowserDefaults((ILaunchConfigurationWorkingCopy)configuration, null);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.hookListeners(false);
        try {
            try {
                String id = configuration.getAttribute("browserID", "");
                IBrowserUtil.BrowserInfo info = JSLaunchConfigurationHelper.getBrowserByID((String)id);
                String name = info != null ? info.getName() : "";
                this.initializeBrowser(false, name, id);
                int startActionType = configuration.getAttribute("startActionType", 1);
                this.rbCurrentPage.setSelection(startActionType == 1);
                int serverType = configuration.getAttribute("serverType", 1);
                this.rbInternalServer.setSelection(serverType == 1);
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (String)"Reading launch configuration fails", (Throwable)e);
                this.hookListeners(true);
                this.updateEnablement();
            }
        }
        finally {
            this.hookListeners(true);
            this.updateEnablement();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.saveWebBrowserId(configuration, "browserID");
        int startActionType = 0;
        if (this.rbCurrentPage.getSelection()) {
            startActionType = 1;
        }
        configuration.setAttribute("startActionType", startActionType);
        int serverType = 0;
        if (this.rbInternalServer.getSelection()) {
            serverType = 1;
        }
        configuration.setAttribute("serverType", serverType);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        IPath activeResource;
        this.setErrorMessage(null);
        this.setMessage(null);
        if (!this.isBrowserValid()) {
            return false;
        }
        if (this.rbCurrentPage.getSelection() && (activeResource = new ActiveResourcePathGetterAdapter().getActiveResourcePath()) == null) {
            this.setMessage(Messages.LaunchBrowserSettingsTab_NoFilesOpenedInEditor);
            return false;
        }
        return true;
    }

    public String getName() {
        return Messages.LaunchBrowserSettingsTab_Main;
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = JSDebugUIPlugin.getImageDescriptor("icons/full/obj16/launch-main.gif").createImage();
        }
        return this.image;
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        super.dispose();
    }
}

