/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal.hovers;

import com.aptana.js.debug.core.model.IJSStackFrame;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;

public class JSDebugHover
implements ITextHover,
ITextHoverExtension2 {
    private static IDebugModelPresentation modelPresentation;

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        Object info = this.getHoverInfo2(textViewer, hoverRegion);
        return info != null ? info.toString() : null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return JSDebugHover.findWord(textViewer.getDocument(), offset);
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        IDocument document;
        IJSStackFrame frame = this.getFrame();
        if (frame != null && (document = textViewer.getDocument()) != null) {
            try {
                String variableName = document.get(hoverRegion.getOffset(), hoverRegion.getLength());
                try {
                    IVariable variable = frame.findVariable(variableName);
                    if (variable != null) {
                        return this.getVariableText(variable);
                    }
                }
                catch (DebugException debugException) {
                    return null;
                }
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        return null;
    }

    private IJSStackFrame getFrame() {
        IAdaptable adaptable = DebugUITools.getDebugContext();
        if (adaptable != null) {
            return (IJSStackFrame)adaptable.getAdapter(IJSStackFrame.class);
        }
        return null;
    }

    private String getVariableText(IVariable variable) {
        StringBuilder sb = new StringBuilder();
        IDebugModelPresentation modelPresentation = JSDebugHover.getModelPresentation();
        sb.append("<p><pre>");
        String variableText = modelPresentation.getText((Object)variable);
        sb.append(JSDebugHover.replaceHTMLChars(variableText));
        sb.append("</pre></p>");
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    private static String replaceHTMLChars(String variableText) {
        StringBuilder sb = new StringBuilder(variableText.length());
        char[] characters = variableText.toCharArray();
        int i = 0;
        while (i < characters.length) {
            char character = characters[i];
            switch (character) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(character);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private static IDebugModelPresentation getModelPresentation() {
        if (modelPresentation == null) {
            modelPresentation = DebugUITools.newDebugModelPresentation((String)"com.aptana.js.debug.core");
            modelPresentation.setAttribute("org.eclipse.debug.ui.displayVariableTypeNames", (Object)Boolean.TRUE);
        }
        return modelPresentation;
    }

    public static IRegion findWord(IDocument document, int offset) {
        int start = -2;
        int end = -1;
        try {
            char c;
            int pos = offset;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException ignore) {
            ignore.getCause();
        }
        if (start >= -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }
}

