/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal.dialogs;

import com.aptana.debug.ui.DebugUiPlugin;
import com.aptana.js.debug.core.model.IJSExceptionBreakpoint;
import com.aptana.js.debug.core.model.JSDebugModel;
import com.aptana.js.debug.ui.internal.dialogs.JSTypeSelectionDialog;
import com.aptana.js.debug.ui.internal.dialogs.Messages;
import com.aptana.ui.util.UIUtils;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;

public class AddExceptionBreakpointDialog
extends JSTypeSelectionDialog {
    public AddExceptionBreakpointDialog(Shell parent) {
        super(parent);
        this.setFilter("*Error*");
    }

    protected void okPressed() {
        if (this.createBreakpoint()) {
            super.okPressed();
        }
    }

    private boolean createBreakpoint() {
        final Object[] selected = this.getSelectedElements();
        if (selected.length != 1) {
            return false;
        }
        new Job(Messages.AddExceptionBreakpointDialog_AddJavaScriptExceptionBreakpoint){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IWorkspaceRoot resource = null;
                    if (resource == null) {
                        resource = ResourcesPlugin.getWorkspace().getRoot();
                    }
                    IJSExceptionBreakpoint breakpoint = JSDebugModel.createExceptionBreakpoint((IResource)resource, (String)((String)selected[0]));
                    final ArrayList<IJSExceptionBreakpoint> list = new ArrayList<IJSExceptionBreakpoint>(1);
                    list.add(breakpoint);
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            Viewer viewer;
                            IViewPart part = UIUtils.getActivePage().findView("org.eclipse.debug.ui.BreakpointView");
                            if (part instanceof IDebugView && (viewer = ((IDebugView)part).getViewer()) instanceof StructuredViewer) {
                                StructuredViewer sv = (StructuredViewer)viewer;
                                sv.setSelection((ISelection)new StructuredSelection(list), true);
                            }
                        }
                    };
                    DebugUiPlugin.getStandardDisplay().asyncExec(r);
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    AddExceptionBreakpointDialog.this.updateStatus(e.getStatus());
                    return Status.CANCEL_STATUS;
                }
            }
        }.schedule();
        return true;
    }
}

