/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal.decorators;

import com.aptana.js.debug.ui.JSDebugUIPlugin;
import com.aptana.js.debug.ui.internal.StartPageManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;

public class StartPageDecorator
implements ILightweightLabelDecorator,
StartPageManager.IStartPageChangeListener {
    private static final ImageDescriptor START_PAGE = JSDebugUIPlugin.getImageDescriptor("icons/full/ovr16/start_page_ovr.gif");
    private ListenerList listeners = new ListenerList();

    public StartPageDecorator() {
        StartPageManager.getDefault().addListener(this);
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IFile && StartPageManager.getDefault().isStartPage((IResource)element)) {
            decoration.addOverlay(START_PAGE);
        }
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add((Object)listener);
    }

    public void dispose() {
        this.listeners.clear();
        StartPageManager.getDefault().removeListener(this);
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public void startPageChanged(IResource resource) {
        LabelProviderChangedEvent event = resource != null ? new LabelProviderChangedEvent((IBaseLabelProvider)this, (Object)resource) : new LabelProviderChangedEvent((IBaseLabelProvider)this);
        this.fireLabelProviderChanged(event);
    }

    private void fireLabelProviderChanged(final LabelProviderChangedEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            final ILabelProviderListener listener = (ILabelProviderListener)object;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.labelProviderChanged(event);
                }
            });
            ++n2;
        }
    }
}

