/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.BrowserUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IBrowserUtil;
import com.aptana.js.debug.core.JSLaunchConfigurationDelegate;
import com.aptana.js.debug.core.JSLaunchConfigurationHelper;
import com.aptana.js.debug.ui.JSDebugUIPlugin;
import com.aptana.js.debug.ui.internal.Messages;
import com.aptana.js.debug.ui.internal.WorkbenchCloseListener;
import com.aptana.ui.PopupSchedulingRule;
import com.aptana.ui.browser.BrowserManager;
import com.aptana.ui.util.UIUtils;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.navigator.ResourceComparator;

public final class LaunchConfigurationsHelper {
    private LaunchConfigurationsHelper() {
    }

    public static void doCheckDefaultLaunchConfigurations() {
        JSLaunchConfigurationDelegate.setCheckBrowerLocationListener((JSLaunchConfigurationDelegate.Listener)new JSLaunchConfigurationDelegate.Listener(){

            public IBrowserUtil.BrowserInfo checkLocation(String brower) {
                return BrowserManager.showBrowserInfoNotFoundDialog((String)brower, (boolean)true);
            }

            public String checkPage() {
                return LaunchConfigurationsHelper.showPageNotFoundDialog();
            }
        });
        UIJob job = new UIJob("Checking default launch configuration"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                new LaunchConfigurationsHelper(null).checkDefaultLaunchConfiguration();
                WorkbenchCloseListener.init();
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)PopupSchedulingRule.INSTANCE);
        EclipseUtil.setSystemForJob((Job)job);
        job.schedule();
    }

    private void checkDefaultLaunchConfiguration() {
        Stack<ILaunchConfiguration> defaultConfigurations = new Stack<ILaunchConfiguration>();
        LaunchConfigurationManager manager = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
        ILaunchConfiguration[] history = manager.getLaunchHistory("org.eclipse.debug.ui.launchGroup.debug").getHistory();
        ILaunchConfiguration configuration = LaunchConfigurationsHelper.getOrCreateDefaultLaunchConfiguration("Chrome");
        if (configuration != null) {
            defaultConfigurations.push(configuration);
        }
        if ("win32".equals(Platform.getOS())) {
            configuration = LaunchConfigurationsHelper.getOrCreateDefaultLaunchConfiguration("Internet Explorer");
            if (configuration != null) {
                defaultConfigurations.push(configuration);
            }
            if (BrowserUtil.isEdgeExist() && (configuration = LaunchConfigurationsHelper.getOrCreateDefaultLaunchConfiguration("Edge")) != null) {
                defaultConfigurations.push(configuration);
            }
            if ((configuration = LaunchConfigurationsHelper.getOrCreateDefaultLaunchConfiguration("IETester")) != null) {
                defaultConfigurations.push(configuration);
            }
        }
        if ((configuration = LaunchConfigurationsHelper.getOrCreateDefaultLaunchConfiguration("Safari")) != null) {
            defaultConfigurations.push(configuration);
        }
        if ((configuration = LaunchConfigurationsHelper.getOrCreateDefaultLaunchConfiguration("Firefox")) != null) {
            defaultConfigurations.push(configuration);
        }
        ILaunchConfiguration[] iLaunchConfigurationArray = history;
        int n = history.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration i = iLaunchConfigurationArray[n2];
            Iterator j = defaultConfigurations.iterator();
            while (j.hasNext()) {
                if (!i.equals(j.next())) continue;
                j.remove();
                break;
            }
            ++n2;
        }
        while (!defaultConfigurations.empty()) {
            configuration = (ILaunchConfiguration)defaultConfigurations.pop();
            this.setRecentLaunchHistory("org.eclipse.debug.ui.launchGroup.run", configuration);
            this.setRecentLaunchHistory("org.eclipse.debug.ui.launchGroup.debug", configuration);
        }
    }

    private void setRecentLaunchHistory(String groupId, final ILaunchConfiguration configuration) {
        LaunchConfigurationManager manager = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
        LaunchHistory history = manager.getLaunchHistory(groupId);
        history.launchAdded(new ILaunch(){

            public ILaunchConfiguration getLaunchConfiguration() {
                return configuration;
            }

            public Object[] getChildren() {
                return null;
            }

            public IDebugTarget getDebugTarget() {
                return null;
            }

            public IProcess[] getProcesses() {
                return null;
            }

            public IDebugTarget[] getDebugTargets() {
                return null;
            }

            public void addDebugTarget(IDebugTarget target) {
            }

            public void removeDebugTarget(IDebugTarget target) {
            }

            public void addProcess(IProcess process) {
            }

            public void removeProcess(IProcess process) {
            }

            public ISourceLocator getSourceLocator() {
                return null;
            }

            public void setSourceLocator(ISourceLocator sourceLocator) {
            }

            public String getLaunchMode() {
                return null;
            }

            public void setAttribute(String key, String value) {
            }

            public String getAttribute(String key) {
                return null;
            }

            public boolean hasChildren() {
                return false;
            }

            public boolean canTerminate() {
                return false;
            }

            public boolean isTerminated() {
                return false;
            }

            public void terminate() throws DebugException {
            }

            public Object getAdapter(Class adapter) {
                return null;
            }
        });
    }

    public static ILaunchConfiguration getOrCreateDefaultLaunchConfiguration(String nature) {
        ILaunchConfigurationType configType = LaunchConfigurationsHelper.getLaunchConfigType();
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        try {
            ILaunchConfiguration[] configs;
            ILaunchConfiguration[] iLaunchConfigurationArray = configs = manager.getLaunchConfigurations(configType);
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (nature.equals(config.getAttribute("browserNature", ""))) {
                    return config;
                }
                ++n2;
            }
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(String.valueOf(nature) + " - Internal Server"));
            JSLaunchConfigurationHelper.setDefaults((ILaunchConfigurationWorkingCopy)wc, (String)nature);
            return wc.doSave();
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    private static ILaunchConfigurationType getLaunchConfigType() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        return manager.getLaunchConfigurationType("com.aptana.js.debug.core.webbrowserLaunchConfigurationType");
    }

    public static String showPageNotFoundDialog() {
        final String[] path = new String[]{""};
        UIUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(UIUtils.getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                dialog.setMessage(Messages.LaunchConfigurationsHelper__SelectStartPage);
                dialog.addFilter(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        IFile file;
                        String ext;
                        if (element instanceof IFolder || element instanceof IProject) {
                            return true;
                        }
                        return element instanceof IFile && ("htm".equals(ext = (file = (IFile)element).getFileExtension()) || "html".equals(ext) || "xhtml".equals(ext));
                    }
                });
                dialog.setValidator(new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        if (selection == null || selection.length == 0 || selection.length > 1) {
                            return new Status(4, "com.aptana.js.debug.ui", 4, null, null);
                        }
                        Object o = selection[0];
                        if (o instanceof IFolder || o instanceof IProject) {
                            return new Status(4, "com.aptana.js.debug.ui", 4, null, null);
                        }
                        return new Status(0, "com.aptana.js.debug.ui", 0, null, null);
                    }
                });
                if (dialog.open() == 0) {
                    path[0] = ((IResource)dialog.getFirstResult()).getFullPath().toPortableString();
                }
            }
        });
        return path[0];
    }

    /* synthetic */ LaunchConfigurationsHelper(LaunchConfigurationsHelper launchConfigurationsHelper) {
        this();
    }
}

