/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.js.debug.core.JSDebugPlugin;
import com.aptana.js.debug.core.model.IJSVariable;
import com.aptana.js.debug.core.model.JSDebugModel;
import com.aptana.js.debug.ui.JSDebugUIPlugin;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.ui.IActionFilter;

public class JSVariableActionFilter
implements IActionFilter {
    private static final Set<String> fgPrimitiveTypes = JSVariableActionFilter.initPrimitiveTypes();

    private static Set<String> initPrimitiveTypes() {
        HashSet<String> set = new HashSet<String>(8);
        set.add("integer");
        set.add("float");
        set.add("boolean");
        set.add("String");
        set.add("Number");
        set.add("Boolean");
        set.add("null");
        return set;
    }

    public boolean testAttribute(Object target, String name, String value) {
        try {
            if (target instanceof IJSVariable) {
                IJSVariable variable = (IJSVariable)target;
                if ("PrimitiveVariableActionFilter".equals(name)) {
                    if ("isPrimitive".equals(value)) {
                        return this.isPrimitiveType(variable.getReferenceTypeName());
                    }
                    if ("isValuePrimitive".equals(value)) {
                        return this.isPrimitiveType(variable.getValue().getReferenceTypeName());
                    }
                } else {
                    if ("DetailFormatterFilter".equals(name) && "isDefined".equals(value)) {
                        return JSDebugPlugin.getDefault().getDebugOptionsManager().hasAssociatedDetailFormatter(variable.getReferenceTypeName());
                    }
                    if ("WatchpointFilter".equals(name) && "isDefined".equals(value)) {
                        return JSDebugModel.watchpointExists((IVariable)variable);
                    }
                }
            }
        }
        catch (DebugException e) {
            IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (Throwable)e);
        }
        return false;
    }

    protected boolean isPrimitiveType(String typeName) {
        return fgPrimitiveTypes.contains(typeName);
    }
}

