/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.BrowserUtil;
import com.aptana.core.util.IBrowserUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.js.debug.core.JSLaunchConfigurationHelper;
import com.aptana.js.debug.ui.JSDebugUIPlugin;
import com.aptana.ui.util.RunInBrowserUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class JSLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        Object object;
        if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            this.runInBrowser(RunInBrowserUtil.getLastBrowserNature(), ((IFile)object).getFullPath(), false, mode);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        IPath file = (IPath)input.getAdapter(IPath.class);
        if (file != null) {
            this.runInBrowser(RunInBrowserUtil.getLastBrowserNature(), file, true, mode);
        }
    }

    public boolean runInBrowser(String brower, IPath path, boolean current, String mode) {
        ILaunchConfiguration config = JSLaunchShortcut.findLaunchConfiguration(brower, path, current, mode);
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
            return true;
        }
        return false;
    }

    private static ILaunchConfiguration findLaunchConfiguration(String nature, IPath path, boolean current, String mode) {
        ILaunchConfigurationType configType = JSLaunchShortcut.getLaunchConfigType();
        ILaunchConfiguration launchConfiguration = null;
        try {
            ILaunchConfiguration config;
            ILaunchConfiguration[] configs;
            ILaunchConfiguration[] iLaunchConfigurationArray = configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                config = iLaunchConfigurationArray[n2];
                if ((nature == null || nature.equals(config.getAttribute("browserNature", ""))) && config.getAttribute("serverType", -1) == 1) {
                    if (path != null && config.getAttribute("startActionType", -1) == 2 && path.toPortableString().equals(config.getAttribute("startPagePath", ""))) {
                        launchConfiguration = config;
                        break;
                    }
                    if (current && config.getAttribute("startActionType", -1) == 1) {
                        launchConfiguration = config;
                        break;
                    }
                }
                ++n2;
            }
            if (launchConfiguration == null) {
                if (StringUtil.isNotBlank((String)nature)) {
                    iLaunchConfigurationArray = configs;
                    n = configs.length;
                    n2 = 0;
                    while (n2 < n) {
                        config = iLaunchConfigurationArray[n2];
                        if (nature.equals(config.getAttribute("browserNature", ""))) {
                            launchConfiguration = config;
                            break;
                        }
                        ++n2;
                    }
                } else if (path != null) {
                    config = JSLaunchShortcut.getCanExeConfigByNature("Chrome", configs);
                    if (config == null) {
                        if ("win32".equals(Platform.getOS())) {
                            config = BrowserUtil.isEdgeExist() ? JSLaunchShortcut.getCanExeConfigByNature("Edge", configs) : JSLaunchShortcut.getCanExeConfigByNature("Internet Explorer", configs);
                        } else if ("macosx".equals(Platform.getOS())) {
                            config = JSLaunchShortcut.getCanExeConfigByNature("Safari", configs);
                        }
                    }
                    launchConfiguration = config;
                }
            }
            if (launchConfiguration != null) {
                if (JSLaunchShortcut.getCanExeConfigByNature(null, launchConfiguration) == null) {
                    ILaunchConfigurationWorkingCopy wc = launchConfiguration.getWorkingCopy();
                    JSLaunchConfigurationHelper.setBrowserDefaults((ILaunchConfigurationWorkingCopy)wc, (String)nature);
                    launchConfiguration = wc.doSave();
                }
                return launchConfiguration;
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (Throwable)e);
        }
        return JSLaunchShortcut.createConfiguration(nature);
    }

    private static ILaunchConfiguration getCanExeConfigByNature(String nature, ILaunchConfiguration ... configs) {
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (nature == null || nature.equals(config.getAttribute("browserNature", ""))) {
                    String browserExecutable;
                    IBrowserUtil.BrowserInfo info = JSLaunchConfigurationHelper.getBrowserByID((String)config.getAttribute("browserID", ""));
                    String string = browserExecutable = info != null ? info.getLocation() : "";
                    if (StringUtil.isNotBlank((String)browserExecutable)) {
                        return config;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static ILaunchConfiguration createConfiguration(String nature) {
        ILaunchConfiguration config = null;
        if (StringUtil.isNotBlank((String)nature)) {
            ILaunchConfigurationType configType = JSLaunchShortcut.getLaunchConfigType();
            try {
                ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(String.valueOf(nature) + " - Internal Server"));
                JSLaunchConfigurationHelper.setDefaults((ILaunchConfigurationWorkingCopy)wc, (String)nature);
                wc.setAttribute("startActionType", 1);
                config = wc.doSave();
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (Throwable)e);
            }
        }
        return config;
    }

    private static ILaunchConfigurationType getLaunchConfigType() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        return manager.getLaunchConfigurationType("com.aptana.js.debug.core.webbrowserLaunchConfigurationType");
    }
}

