/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.views;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.js.contentassist.JSIndexQueryHelper;
import com.aptana.editor.js.contentassist.model.ClassElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.editor.js.inferencing.JSTypeUtil;
import com.aptana.editor.js.views.Messages;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.ui.views.IActionProvider;
import com.aptana.index.core.ui.views.IndexView;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class JSIndexViewActionProvider
implements IActionProvider {
    public IAction[] getActions(IndexView view, Object object) {
        List<String> typeNames;
        if (object instanceof PropertyElement && !CollectionsUtil.isEmpty(typeNames = ((PropertyElement)object).getTypeNames())) {
            return new IAction[]{this.createAction(view, typeNames)};
        }
        return null;
    }

    protected IAction createAction(final IndexView view, final List<String> typeNames) {
        Action action = new Action(){

            public void run() {
                Object input;
                TreeViewer treeViewer = view.getTreeViewer();
                if (treeViewer != null && (input = treeViewer.getInput()) instanceof IProject) {
                    IProject project = (IProject)input;
                    JSIndexQueryHelper queryHelper = new JSIndexQueryHelper();
                    Index index = JSIndexViewActionProvider.this.getIndexManager().getIndex(project.getLocationURI());
                    Collection<TypeElement> types = queryHelper.getTypes(index, (String)typeNames.get(0), true);
                    List<ClassElement> classes = JSTypeUtil.typesToClasses(types);
                    if (!CollectionsUtil.isEmpty(classes)) {
                        ClassElement c = classes.get(0);
                        treeViewer.setSelection((ISelection)new StructuredSelection((Object)c), true);
                    }
                }
            }
        };
        action.setText(Messages.JSIndexViewActionProvider_JumpToType);
        return action;
    }

    protected IndexManager getIndexManager() {
        return IndexPlugin.getDefault().getIndexManager();
    }
}

