/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.validator;

import com.aptana.core.build.AbstractBuildParticipant;
import com.aptana.core.build.IProblem;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.js.JSPlugin;
import com.aptana.index.core.build.BuildContext;
import com.pandora.nodejs.service.ContentType;
import com.pandora.nodejs.service.NodeService;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;

public class NodeJSSyntaxValidator
extends AbstractBuildParticipant {
    public static final String ID = "com.aptana.editor.js.validator.MozillaJsValidator";

    public void initContext(BuildContext context) {
        List problems = Collections.emptyList();
        context.putProblems("com.aptana.editor.js.problem", problems);
    }

    public boolean needBuildFile(BuildContext context) {
        return context != null && (context.isFullBuild() || context.isSave() || context.isOpenManualValidator());
    }

    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        if (monitor.isCanceled() || !this.needBuildFile(context)) {
            return;
        }
        List<IProblem> problems = this.detectErrors(context, monitor);
        context.putProblems("com.aptana.editor.js.problem", problems);
    }

    public List<IProblem> detectErrors(BuildContext context, IProgressMonitor monitor) {
        List<IProblem> problems = Collections.emptyList();
        String sourcePath = context.getURI().toString();
        try {
            problems = this.parseWithNodeJs(context.getContents(), sourcePath, context.getFile(), monitor);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)MessageFormat.format("Failed to parse {0} with JSLint", sourcePath), (Throwable)e);
        }
        return problems;
    }

    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        context.removeProblems("com.aptana.editor.js.problem");
    }

    protected List<IProblem> parseWithNodeJs(String source, String path, IFile file, IProgressMonitor monitor) {
        Map result;
        block6: {
            JSONObject config = new JSONObject();
            int ecmaVersion = 6;
            if (file != null && file.getProject() != null && !JSPlugin.getDefault().isEnableES6(file.getProject())) {
                ecmaVersion = 5;
            } else {
                config.put("sourceType", (Object)"module");
            }
            config.put("ecmaVersion", ecmaVersion);
            result = NodeService.syntaxCheck((JSONObject)config, (ContentType)ContentType.JS, (String)source);
            if (!monitor.isCanceled()) break block6;
            return null;
        }
        try {
            if (result != null && !result.isEmpty()) {
                int line = Integer.parseInt((String)result.get("line"));
                int offset = Integer.parseInt((String)result.get("offset"));
                int length = Integer.parseInt((String)result.get("length"));
                length = length <= 0 ? 1 : length;
                return CollectionsUtil.newList((Object[])new IProblem[]{this.createError((String)result.get("message"), line, offset, length, path)});
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
        }
        return null;
    }
}

