/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.validator;

import com.aptana.core.IMap;
import com.aptana.core.build.AbstractRemoteBuildParticipant;
import com.aptana.core.build.IProblem;
import com.aptana.core.build.Problem;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.parsing.JSParseState;
import com.aptana.index.core.build.BuildContext;
import com.aptana.parsing.ParseState;
import com.aptana.parsing.ast.IParseError;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;

public class JSParserValidator
extends AbstractRemoteBuildParticipant {
    public static final String ID = "com.aptana.editor.js.validator.JSParserValidator";

    public void initContext(BuildContext context) {
        List problems = Collections.emptyList();
        context.putProblems("com.aptana.editor.js.problem", problems);
    }

    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        context.removeProblems("com.aptana.editor.js.problem");
    }

    public boolean needBuildFile(BuildContext context) {
        return this.needValidatorBuildFile(context);
    }

    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        if (monitor.isCanceled() || !this.needBuildFile(context)) {
            return;
        }
        try {
            JSParseState state = new JSParseState(context.getContents());
            state.setThrowException(false);
            context.setParseState((ParseState)state);
            context.getAST();
        }
        catch (CoreException coreException) {}
        List<IProblem> fProblems = this.detectErrors(context);
        context.putProblems("com.aptana.editor.js.problem", fProblems);
    }

    public List<IProblem> detectErrors(final BuildContext context) {
        URI fLocation = context.getURI();
        final String fPath = fLocation.toString();
        ArrayList<IProblem> fProblems = new ArrayList<IProblem>();
        try {
            Collection parseErrors = context.getParseErrors();
            if (!CollectionsUtil.isEmpty((Collection)parseErrors)) {
                final Document doc = new Document(context.getContents());
                fProblems.addAll(CollectionsUtil.map((Collection)parseErrors, (IMap)new IMap<IParseError, IProblem>(){

                    public IProblem map(IParseError parseError) {
                        int severity = parseError.getSeverity() == IParseError.Severity.ERROR ? 2 : 1;
                        return new Problem(severity, parseError.getMessage(), parseError.getOffset(), parseError.getLength(), JSParserValidator.this.getLine(doc, context, parseError.getOffset()), fPath);
                    }
                }));
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)MessageFormat.format("Failed to parse {0} for JS Parser Validation", fPath), (Throwable)e);
        }
        return fProblems;
    }

    private int getLine(Document doc, BuildContext context, int offset) {
        try {
            return doc.getLineOfOffset(offset) + 1;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public boolean isEnabled() {
        return true;
    }
}

