/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.validator;

import com.aptana.buildpath.core.BuildPathCorePlugin;
import com.aptana.core.IFilter;
import com.aptana.core.build.AbstractRemoteBuildParticipant;
import com.aptana.core.build.IProblem;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.validator.JSHint.JSHint;
import com.aptana.editor.js.validator.JSHint.Problem;
import com.aptana.editor.js.validator.JSHint.ProblemHandler;
import com.aptana.editor.js.validator.Messages;
import com.aptana.index.core.build.BuildContext;
import com.aptana.jetty.util.epl.ajax.JSON;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.index.service.ILocalBuildService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IRegion;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public class JSHintValidator
extends AbstractRemoteBuildParticipant {
    public static final String JS_HINT_OPTIONS = "jsHintOptions";
    public static final String ID = "com.aptana.editor.js.validator.JSHintValidator";
    private static final String JSLINT_FILENAME = "jshint-2.5.4.js";
    private static final long TIMEOUT = 30000L;
    private static ContextFactory contextFactory = new ContextFactory();

    public void initContext(BuildContext context) {
        List problems = Collections.emptyList();
        context.putProblems("com.aptana.editor.js.jslint_problem", problems);
    }

    public boolean needBuildFile(BuildContext context) {
        return this.needValidatorBuildFile(context);
    }

    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        if (monitor.isCanceled() || !this.needBuildFile(context)) {
            return;
        }
        List<IProblem> problems = this.detectErrors(context, monitor);
        context.putProblems("com.aptana.editor.js.jslint_problem", problems);
    }

    public List<IProblem> detectErrors(BuildContext context, IProgressMonitor monitor) {
        List<IProblem> problems = Collections.emptyList();
        String sourcePath = context.getURI().toString();
        monitor.subTask(" JSHint \u6821\u9a8c: " + sourcePath);
        try {
            problems = this.parseWithHint(context.getContents(), sourcePath, monitor);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)MessageFormat.format("Failed to parse {0} with JSLint", sourcePath), (Throwable)e);
        }
        return problems;
    }

    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        context.removeProblems("com.aptana.editor.js.jslint_problem");
    }

    protected List<IProblem> parseWithHint(String source, String path, final IProgressMonitor monitor) {
        final JSHint jshit = this.getJSHintScript();
        if (jshit == null) {
            return Collections.emptyList();
        }
        JSHintProblemHandler hander = new JSHintProblemHandler();
        jshit.configure(this.getOptions());
        final boolean[] done = new boolean[1];
        new Thread(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                while (!done[0] && !monitor.isCanceled() && System.currentTimeMillis() - start < 30000L) {
                    try {
                        1.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!done[0]) {
                    jshit.stop();
                    IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)("\u81ea\u52a8\u505c\u6b62JSHint\u7684\u6821\u9a8c" + (System.currentTimeMillis() - start)));
                }
            }
        }.start();
        try {
            jshit.check(source, (ProblemHandler)hander);
        }
        finally {
            done[0] = true;
        }
        List<IProblem> collected = this.getProblems(source, path, hander.getProblems());
        final List filters = this.getFilters();
        return CollectionsUtil.filter(collected, (IFilter)new IFilter<IProblem>(){

            public boolean include(IProblem item) {
                return !JSHintValidator.this.isIgnored(item.getMessage(), filters);
            }
        });
    }

    private List<IProblem> getProblems(final String source, final String path, final List<Problem> problems) {
        final ArrayList<IProblem> items = new ArrayList<IProblem>();
        contextFactory.call(new ContextAction(){

            public Object run(Context cx) {
                Document doc = null;
                int i = 0;
                while (i < problems.size()) {
                    Problem problem = (Problem)problems.get(i);
                    int line = problem.getLine();
                    String reason = problem.getMessage().trim();
                    String code = problem.getCode();
                    if (doc == null) {
                        doc = new Document(source);
                    }
                    int character = problem.getCharacter();
                    try {
                        IRegion lineInfo = doc.getLineInformation(line - 1);
                        int realOffset = lineInfo.getOffset();
                        String rawLine = doc.get(realOffset, lineInfo.getLength());
                        int lineLength = rawLine.length();
                        int actual = character - 1;
                        int x = 0;
                        while (x < actual) {
                            if (lineLength <= x) break;
                            char c = rawLine.charAt(x);
                            if (c == '\t') {
                                actual -= 3;
                            }
                            ++realOffset;
                            ++x;
                        }
                        character = realOffset;
                    }
                    catch (BadLocationException badLocationException) {}
                    boolean IsError = code.startsWith("E");
                    if (IsError) {
                        items.add(JSHintValidator.this.createError(reason, line, character, 1, path));
                    } else {
                        items.add(JSHintValidator.this.createWarning(reason, line, character, 1, path));
                    }
                    ++i;
                }
                return null;
            }
        });
        return items;
    }

    private synchronized JSHint getJSHintScript() {
        JSHint jshint;
        block7: {
            URL url = FileLocator.find((Bundle)JSPlugin.getDefault().getBundle(), (IPath)Path.fromPortableString((String)JSLINT_FILENAME), null);
            jshint = null;
            if (url != null) {
                try {
                    jshint = new JSHint();
                    InputStream inputStream = url.openStream();
                    if (inputStream != null) {
                        try {
                            jshint.load(inputStream);
                            break block7;
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    jshint.load();
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)Messages.JSLintValidator_ERR_FailToGetJSLint, (Throwable)e);
                }
            }
        }
        return jshint;
    }

    protected void setJSONOptions(String optionsAsJSON) throws IllegalStateException {
        JSON.parse((String)optionsAsJSON);
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(this.getPreferenceNode());
        prefs.put(JS_HINT_OPTIONS, optionsAsJSON);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
        }
    }

    private String getOptions() {
        String options = "";
        if (!PlatformUtil.isMainProcess()) {
            try {
                ILocalBuildService localBuildService = this.getLocalBuildService();
                options = localBuildService.getPreferenceString(this.getPreferenceNode(), JS_HINT_OPTIONS, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            options = this.getPreferenceString(JS_HINT_OPTIONS);
        }
        return options;
    }

    public void restoreDefaults() {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(this.getPreferenceNode());
        prefs.remove(JS_HINT_OPTIONS);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
        }
        super.restoreDefaults();
    }

    public boolean isEnabled() {
        return true;
    }

    class DefaultErrorReporter
    implements ErrorReporter {
        private List<IProblem> items = new ArrayList<IProblem>();

        public void error(String message, String sourceURI, int line, String lineText, int lineOffset) {
            this.items.add(JSHintValidator.this.createError(message, line, lineOffset, 1, sourceURI));
        }

        public void warning(String message, String sourceURI, int line, String lineText, int lineOffset) {
            this.items.add(JSHintValidator.this.createWarning(message, line, lineOffset, 1, sourceURI));
        }

        public EvaluatorException runtimeError(String message, String sourceURI, int line, String lineText, int lineOffset) {
            return new EvaluatorException(message, sourceURI, line, lineText, lineOffset);
        }

        public List<IProblem> getItems() {
            return Collections.unmodifiableList(this.items);
        }
    }

    private class JSHintProblemHandler
    implements ProblemHandler {
        private List<Problem> items = new ArrayList<Problem>();

        private JSHintProblemHandler() {
        }

        public List<Problem> getProblems() {
            return this.items;
        }

        @Override
        public void handleProblem(Problem problem) {
            this.items.add(problem);
        }
    }
}

