/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.validator.JSHint;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.validator.JSHint.Configuration;
import com.aptana.editor.js.validator.JSHint.ProblemHandler;
import com.aptana.editor.js.validator.JSHint.ProblemImpl;
import com.aptana.editor.js.validator.JSHint.Text;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JSHint {
    private static final String DEFAULT_JSHINT_VERSION = "1.0.0";
    private static final int DEFAULT_JSHINT_INDENT = 1;
    private Function jshint;
    private Object opts;
    private ScriptableObject scope;
    private int indent = 1;

    public void load() throws IOException {
        BufferedReader reader = JSHint.getJsHintReader();
        try {
            this.load(reader);
        }
        finally {
            ((Reader)reader).close();
        }
    }

    public void load(InputStream inputStream) throws IOException {
        InputStreamReader reader = new InputStreamReader(inputStream);
        try {
            this.load(reader);
        }
        finally {
            ((Reader)reader).close();
        }
    }

    public void configure(String jsonConfig) {
        if (jsonConfig == null) {
            throw new NullPointerException("configuration is null");
        }
        Context context = Context.enter();
        try {
            ScriptableObject scope = context.initStandardObjects();
            String optionsString = jsonConfig;
            this.opts = context.evaluateString((Scriptable)scope, StringUtil.isNotEmpty((String)optionsString) ? "opts = " + optionsString + ";" : "", "[options]", 1, null);
            this.indent = this.determineIndent(null);
        }
        finally {
            Context.exit();
        }
    }

    private int determineIndent(Configuration configuration) {
        Object indent;
        if (configuration != null && (indent = configuration.getOption("indent")) instanceof Integer) {
            return (Integer)indent;
        }
        return 1;
    }

    public boolean check(String code, ProblemHandler handler) {
        if (code == null) {
            throw new NullPointerException("code is null");
        }
        return this.check(new Text(code), handler);
    }

    public boolean check(Text text, ProblemHandler handler) {
        if (text == null) {
            throw new NullPointerException("code is null");
        }
        if (this.jshint == null) {
            throw new IllegalStateException("JSHint is not loaded");
        }
        boolean result = true;
        String code = text.getContent();
        if (code.trim().length() != 0) {
            Context context = Context.enter();
            try {
                result = this.checkCode(context, code);
                if (!result && handler != null) {
                    this.handleProblems(handler, text);
                }
            }
            finally {
                Context.exit();
            }
        }
        return result;
    }

    public static String getDefaultLibraryVersion() {
        return DEFAULT_JSHINT_VERSION;
    }

    private void load(Reader reader) throws IOException {
        Context context = Context.enter();
        try {
            try {
                this.scope = context.initStandardObjects();
                context.evaluateReader((Scriptable)this.scope, reader, "jshint library", 1, null);
                this.jshint = this.findJSHintFunction(this.scope);
            }
            catch (RhinoException exception) {
                throw new IllegalArgumentException("Could not evaluate JavaScript input", exception);
            }
        }
        finally {
            Context.exit();
        }
    }

    public void stop() {
        Context context = Context.enter();
        try {
            try {
                context.evaluateString((Scriptable)this.scope, "window.stopHint = true;", null, 0, null);
            }
            catch (RhinoException exception) {
                throw new IllegalArgumentException("Could not evaluate JavaScript stop", exception);
            }
        }
        finally {
            Context.exit();
        }
    }

    private boolean checkCode(Context context, String code) {
        try {
            context.evaluateString((Scriptable)this.scope, "window.stopHint = false;", null, 0, null);
            Object[] args = new Object[]{code, this.opts};
            return (Boolean)this.jshint.call(context, (Scriptable)this.scope, null, args);
        }
        catch (JavaScriptException exception) {
            String name;
            NativeObject object;
            if (exception.getValue() instanceof NativeObject && (object = (NativeObject)exception.getValue()) != null && "StopJSHintError".equalsIgnoreCase(name = (String)object.get((Object)"name"))) {
                return false;
            }
            String message = "JavaScript exception thrown by JSHint: " + exception.getMessage();
            throw new RuntimeException(message, exception);
        }
        catch (RhinoException exception) {
            String message = "JavaScript exception caused by JSHint: " + exception.getMessage();
            throw new RuntimeException(message, exception);
        }
    }

    private Function findJSHintFunction(ScriptableObject scope) throws IllegalArgumentException {
        Object object;
        if (ScriptableObject.hasProperty((Scriptable)scope, (String)"JSHINT")) {
            object = scope.get("JSHINT", (Scriptable)scope);
        } else if (ScriptableObject.hasProperty((Scriptable)scope, (String)"JSLINT")) {
            object = scope.get("JSLINT", (Scriptable)scope);
        } else {
            throw new IllegalArgumentException("Global JSHINT or JSLINT function missing in input");
        }
        if (!(object instanceof Function)) {
            throw new IllegalArgumentException("Global JSHINT or JSLINT is not a function");
        }
        return (Function)object;
    }

    private void handleProblems(ProblemHandler handler, Text text) {
        NativeArray errors = (NativeArray)this.jshint.get("errors", (Scriptable)this.jshint);
        long length = errors.getLength();
        int i = 0;
        while ((long)i < length) {
            Object object = errors.get(i, (Scriptable)errors);
            ScriptableObject error = (ScriptableObject)object;
            if (error != null) {
                ProblemImpl problem = this.createProblem(error, text);
                handler.handleProblem(problem);
            }
            ++i;
        }
    }

    private ProblemImpl createProblem(ScriptableObject error, Text text) {
        String reason = JSHint.getPropertyAsString(error, "reason", "");
        int line = JSHint.getPropertyAsInt(error, "line", -1);
        String code = JSHint.getPropertyAsString(error, "code", "W");
        int character = JSHint.getPropertyAsInt(error, "character", -1);
        if (character > 0) {
            character = this.fixPosition(text, line, character);
        }
        String message = reason.endsWith(".") ? reason.substring(0, reason.length() - 1) : reason;
        return new ProblemImpl(line, character, message, code, 0);
    }

    private int fixPosition(Text text, int line, int character) {
        return character;
    }

    private static String getPropertyAsString(ScriptableObject object, String name, String defaultValue) {
        String result = defaultValue;
        Object property = ScriptableObject.getProperty((Scriptable)object, (String)name);
        if (property instanceof String) {
            result = (String)property;
        }
        return result;
    }

    private static int getPropertyAsInt(ScriptableObject object, String name, int defaultValue) {
        int result = defaultValue;
        Object property = ScriptableObject.getProperty((Scriptable)object, (String)name);
        if (property instanceof Number) {
            result = ((Number)property).intValue();
        }
        return result;
    }

    private static BufferedReader getJsHintReader() throws UnsupportedEncodingException {
        ClassLoader classLoader = JSHint.class.getClassLoader();
        String name = "com/jshint/jshint-1.0.0.min.js";
        InputStream inputStream = classLoader.getResourceAsStream(name);
        return new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
    }
}

