/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.text;

import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ObjectUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.contentassist.CommonTextHover;
import com.aptana.editor.common.contentassist.UserAgentManager;
import com.aptana.editor.common.hover.CustomBrowserInformationControl;
import com.aptana.editor.common.hover.DocumentationBrowserInformationControlInput;
import com.aptana.editor.js.contentassist.JSLocationIdentifier;
import com.aptana.editor.js.contentassist.JSModelFormatter;
import com.aptana.editor.js.contentassist.LocationType;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.ReturnTypeElement;
import com.aptana.editor.js.hyperlink.JSHyperlinkDetector;
import com.aptana.editor.js.internal.JSModelUtil;
import com.aptana.editor.js.text.Messages;
import com.aptana.index.core.Index;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.ui.epl.UIEplPlugin;
import com.aptana.ui.util.UIUtils;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.text.html.BrowserInformationControlInput;
import org.eclipse.jface.text.IInputChangedListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class JSTextHover
extends CommonTextHover
implements ITextHover,
ITextHoverExtension2 {
    private String fDocs;
    private String fHeader;
    private String fLocation;
    private Map<String, String> fUserAgents;

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        try {
            IParseNode activeNode = this.getActiveNode(textViewer, hoverRegion.getOffset());
            if (activeNode == null) {
                return null;
            }
            AbstractThemeableEditor editorPart = this.getEditor(textViewer);
            Collection<PropertyElement> properties = JSModelUtil.getProperties(editorPart, activeNode);
            if (!CollectionsUtil.isEmpty(properties)) {
                Index index = this.getIndex((IEditorPart)editorPart);
                this.fHeader = JSModelFormatter.TEXT_HOVER.getHeader(properties, index.getRoot());
                this.fDocs = JSModelFormatter.TEXT_HOVER.getDocumentation(properties);
                this.fLocation = JSModelFormatter.LOCATION_HOVER.getDocumentation(properties);
                this.fUserAgents = this.getFUserAgents(properties, editorPart);
                DocumentationBrowserInformationControlInput documentationBrowserInformationControlInput = this.getHoverInfo(activeNode, this.isBrowserControlAvailable(textViewer), null, (IEditorPart)editorPart, hoverRegion);
                return documentationBrowserInformationControlInput;
            }
            return null;
        }
        finally {
            this.fHeader = null;
            this.fDocs = null;
        }
    }

    private Map<String, String> getFUserAgents(Collection<PropertyElement> properties, AbstractThemeableEditor editorPart) {
        if (properties == null || properties.size() < 1) {
            return null;
        }
        IEditorInput editorInput = editorPart.getEditorInput();
        IProject project = null;
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            IFile iFile = fileEditorInput.getFile();
            project = iFile.getProject();
        }
        if (project == null) {
            return null;
        }
        PropertyElement element = null;
        for (PropertyElement prop : properties) {
            if (prop == null) continue;
            element = prop;
            return UserAgentManager.getInstance().getUserAgentPath(project, element.getUserAgentsNameWithVersion());
        }
        return null;
    }

    public String getHeader(Object element, IEditorPart editorPart, IRegion hoverRegion) {
        return this.fHeader;
    }

    public String getDocumentation(Object element, IEditorPart editorPart, IRegion hoverRegion) {
        return this.fDocs;
    }

    public void populateToolbarActions(ToolBarManager tbm, CustomBrowserInformationControl iControl) {
        final OpenDeclarationAction openDeclarationAction = new OpenDeclarationAction(iControl);
        final OpenHelpAction openHelpAction = new OpenHelpAction(iControl);
        tbm.add((IAction)openDeclarationAction);
        tbm.add((IAction)openHelpAction);
        IInputChangedListener inputChangeListener = new IInputChangedListener(){

            public void inputChanged(Object newInput) {
                if (newInput instanceof BrowserInformationControlInput) {
                    openDeclarationAction.update();
                    openHelpAction.update();
                }
            }
        };
        iControl.addInputChangeListener(inputChangeListener);
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        IParseNode activeNode = this.getActiveNode(textViewer, offset);
        Region result = null;
        if (activeNode != null) {
            JSLocationIdentifier identifier = new JSLocationIdentifier(offset, activeNode);
            LocationType type = identifier.getType();
            switch (type) {
                case UNKNOWN: 
                case NONE: {
                    break;
                }
                default: {
                    IParseNode targetNode = identifier.getTargetNode();
                    if (targetNode == null) break;
                    result = new Region(targetNode.getStartingOffset(), targetNode.getLength());
                }
            }
        }
        if (result == null) {
            result = new Region(offset, 0);
        }
        return result;
    }

    public String getFileLocation(Object element, IEditorPart editorPart, IRegion hoverRegion) {
        return this.fLocation;
    }

    public Map<String, String> getUserAgent(Object element, IEditorPart editorPart, IRegion hoverRegion) {
        return this.fUserAgents;
    }

    public String getShowImage(Object element, IEditorPart editorPart, IRegion hoverRegion) {
        return null;
    }

    public String getBook(Object element, IEditorPart editorPart, IRegion hoverRegion) {
        return null;
    }

    public class OpenDeclarationAction
    extends Action {
        private static final String IMG_OPEN_DECLARATION = "icons/full/elcl16/goto_input.gif";
        private static final String IMG_OPEN_DECLARATION_DISABLED = "icons/full/dlcl16/goto_input.gif";
        private CustomBrowserInformationControl iControl;
        private IHyperlink[] hyperlinks;

        public OpenDeclarationAction(CustomBrowserInformationControl iControl) {
            this.setText(Messages.JSTextHover_openDeclarationTooltip);
            this.setImageDescriptor(UIEplPlugin.imageDescriptorFromPlugin((String)"com.aptana.ui.epl", (String)IMG_OPEN_DECLARATION));
            this.setDisabledImageDescriptor(UIEplPlugin.imageDescriptorFromPlugin((String)"com.aptana.ui.epl", (String)IMG_OPEN_DECLARATION_DISABLED));
            this.iControl = iControl;
        }

        void update() {
            BrowserInformationControlInput input = this.iControl.getInput();
            if (input instanceof DocumentationBrowserInformationControlInput) {
                JSHyperlinkDetector detector = new JSHyperlinkDetector();
                IRegion hoverRegion = ((DocumentationBrowserInformationControlInput)input).getHoverRegion();
                if (hoverRegion != null) {
                    this.hyperlinks = detector.detectHyperlinks((AbstractThemeableEditor)JSTextHover.this.getEditor(), hoverRegion, false);
                    this.setEnabled(!ArrayUtil.isEmpty((Object[])this.hyperlinks) && this.hyperlinks[0] != null);
                    return;
                }
            }
            this.setEnabled(false);
        }

        public void run() {
            this.iControl.dispose();
            this.hyperlinks[0].open();
        }
    }

    public class OpenHelpAction
    extends Action {
        private static final String IMG_OPEN_HELP = "icons/full/elcl16/open_browser.gif";
        private static final String IMG_OPEN_HELP_DISABLED = "icons/full/dlcl16/open_browser.gif";
        private CustomBrowserInformationControl iControl;
        private Collection<PropertyElement> properties;

        public OpenHelpAction(CustomBrowserInformationControl iControl) {
            this.setText(Messages.JSTextHover_openDocsTooltip);
            this.setImageDescriptor(UIEplPlugin.imageDescriptorFromPlugin((String)"com.aptana.ui.epl", (String)IMG_OPEN_HELP));
            this.setDisabledImageDescriptor(UIEplPlugin.imageDescriptorFromPlugin((String)"com.aptana.ui.epl", (String)IMG_OPEN_HELP_DISABLED));
            this.iControl = iControl;
        }

        void update() {
            Object inputElement;
            this.properties = null;
            BrowserInformationControlInput input = this.iControl.getInput();
            if (input instanceof DocumentationBrowserInformationControlInput && (inputElement = input.getInputElement()) instanceof IParseNode) {
                this.properties = JSModelUtil.getProperties((AbstractThemeableEditor)JSTextHover.this.getEditor(), (IParseNode)inputElement);
            }
            this.setEnabled(!CollectionsUtil.isEmpty(this.properties));
        }

        public void run() {
            String resolvedReturnType;
            this.iControl.dispose();
            PropertyElement element = this.properties.iterator().next();
            String owningType = element.getOwningType();
            String name = element.getName();
            List<ReturnTypeElement> types = element.getTypes();
            String string = resolvedReturnType = CollectionsUtil.isEmpty(types) ? null : JSModelFormatter.getTypeDisplayName(types.get(0).getType());
            String url = ObjectUtil.areEqual(resolvedReturnType, (Object)name) || ObjectUtil.areEqual((Object)name, (Object)owningType) ? MessageFormat.format("{0}{1}.html", "/com.aptana.documentation/html/reference/api/", name) : (!StringUtil.isEmpty((String)resolvedReturnType) ? MessageFormat.format("{0}{1}.html?visibility=basic#{1}.{2}", "/com.aptana.documentation/html/reference/api/", resolvedReturnType, name) : MessageFormat.format("{0}{1}.html?visibility=basic#{1}.{2}", "/com.aptana.documentation/html/reference/api/", owningType, name));
            UIUtils.openHelpInBrowser((String)url);
        }
    }
}

