/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.text;

import beaver.Symbol;
import com.aptana.core.IMap;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.internal.peer.CharacterPairMatcher;
import com.aptana.editor.common.text.RubyRegexpAutoIndentStrategy;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.JSSourceEditor;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.parsing.JSFlexScanner;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.editor.js.parsing.ast.JSSwitchNode;
import com.aptana.editor.js.text.IJSRootNodeAware;
import com.aptana.parsing.ast.IParseNode;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class JSAutoIndentStrategy
extends RubyRegexpAutoIndentStrategy {
    private IJSRootNodeAware rootNodeAware = null;

    public JSAutoIndentStrategy(String contentType, SourceViewerConfiguration configuration, ISourceViewer sourceViewer, IPreferenceStore prefStore) {
        super(contentType, configuration, sourceViewer, prefStore);
    }

    public IJSRootNodeAware getRootNodeAware() {
        return this.rootNodeAware;
    }

    public void setRootNodeAware(IJSRootNodeAware rootNodeAware) {
        this.rootNodeAware = rootNodeAware;
    }

    public String getAutoIndentAfterNewLine(IDocument d, DocumentCommand c, boolean change) {
        StringBuilder buf;
        block9: {
            if (c.offset == -1 || d.getLength() == 0) {
                return "";
            }
            buf = new StringBuilder();
            if (!change || !this.inSwitchBody(d, c.offset)) break block9;
            d.replace(c.offset, 0, "case :" + c.text + super.getAutoIndentAfterNewLine(d, c, change));
            c.doit = false;
            return null;
        }
        try {
            CharacterPairMatcher characterPairMatcher;
            IRegion match;
            IRegion infoCurrentLine = d.getLineInformationOfOffset(c.offset);
            int infoCurrentLineEnd = infoCurrentLine.getOffset() + infoCurrentLine.getLength();
            String endStr = d.get(c.offset, infoCurrentLineEnd - c.offset);
            String endStrTrim = endStr.trim();
            if (change && (endStrTrim.startsWith("}") || endStrTrim.startsWith(")") || endStrTrim.startsWith("]") || endStrTrim.length() != endStr.length())) {
                d.replace(c.offset, infoCurrentLineEnd - c.offset, endStrTrim);
            }
            if ((match = (characterPairMatcher = new CharacterPairMatcher(JSSourceEditor.JS_PAIR_MATCHING_CHARS)).match(d, c.offset + c.length)) != null) {
                IRegion infoParent = d.getLineInformationOfOffset(match.getOffset());
                String indent = "";
                int start = infoParent.getOffset();
                int end = this.findEndOfWhiteSpace(d, start, c.offset);
                if (end >= start) {
                    indent = d.get(start, end - start);
                    buf.append(indent);
                } else {
                    buf.append(super.getAutoIndentAfterNewLine(d, c, change));
                }
            } else {
                buf.append(super.getAutoIndentAfterNewLine(d, c, change));
            }
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
        }
        return buf.toString();
    }

    /*
     * Loose catch block
     */
    private boolean inSwitchBody(IDocument d, int offset) {
        block14: {
            JSFlexScanner scanner = new JSFlexScanner();
            try {
                scanner.setSource(d.get(offset, d.getLength() - offset));
                Symbol symbol = scanner.nextToken();
                if (symbol == null) break block14;
                switch (symbol.getId()) {
                    case 57: 
                    case 61: {
                        if (symbol.getStart() != 0) break block14;
                        if (this.rootNodeAware != null) {
                            try {
                                JSParseRootNode rootNode = this.rootNodeAware.getRootNode(d, offset);
                                if (rootNode != null) {
                                    IParseNode parseNode = rootNode.getNodeAtOffset(offset);
                                    return parseNode != null && parseNode.getParent() instanceof JSSwitchNode;
                                    {
                                    }
                                }
                            }
                            catch (Throwable e) {
                                IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
                            }
                        }
                        return true;
                    }
                }
                break block14;
                {
                    catch (Throwable e) {
                        IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
                        break block14;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                EditorUtil.flexScannerYYclose((Object)((Object)scanner));
            }
        }
        return false;
    }

    protected boolean checkNextLineForComment(IDocument document, DocumentCommand command) {
        try {
            String content;
            ITypedRegion region = document.getPartition(command.offset);
            if (region != null && ("__js_multiline_comment".equals(region.getType()) || "__js_sdoc_comment".equals(region.getType())) && StringUtil.isNotEmpty((String)(content = document.get(region.getOffset(), region.getLength()))) && content.endsWith("*/") && content.lastIndexOf("/*") == 0) {
                return true;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return super.checkNextLineForComment(document, command);
    }

    protected List<String> getAdditionalComments(IDocument d, DocumentCommand c) {
        List<String> params = ParseUtil.getFunctionParameters(d, c.offset);
        return CollectionsUtil.map(params, (IMap)new IMap<String, String>(){

            public String map(String item) {
                return "@param {Object} " + item;
            }
        });
    }
}

