/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.sdoc.parsing;

import com.aptana.editor.common.text.rules.CharacterMapRule;
import com.aptana.editor.js.sdoc.lexer.SDocTokenType;
import com.aptana.editor.js.sdoc.parsing.WhitespaceDetector;
import java.util.LinkedList;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class SDocTypeTokenScanner
extends RuleBasedScanner {
    public SDocTypeTokenScanner() {
        LinkedList<Object> rules = new LinkedList<Object>();
        rules.add(new WordRule((IWordDetector)new WhitespaceDetector(), this.getToken(SDocTokenType.WHITESPACE)));
        CharacterMapRule cmRule = new CharacterMapRule();
        cmRule.add('(', this.getToken(SDocTokenType.LPAREN));
        cmRule.add(')', this.getToken(SDocTokenType.RPAREN));
        cmRule.add('{', this.getToken(SDocTokenType.LCURLY));
        cmRule.add('}', this.getToken(SDocTokenType.RCURLY));
        cmRule.add('[', this.getToken(SDocTokenType.LBRACKET));
        cmRule.add(']', this.getToken(SDocTokenType.RBRACKET));
        cmRule.add('<', this.getToken(SDocTokenType.LESS_THAN));
        cmRule.add('>', this.getToken(SDocTokenType.GREATER_THAN));
        cmRule.add(':', this.getToken(SDocTokenType.COLON));
        cmRule.add(',', this.getToken(SDocTokenType.COMMA));
        cmRule.add('|', this.getToken(SDocTokenType.PIPE));
        cmRule.add('\r', this.getToken(SDocTokenType.WHITESPACE));
        cmRule.add('\n', this.getToken(SDocTokenType.WHITESPACE));
        rules.add(cmRule);
        WordRule keywordRules = new WordRule((IWordDetector)new IdentifierDetector(), this.getToken(SDocTokenType.IDENTIFIER));
        keywordRules.addWord("Array", this.getToken(SDocTokenType.ARRAY));
        keywordRules.addWord("Function", this.getToken(SDocTokenType.FUNCTION));
        keywordRules.addWord("Class", this.getToken(SDocTokenType.CLASS));
        rules.add(keywordRules);
        WordRule operatorRules = new WordRule((IWordDetector)new OperatorDetector(), this.getToken(SDocTokenType.ERROR));
        operatorRules.addWord("...", this.getToken(SDocTokenType.ELLIPSIS));
        operatorRules.addWord("->", this.getToken(SDocTokenType.ARROW));
        rules.add(operatorRules);
        this.setDefaultReturnToken(this.getToken(SDocTokenType.ERROR));
        this.setRules(rules.toArray(new IRule[rules.size()]));
    }

    protected IToken getToken(SDocTokenType type) {
        return new Token((Object)type);
    }

    static class IdentifierDetector
    implements IWordDetector {
        IdentifierDetector() {
        }

        public boolean isWordStart(char c) {
            boolean result = false;
            switch (c) {
                case '$': 
                case '_': {
                    result = true;
                    break;
                }
                default: {
                    result = Character.isJavaIdentifierStart(c);
                }
            }
            return result;
        }

        public boolean isWordPart(char c) {
            boolean result = false;
            switch (c) {
                case '$': 
                case '.': 
                case '_': {
                    result = true;
                    break;
                }
                default: {
                    result = Character.isJavaIdentifierPart(c);
                }
            }
            return result;
        }
    }

    static class OperatorDetector
    implements IWordDetector {
        private int fPosition;

        OperatorDetector() {
        }

        public boolean isWordPart(char c) {
            boolean result = false;
            ++this.fPosition;
            if (this.fPosition == 1) {
                switch (c) {
                    case '.': 
                    case '>': {
                        result = true;
                    }
                }
            } else if (this.fPosition == 2) {
                switch (c) {
                    case '.': {
                        result = true;
                    }
                }
            }
            return result;
        }

        public boolean isWordStart(char c) {
            boolean result = false;
            this.fPosition = 0;
            switch (c) {
                case '-': 
                case '.': {
                    result = true;
                }
            }
            return result;
        }
    }
}

