/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.sdoc.model;

import beaver.Symbol;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.SourcePrinter;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.sdoc.model.Usage;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Parameter
extends Symbol {
    private String _name;
    private Usage _usage;
    private Set<String> _values;

    public Parameter(String name) {
        this._name = name;
        this._usage = Usage.REQUIRED;
    }

    public void addValues(List<String> values) {
        if (this._values == null) {
            this._values = new HashSet<String>();
        }
        this._values.addAll(values);
    }

    public void addValue(String value) {
        if (StringUtil.isEmpty((String)value)) {
            return;
        }
        if (this._values == null) {
            this._values = new HashSet<String>();
        }
        this._values.add(value);
    }

    public Set<String> getValues() {
        return CollectionsUtil.getSetValue(this._values);
    }

    public String getName() {
        return this._name;
    }

    public Usage getUsage() {
        return this._usage;
    }

    public void setUsage(Usage usage) {
        this._usage = usage;
    }

    public String toSource() {
        SourcePrinter writer = new SourcePrinter();
        this.toSource(writer);
        return writer.toString();
    }

    public void toSource(SourcePrinter writer) {
        switch (this._usage) {
            case REQUIRED: {
                writer.print(this._name);
                break;
            }
            case OPTIONAL: {
                writer.print('[').print(this._name).print(']');
                break;
            }
            case ONE_OR_MORE: {
                writer.print("...");
                break;
            }
            case ZERO_OR_MORE: {
                writer.print("[...]");
            }
        }
    }
}

