/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.parsing.lexer;

import com.aptana.parsing.lexer.ITypePredicate;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum JSTokenType implements ITypePredicate
{
    UNDEFINED("UNDEFINED", -1),
    EOF("EOF", 0),
    LPAREN("(", 4),
    IDENTIFIER("IDENTIFIER", 1),
    LCURLY("{", 2),
    LBRACKET("[", 3),
    PLUS_PLUS("++", 9),
    MINUS_MINUS("--", 10),
    STRING("STRING", 5),
    NUMBER("NUMBER", 6),
    MINUS("-", 12),
    PLUS("+", 13),
    FUNCTION("function", 26),
    THIS("this", 16),
    NEW("new", 14),
    NULL("null", 17),
    TRUE("true", 18),
    FALSE("false", 19),
    REGEX("REGEX", 20),
    DELETE("delete", 21),
    EXCLAMATION("!", 22),
    TILDE("~", 23),
    TYPEOF("typeof", 24),
    VOID("void", 25),
    SEMICOLON(";", 29),
    COMMA("comma", 32),
    VAR("var", 33),
    WHILE("while", 35),
    FOR("for", 37),
    DO("do", 38),
    SWITCH("switch", 39),
    IF("if", 36),
    CONTINUE("continue", 40),
    BREAK("break", 41),
    WITH("with", 42),
    RETURN("return", 43),
    THROW("throw", 44),
    TRY("try", 46),
    RPAREN(")", 34),
    ELSE("else", 47),
    RCURLY("}", 48),
    COLON(":", 53),
    RBRACKET("]", 49),
    IN("in", 56),
    EQUAL("=", 51),
    CASE("case", 61),
    DOT(".", 55),
    LESS_LESS("<<", 62),
    GREATER_GREATER(">>", 63),
    GREATER_GREATER_GREATER(">>>", 64),
    LESS("<", 65),
    GREATER(">", 66),
    LESS_EQUAL("<=", 67),
    GREATER_EQUAL(">=", 68),
    INSTANCEOF("instanceof", 69),
    EQUAL_EQUAL("==", 70),
    EXCLAMATION_EQUAL("!=", 71),
    EQUAL_EQUAL_EQUAL("===", 72),
    EXCLAMATION_EQUAL_EQUAL("!==", 73),
    AMPERSAND("&", 74),
    CARET("^", 75),
    PIPE("|", 76),
    AMPERSAND_AMPERSAND("&&", 77),
    STAR_EQUAL("*=", 79),
    FORWARD_SLASH_EQUAL("/=", 80),
    PERCENT_EQUAL("%=", 81),
    PLUS_EQUAL("+=", 82),
    MINUS_EQUAL("-=", 83),
    LESS_LESS_EQUAL("<<=", 84),
    GREATER_GREATER_EQUAL(">>=", 85),
    GREATER_GREATER_GREATER_EQUAL(">>>=", 86),
    AMPERSAND_EQUAL("&=", 87),
    CARET_EQUAL("^=", 88),
    PIPE_EQUAL("|=", 89),
    STAR("*", 52),
    FORWARD_SLASH("/", 96),
    PERCENT("%", 97),
    QUESTION("?", 99),
    PIPE_PIPE("||", 100),
    DEFAULT("default", 57),
    FINALLY("finally", 105),
    CATCH("catch", 109),
    DEBUGGER("debugger", 45),
    CLASS("class", 50),
    EXPORT("export", 93),
    YIELD("yield", 27),
    SET("set", 31),
    FROM("from", 28),
    STATIC("static", 103),
    SUPER("super", 15),
    EXTENDS("extends", 104),
    GET("get", 30),
    OF("of", 91),
    ELLIPSIS("...", 54),
    AS("as", 94),
    IMPORT("import", 95),
    STAR_STAR_EQUAL("**=", 90),
    ARROW("=>", 58),
    SINGLELINE_COMMENT("SINGLELINE_COMMENT", 1024),
    MULTILINE_COMMENT("MULTILINE_COMMENT", 1025),
    SDOC("SDOC", 1026),
    VSDOC("VSDOC", 1027),
    STRING_SINGLE("STRING_SINGLE", 1028),
    STRING_DOUBLE("STRING_DOUBLE", 1029),
    NoSubstitutionTemplate("TEMPLATE", 7);

    private static Map<String, JSTokenType> NAME_MAP;
    private static Map<Short, JSTokenType> ID_MAP;
    private String _name;
    private short _index;

    static {
        NAME_MAP = new HashMap<String, JSTokenType>();
        ID_MAP = new HashMap<Short, JSTokenType>();
        for (JSTokenType type : EnumSet.allOf(JSTokenType.class)) {
            NAME_MAP.put(type.getName(), type);
            ID_MAP.put(type.getIndex(), type);
        }
    }

    private JSTokenType(String name, short beaverId) {
        this._name = name;
        this._index = beaverId;
    }

    private JSTokenType(String name, int index) {
        this(name, (short)index);
    }

    public static JSTokenType get(String name) {
        JSTokenType result = UNDEFINED;
        if (NAME_MAP.containsKey(name)) {
            result = NAME_MAP.get(name);
        }
        return result;
    }

    public static JSTokenType get(short id) {
        JSTokenType result = UNDEFINED;
        if (ID_MAP.containsKey(id)) {
            result = ID_MAP.get(id);
        }
        return result;
    }

    public short getIndex() {
        return this._index;
    }

    public String getName() {
        return this._name;
    }

    public boolean isDefined() {
        return this != UNDEFINED;
    }

    public String toString() {
        return this.getName();
    }
}

