/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.parsing;

import beaver.Parser;
import beaver.ParsingTables;
import beaver.Scanner;
import beaver.Symbol;
import com.aptana.editor.js.parsing.JSFlexScanner;
import com.aptana.editor.js.parsing.JSInsertionRecoveryStrategy;
import com.aptana.editor.js.parsing.JSParseState;
import com.aptana.editor.js.parsing.ast.JSArgumentsNode;
import com.aptana.editor.js.parsing.ast.JSArrayNode;
import com.aptana.editor.js.parsing.ast.JSArrayPatternNode;
import com.aptana.editor.js.parsing.ast.JSArrowFunctionNode;
import com.aptana.editor.js.parsing.ast.JSArrowParametersNode;
import com.aptana.editor.js.parsing.ast.JSAssignmentNode;
import com.aptana.editor.js.parsing.ast.JSBinaryArithmeticOperatorNode;
import com.aptana.editor.js.parsing.ast.JSBinaryBooleanOperatorNode;
import com.aptana.editor.js.parsing.ast.JSBindingPropertyValueNode;
import com.aptana.editor.js.parsing.ast.JSBreakNode;
import com.aptana.editor.js.parsing.ast.JSCaseNode;
import com.aptana.editor.js.parsing.ast.JSCatchNode;
import com.aptana.editor.js.parsing.ast.JSClassBodyNode;
import com.aptana.editor.js.parsing.ast.JSClassExtendsNode;
import com.aptana.editor.js.parsing.ast.JSClassNode;
import com.aptana.editor.js.parsing.ast.JSClassTailNode;
import com.aptana.editor.js.parsing.ast.JSCommaNode;
import com.aptana.editor.js.parsing.ast.JSCommentNode;
import com.aptana.editor.js.parsing.ast.JSComputedPropertyNode;
import com.aptana.editor.js.parsing.ast.JSConditionalNode;
import com.aptana.editor.js.parsing.ast.JSConstructNode;
import com.aptana.editor.js.parsing.ast.JSContinueNode;
import com.aptana.editor.js.parsing.ast.JSDebuggerNode;
import com.aptana.editor.js.parsing.ast.JSDeclarationNode;
import com.aptana.editor.js.parsing.ast.JSDefaultNode;
import com.aptana.editor.js.parsing.ast.JSDoNode;
import com.aptana.editor.js.parsing.ast.JSElementsNode;
import com.aptana.editor.js.parsing.ast.JSElisionNode;
import com.aptana.editor.js.parsing.ast.JSEmptyNode;
import com.aptana.editor.js.parsing.ast.JSErrorNode;
import com.aptana.editor.js.parsing.ast.JSExportAllClauseNode;
import com.aptana.editor.js.parsing.ast.JSExportClauseNode;
import com.aptana.editor.js.parsing.ast.JSExportDeclarationNode;
import com.aptana.editor.js.parsing.ast.JSExportSpecifierNode;
import com.aptana.editor.js.parsing.ast.JSExportsListNode;
import com.aptana.editor.js.parsing.ast.JSFalseNode;
import com.aptana.editor.js.parsing.ast.JSFinallyNode;
import com.aptana.editor.js.parsing.ast.JSForInNode;
import com.aptana.editor.js.parsing.ast.JSForNode;
import com.aptana.editor.js.parsing.ast.JSForOfNode;
import com.aptana.editor.js.parsing.ast.JSFromClauseNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSGeneratorFunctionNode;
import com.aptana.editor.js.parsing.ast.JSGeneratorMethodNode;
import com.aptana.editor.js.parsing.ast.JSGetElementNode;
import com.aptana.editor.js.parsing.ast.JSGetMethodNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSGroupNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSIfNode;
import com.aptana.editor.js.parsing.ast.JSImportClauseNode;
import com.aptana.editor.js.parsing.ast.JSImportDeclarationNode;
import com.aptana.editor.js.parsing.ast.JSImportSpecifierListNode;
import com.aptana.editor.js.parsing.ast.JSImportSpecifierNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSLabelledNode;
import com.aptana.editor.js.parsing.ast.JSMetaPropertyNode;
import com.aptana.editor.js.parsing.ast.JSMethodNode;
import com.aptana.editor.js.parsing.ast.JSNameSpaceImportNode;
import com.aptana.editor.js.parsing.ast.JSNameValuePairNode;
import com.aptana.editor.js.parsing.ast.JSNamedImportsNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSNullNode;
import com.aptana.editor.js.parsing.ast.JSNumberNode;
import com.aptana.editor.js.parsing.ast.JSObjectNode;
import com.aptana.editor.js.parsing.ast.JSObjectPatternNode;
import com.aptana.editor.js.parsing.ast.JSParametersNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.editor.js.parsing.ast.JSPostUnaryOperatorNode;
import com.aptana.editor.js.parsing.ast.JSPreUnaryOperatorNode;
import com.aptana.editor.js.parsing.ast.JSRegexNode;
import com.aptana.editor.js.parsing.ast.JSRestArgumentNode;
import com.aptana.editor.js.parsing.ast.JSRestElementNode;
import com.aptana.editor.js.parsing.ast.JSReturnNode;
import com.aptana.editor.js.parsing.ast.JSSetMethodNode;
import com.aptana.editor.js.parsing.ast.JSSpreadElementNode;
import com.aptana.editor.js.parsing.ast.JSStatementsNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.editor.js.parsing.ast.JSSuperNode;
import com.aptana.editor.js.parsing.ast.JSSwitchNode;
import com.aptana.editor.js.parsing.ast.JSTemplateExpressionListNode;
import com.aptana.editor.js.parsing.ast.JSTemplateNode;
import com.aptana.editor.js.parsing.ast.JSThisNode;
import com.aptana.editor.js.parsing.ast.JSThrowNode;
import com.aptana.editor.js.parsing.ast.JSTrueNode;
import com.aptana.editor.js.parsing.ast.JSTryNode;
import com.aptana.editor.js.parsing.ast.JSVarNode;
import com.aptana.editor.js.parsing.ast.JSWhileNode;
import com.aptana.editor.js.parsing.ast.JSWithNode;
import com.aptana.editor.js.parsing.ast.JSXAttributeNameNode;
import com.aptana.editor.js.parsing.ast.JSXAttributeNode;
import com.aptana.editor.js.parsing.ast.JSXAttributesNode;
import com.aptana.editor.js.parsing.ast.JSXClosingElementNode;
import com.aptana.editor.js.parsing.ast.JSXElementNameNode;
import com.aptana.editor.js.parsing.ast.JSXElementNode;
import com.aptana.editor.js.parsing.ast.JSXExpressionNode;
import com.aptana.editor.js.parsing.ast.JSXOpeningElementNode;
import com.aptana.editor.js.parsing.ast.JSXTextNode;
import com.aptana.editor.js.parsing.ast.JSYieldNode;
import com.aptana.editor.js.parsing.lexer.JSTokenType;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.IParser;
import com.aptana.parsing.IRecoveryStrategy;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.WorkingParseResult;
import com.aptana.parsing.ast.IParseError;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.ast.ParseError;
import com.aptana.parsing.util.ParseUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JSParser
extends Parser
implements IParser {
    static final ParsingTables PARSING_TABLES = new ParsingTables("U9pjNGTy5CKNVZERItAXzvP02Bqd8OG4HR4hLMme8Y8MK1GKnOe5HB60Q5Ig21O4RDW11S52awOqwKL4x1LKsip$czd9tTubTxaSAqJ$j$czVLE$#URDczdPtRiBqGadqXOwJ5lf4Ez8csWpxyGxypFvLLILUl2gl1eDfIgiEZrBZzCJh0QhoMgnP9RY3rbzg35DvdFPN4fYrx3#j8fMyyjvBtu9luYVpslGPJoRr#NdyYxyBDwQf$8hULysbNhH2lg2FcUFiJ7iSVO4osDFigVOqsmi6yV6imci1wjcjqafV9vk#tBAOtrf9LMZBF9IF4rcpLXpre96iTuHzA0pwqLfx1wgPtLZ#ocEFEm2ljAwIYDdylxyFNObcykEq6F4tUa1JMIjMHORnj9PAy5f0cmuHlT7zQ2qrO$Y$JRago8QWngs3QnkL4htm5UVnjELl35VWp6uYGRJA#xqG7wbKUVIMnfrWBR$jT3e0Uj1IHY38bdJGBQChgSRe5TetPKtfjvaqUMg1sPavmAr0vtYajtdqljMUwitbUOp5AhLqlY9ilijT6ierXRBPyrdyfVvA$nL$Xf$dS$YR$0t#LlyRVuEMDTKhAaMbQLtkM2hb4NuBhux4jPi7l#Q$yeUuz$nR$dtYZN$cV#YMFEV#6ziWKNy6xwN$y1$fBje6$rE3zAlz8ks$5bq1gjDfzEPr8#6qqRwaNwYd#atEfLEexFf7Ef8BzBv4Oo5FPzkezlLkDA5rdaQ$LlwZhwd7sWolKtlO0xSnFgp3rmQYsiTwyG5z30RJW#nUzbzUYngqo1#JU6i#LS#rWFXzyflybasPNyv$Bwv6c7CNa5FicVOaKZ7WkyCDnPy1flc6ukYhMgOMPU5yXkM2QlQgvSxLcr9Xra5EgJNbqnxNhBbzhoaT1eTogf1ytA9FIzfhDRtmoCoiOflqZwoI6FFPUquewVTOMtFTNuwow4Fu0jBs73siiyN5aVc2zHTSMKpMNcVFqW#nnTMQyYvy8Ln$3f6Rla2$pEyBpZuvVF8fXj3hY7TiMxezIZYTMDwE7uqWFyTCJzx$i#15GVIR6r9UsNCeI5Mp$phAUpt35tDSYFcDwS8VaSYvMVOT6UdWzySxPMVqXgMm19fBVEmYiohmk3t03kDNegOttVX#Lbb8kLddKiVqYxDPo2rq$P3M0kkyPGcbj5ysednlLGqOJqZvlTB4VmgHMo$Qk80TO6b1e3VnPhV0LZpRVOYTapTyTUKpMQhmUyBTbqnrigRYk1NDM9#d$9#YWVRI0EjwnK$M4p5TxDlCI#QipzuCtQG2vxCQre38kOt91m$iSog6J6$G#1IJJEgnklnncfKzSXsXxLkf2p#0X$3Uu1V0vxB8rzVRW#xlZIqKYBbnnFvzNmWR7WTlvctnNeDflnEVXlE3x4ZsBjs5qtulU1tWsXCpIFcTtTOVksij8Zv3RSkqPmUf3I#W8#Yz$bin9RmJtNgSiWU$ZdcxrfHZrUAcDzzOVtlNQj1nEjVT$1Q1rwApIQ#JUlz$B3ILe9L6kVgLXNmwqwFYhI8#Oq8kwzxtMeIEJ#hZfMiHjEgprwp6icth5QQusoh6VBQMbaqILq$a3R5EY5YVYF3yZjiDI#6$LfQ7TZVoexMwROThNEiBgmFwu6PF9rcqWnA0hzPSeVS7Z6$ZyEExo0hCs9#xz5SkLLkaPlb9heVuLtqYTmhTs9Fj8SocSNYMH8hW$MlB6l8AaVCRr7O#N6wrIRYzQKnFmLxWnngnzgAlzbvD9ETB#V8sUmo#Hvis8yDP8FPRLp8Tt7tEpHYVil2yRDEid8ZjjzCTZSRWRP78lGGUnJtU3FPAFOIUzuwbRt2Ph5tsGBsFkpNWosacH7pMn6Mto3hn8Zjzn6Ro1PRkADaIn7w3BAIVSxMGgzZct7UmhOnTVtTnRvctqJCxukmy#C7wvI8#Vt6zh73R07MwGHs7kiXvrDJNfkdyKRyH9w55Va4VZ8$0#lpsTIITusOt$gmyoFTEYFYyStatVa5bCrxKWw$ZDhnFlnQTfW$mSVn9$dJV0AV1E$C1hz928#BcD$ciFFZQQjZnDUF9$aqi7cVpvTJvBDoidn6Jf8JvGGvNewJO#NJyYdvfCp3$7X2Fix$Y9ZVzh3y$hAwHdwln#DuekmhirbjLfiVvDAAamtaivR7IcIPifkL9BjQvTXSsOLcoiukFGTJzs7wtb5saXtjUprvZZnRFuEfYBzd8xhNitU3EEHPyanMZfMJPz0YNacUpkwHfybJPGSsr#ekJwBHBjsXpgG5yXHQ8a#spXSDp9EZnRoyPZtCkZWorhoSPdqFzZNrhSkjljRLrc3hHkic8gIHDHXwBf5xJuwiQzbTj0Iem$WCwmOWBm7dBzc3DcjQ78ercr$KaoE#XHo7PgsE25cpUM5jJL4#BzAZmYkopY7cPRnlBFxmKJ#0EmjIeyAhKD31vgfHYVp94PiUjbU5S#hdMsiVqMqEAy3Ypq1EV42nB3sd#9o0dc#dY0xCjC75uhGZ2avB0ZWjBfgJ2KJAwRjZOQTYSlgbv77YDvL0JaDA8AVRIo2dkqiWf$jA8ASH9P3Jo1B8wUCIo6bH2UIqh0Ho2h$RFJwSlYY1dDQNG4wRIo2dxIMFasM5$Io0uDNPnCBlCdZxmkyoECTTna0sHR$98QeEJdlOS#nxjftzobvbCzWxx0tsCTlA5jb4kLLOFwGyofOJqF9hqRICz7#svPUFMykl7g#MsIJLyZ$hIspoFz#6xJMnDlx9DjY7mMrONlwxLTRYTXlyG7uRRc27ub$IUSUmOzWnx1Xs33k67SCkyAQ3$hdhV0mxXXt3Zc77i6FO$t$O#KyfwNdrb9Bkes5q9xMdzTI36b136aeRg2#zGFVGlTI9wb9drePEP1ci9MlAgj9U#fAUexlf2hJHY5Bf6fVGHYeqreN51JpI2eMDWvMYKG7O9uV2jdfG8xQ6SLQQelt4nJxMrLMhdUVl8ZlL7MHsaRPWn$1Mmn6PrPhG8qNWK2Gul9RfvPciKudqkswkebtbAjhDhgBTuIhQ28tsfvjZoiuEE#UBX$YNvbV7fRbrZfksOo#uYlQMgsZlkOhsYQjeNxgAzfMhQ7lTHEE3NKKRv6fFVtSLJRhQq$eAZQUNn2iDpt4LxLQ35i5EYOWt3Nkjpk33IgJ5xd4LxG5NqHQxYkRgEia$SnLjjQjeQrr5s#WgsbPNqVQvYdR8JJGhtbMqKgwYLNCLhRAhQBLSHMleAbezLz6QkegMxIfQQrVHshcAThAhQAUvYdQsgsYTNKMxLAFLT$afYvje5xYATf6hQ7rSHPlgAjewLz6#SHNjeAlFBogvYjR8LRGBNKMxmbMq#zr4uockehdq1CcWjN0LhPMhQ9bkebckUeXrfQjeeNvboVyvxS9QeyAVVFFAr1bts4LyJfjwKg$YF4$d6$nzu9F9$gwiVLmQzgs8#eqR1uvrfXF7$0hT8DP0VHENpq05$NjKrbdwAS6pvcd153vLw#VOIJW$pzfRDqDFfx$vOtm7VoJKTsMjJkngWtC9ZRQky#FGH8qp3ESxW3F1nWbhZvGWUpmQQ0#hTgZQreM5M3EWjldjm3jWW#6ilFubgwTG$WXaW4hZ5NNQ7FJZO$g8dUBl1u#dWUZ70#nXRG#1VZoCVWn4BQHnZsya5z9ssvhiJaTjBoNpvrKQEm6r2RL7XxQ2#aukofuOnWgXQjPZzLasBnkw9bklteAn3VblmNXvj5HRVoUt7p$DyHRCxnKlEaQJU1dqm$uMijsF5$aZLE2mQ$AJ71QeeEndlw4qDLyARm6U5DOFYZEZ$WaBaEv7LVJZ0ss1eEzM5sA1qW4Mg8IQ7nRX0zCev9ksC1OOG1NrRpqM$OwkcQPQcNN7UI0iOBy$BgGVpfK1rZeN$PYcOuz7#LOr$$WRifk#rlxUhQ0VuTYF7Fjt#0v4rnRhR0Fbwu87kzxeCsYqIOgohO1#EG#zka3KwcAtTPOlxq38aJJVsozw97cRa1XpW86rB0e$cajBDR#YMc$XynMEqpnVlwex3L2O7t6BvnsbdN5O5uKQrw1ZzD6tnPluWk6VkcSKPJL#JcW4u#$57Z7p2Og$YsYx5RkHbVBP9EJX735MXvNcJqKv$uBMsuXgHJjMnx8MiJU3RSQgHDDR1gzYFnfhlnircv#Eth$PpqVtExOEZrI7yshSt$P8gvTfIHmzMySHVZQs33yZU3SNLePReiNWTxdG#b0NC4BVY$j7CTIA56tV5nQOByetQklM0cjIm6vih0lz$SW5ZALHhMuuhF8sWjKYMXPM1HUkdHLTmAWHTGzINMYzhWiOZQFkGReBhMUuW97pBxXUnch5QiLgnMh5QXtxMaVnUMuU#btgFxKlBF9kWdUms#EdElQ5nCV$2qOYLYjMgmJKYkevnN#iJlIh8hKkoVqwPlQxYsOM$vjg9Rb7$xKwqNiulx0azojM9rRdQFoxu5lWI9$R5U$W4qkozOwbnIdq6ygYnkhYg6i#4rrDQXjTFHxsypcXwb5kDBLux#BMeXFen6BNEIbq7VjJAWNhy2kAtmw$6dKSxyZjJ#ZutvVhJoZOlnnl$pyq#wmEymaSyn##9kjFw4ncvx9Ra3UAtPvVafUo#gDa0tOdkug#qZNdi3jfCYsdgknMTWFA3w0gllRJrDjiLbUtEeYDfg$rj#gxiI7i15f6dvbUb7EqVorNlysOI3jmVeENfGhiHEJS3Ba4AQ$JctR$qBxgKu7F0zW7EvbrODawM9wgvVVFzxaCHvYbql4uoj0Wkb6l5JVJBJI4RjN$cV8EZEvTD9JkrYEQGmlf8$gOJj7hnkbqXYDq9Lr5goaFVycqbjRHM1f7usa2JQH9z0n6urcQGbFfEVZD2rXhfj5BD9rcO9VvChr2hz9hiECiUWEsV4lztqjwbzwZsJI7uh1MsMtc6Ss8aqMBQ37jmHgs36sU13$heDiikWUfj1SUd8VLyHjAr$yXi0tMGXiv2$FrTyf0Rdl8doxrO2dreIlWYwMf34PsjS#6gWSUEe8U#6sO4yaOi6h61jymh#w1lxv0QXnT2lO9y5UtUf2iKVDWEuLgjzqMMlKW3hdB8c2TJDTIRQe3VOFM2d4Bnc2Rxa7#2BSbBoMvn5hn$1687cgjKNytVWBMwh#LHi2w6vrBtUayt8TVG1VIHTI3BgPBg2TOfsZMgV2$BB2sBU8EwpnwdpwWUJIVFZIuwZ$SnclBgrwKKdv4PR4#bQSAL94gKMMgGbMnebId6bIJQaKm5hQr1s2zKUXPj4AZduazWje9hAQ$wG1uO3unSgbNRHq#oc0tYz9qhvG7jGRZeiSY6ND3#Kq#oowOlNxCpjeskM2TZlrEUvTOjtQCHT5MpMUs8QJVkEqhdGmdjRva6UHzPbvsfEp8vYKhO#PbgczURdAijGexJ#yYqrrYRIEtPJM1o2WJBJAVB#H6w0isrnJmohVwVipr$B3oXGpR5nWx3hwGp#FBCBwG2dxsUkJMQXSvFti4je93ClOqof8saw$rcf1$FSt3zJG38tFi#Tdjfsf#MpM$7HXhjSTDnTMwArOJ5Su3EpNAnvxV2irDSKYctPgV2YjHQ$CMS4p7dxfUjiCwT#pvROItRW0BPRzscbywmYdWiaSpxu9G6lZLX$tSMYkBmoy5zmsAHvfl9iUPU9fF$m1#QaVfrghJfXZybBKsQYORzNgeHbL9AgobRAXuxJ7#ryQrAsJa$BZshyrWaABvfPhHJTKCsnk$ouCDs#7AUEpvfS3xx77SWl0sy7KoJ3DXUtxqTubVLZ7ufO9N6dW5#vnVv$DB0yDZFp#SjahHuHGTyzkkZRv#f6AUkxM#R2uMlqvezuy2TcmDNso3rP7JIipiFEoEa$7d3hz1nU3N6zPEDd#M3lV6NpBsHAsnj#bBw$7N5lpMOu$KwpZCZrwO7r$YQhiRV5eRUt7yfK5QwrKbG$iVXprNkCGlfrZhoqemY3FCLY2aT2jzPwdyKTqBje7O9TpXjxqO$5RgLl$27UK#7L9s6gkjbtzEeNgQNuhESUSvHEJybBqsw$7xsLYl2#or0IaR4EgixmBKSvBEc4UTNEBNiHZyDf7wXkINsWUL5#u6kyrWrb4pseIhdihBWrObtRfNYPnVP$3fekT6gp1$UVhirlYsAjQzdhhNKgsNmfzQy#ePBYcu3YdTIi#HLhgKE$pKVPXzXwTQyeVKNLDN$4Ns32PDxxQkmP#gUnt#55P$dpMLLZCzsoNMQgVI2lTuhO3Qph3EfQMQzNAmYOprJitQtY#ebQSra7hJTYaf3yACTk$9KJeOPW9nELfAXyu4vnmVwzoZU79qgNGSYhNMhh1MbeZgUP5TwsTOj$1U7VBrAiF7F9kISSQei2GPTAYLJKhNdXmLpccpZzDItURo0Yn#2EBqXtkMBfmJq0sdO2w57#egy4zpWkSwE55kqPpSz4Ytx1JZ5ECKunJZ5ECKunJZ5ECKutGSEL6KTnd9k3V6$G9ur8NKe$hw5vuQKMDgGasf6JMd5jJICCqij1z7sJ9THdNfycXQZlhEAiAMxNlC$yUM$rbVEXPjs5uJQwDaj173Zc77i6FOCUmOTWmxXkt71bOCEuOTmuvXnx1Zs35izx2B$WI7#exWSBgVHj03z22Df8VeONg47gLHD9eUep7gMtp0VvAUegVTGQEv1crzm1Ej4DWwxtjQ6o7sNeNDEBDajC$8Tj5NxbhDtqTMpYKB3in73cSrv4PkjR0uG8gmnxgiwnPqsUzYQCSHpJahNEBtbQkzTHUj18z432s65aFxzrnf8jafOOzHkmZKkVy$5ekXnT1YQ36q65eCBORstqHpTnyIGukXnT1YQ36q$pQQz7rEkx1yv8PyyesKI3wd7VNpTAc$AsjAhGpxLaJzfareMzXlFxPJLwc#pTWQPnifHzTTO5huX3xLUWdrnVapkfh#Wbv5gVGvVK5hGdzNrlw#AIrWTIYRLN3WBDKuot7#3JYh3KwuVkGLOO$VGdg4AFBjXFcbB9Inw5Vr9eXLHtY$b2RjP$rsQ2ijWALsCEReno5AHZ$iDsohM5dJZmBVhAM3b6vRax8SjTFf27scqzRJAkYmLh2$1K3VX#b7Y9eiZdbOFFKhqW$yRy7K#9JIunFm5ipl5LJJtm$8JbZ1nl3rGnOuJCss3WiSTjel4WkmAc57CletLAvOGCTMWQcn0DrRF0lGkA8jG5dHMC3tMuyHh8kQsLPjWMHQRdChh1$EbS5O8CjO8AgtgZxqL8np0ajKOLQge1#XH8RlpMrsb6zmK$rj5NxaVrUUCYZRXA9iozclW1RqwW81Mc2RkgrG8sbMbuYkSA4mjW83QrbKVdHGyokoTLzFQc8KA$jYTOlqeqpVMXAbdJLIMgXn3Hg3enpJmBQAUDEU7S6OXKGmF8i$OkjjtokoxGpwFfzd67ivHanzWW8hsD7yPaNnQaKxruzXBLWcfO3DUaM5rSkFHNMZP#E6VxlrExOQhT2hiKbfS$Hi7RoFTZOUDyiTtt4Bmd1lJnLrttKxUYSGVZTMOcmM1OQk#Q#Ux$yvp$y$xK6iLgnMh5QiLgpMVxpMqNsU#nZl2ujxD#6uKotv8n6h5QlrRwtrNwjpDAjYIUvNYQqZPSppOXuUgnEhSzpzEyhdTiKxQ469jjwnjVY$gUQnhNViQhbOn$TRbMwrutX77lo#tF$ByUOJFFgiq$BVaTl$uMkr3g#cdRHEIlrVHar9IYUESrVAebtgjmRrvnwoK787Uh9NbsHWbTz#N$sUuMfTRfV#dxPrrISKID9wzHyNJI$6#TjdfVL$8SXYAIZdfNwKgzwn4agngf2Ah9BvX55MOVtBF#pFxsZiHRJOsR$WCAjHnDBpZnoiF95rottwNz1Mg0Zffi9E8Met3gT4Eqpl#DD91fPhbXvSrv$7WCrkjyDykz69HEa9ZZAvjavFSzO5oNb4pIz0UIzHcphG5Q1peKT3dm$z3FGDg3yNUYJARu9UWAgreH6c5w3$WEvCb5t6trvs8zFkLQ5uX#bFQyErFUpNneGlDdbBJFncMyUzWRPEAOZ1BpJb7ZFbfkEq0$6PmDpeBzUa5Z2JKFwhedcbVugwOnqyHvbqu7eMsc7FAv1Pa6SBuIHHzY2u6Diqkn9fbL4MwSrXy$X#a7CXBnDvrnLIFzFe7RQsSWBpuwVYjCuHVuaeeue9V#PFRreQtAiI9QH0qkoq2gOl5PQPlbs3l2H$7VeL64sHLWPI5X8FkGhIqL$6WiybT4B$Xa337xpeQq8NVtv2ESXr9bm#a7i2#frmVc5sj$FZCcoTaHvKhs7XvHjFDlLkjNMxWOuw9m6dantcfKErMH0poTYzwMa5ypAkyOUznkUyOnpyCSu95KmOTe#h6TI$NWv#9oFUjs0RpGSXhxO$JdU5vnk7yMcq2dtlKZ0luJJWFG9ziJ#DPGRLVzeVvaCBmNWGPJn1TTv2#iWGV1hRkkaTHiyAnp#mBfq9tFVjSAtn$dJlQgHZ3Ojx27e#UBu9$InaWU4u1cCpp62SP#l6rKnUdeFRKiDfYCbxqjRDVZBnfmhf$ukGnNROW$dRT0FYYx2SyyBxa86rD66z7Mwt4UKiI8A9RqSOyoUnLAGsAOXVCTxed89vYPZp6RFHJ$X3fKpms4bKxG8xpph1z6U$hUDVC$4$RTrych7H6eE5wrh66iJN0cEuARiBk7q2sxIseIpyFh6wwVzFi9EnVIAkBRGOzNunSOSV9bu2Nvm4$7K8zxJJidiXZEj1Ocz$kKpOorFLrEa0kSA4pxPrDLmR4k7dYPW7cVLG5jUinCwc3DQtJAm37bppgfbhPYBcG$Fba1#9Mk1wMBsqIP#Aik3aIKCOrpio#Doiut7pRUsvmC#jHJEJTZN6upe8nhx9X$3Nfv2MRyUNRDrukgtRzG#qNxiPfjnqVrfBN3CINmui5uTr8MuFR7Ghylg0wotGTq0xrX$FI6CpN5iy$Koz5hPkDi6KgMUuzp5b5pbilTDmGN#o7uV6jShp9T8FGVStU7VxopT1VnFViSFiJtzw0kh5hVJ74wy77ZWb#jPdauu#PNyA3NibufgQZVd1CGOM$2dxRnI0V$1gH6tJaNOd17kIjXt11TKzmn76c7Dr7Hs8y3s1s6t71xMr5EEZveMoWV5rZnaRputmWtOcZ7Mc1QwfrKr$FLXlgeyruO#G1vmM68VgdveqyA$#knsEJy3OGMgacZYkdpMw6Zvl#RbOboA#mjJFGFWRyCEQcgDulWjT4nhpE2SB#ZtehgY3j9p#s9jXlkHCGHppAWxu3FFDwero2o6x8R1R3kQi5$CtnwnhYGUSjeXKS2riXJvWBv1qq8vxCIwvPYtpLa6uhXrkYNMxvRtewr3JR#mTQhnimjYtjdmEyOqcZhrdJRE6uOwDMf#7DE3MpBBJMcD#ncElMhEluN0HqgOXxMAaFMxAeA$ny9EQ7mRozS96NkprlCd8hmwDQx0Nwu4Nyz#R2gaBmVpsOftmreSqW3I4D88qWM3lurNjRK5zh4ML7aEy6pHymjiVWdrywp#HTndIlaVyMWXylR9g2xxiXH$LnBhYXQzwCJUoqDVuFWYFW62#UgSYhJdIha0TsCoBkUnz7lRv1F8rKIk6T5KEypeUlbqPUTwx44RRhS2vykU8uteK3wai45PscO6yCo1zYQe0sukzRppsmLLw8eov4Vywyj1#5LmxlKiGnxwr2dpA2pzkWhKs7kjdA$XxAt2e0WvUh8tnyCMg63SlvaiyohQ2lrVjW3ZQZv#3CEQRzmlCS#HbdOMqVKX3VxsuNcI1HpnyiEfdYA$7tWJsoBeRQOUHXdGlTDPun8zWJLQs5sRipFgOPDRRUEExtlr8mpusoLnJijv6EDq$vfuKamwkIHZhhEyC3iQwJPp3byrrq5FJn7iw$0QyIiqEzd$CjIUW2knNiMOtGzxrfipd$dHwDR1SatE2wpgmv$lBDThY3oSVSfGnQtQzjGKvr7h6j95dwwRlsRhP65lN6OkriHbiq1euDsCjM8aunYmNVczXVkJ2losiCRcE$L7kgxQsbeRY7Kgm5fKtlBxrfzKpwqPziqxKFzlHvnO5CUWoKswGFus1TtAvm7BDiQ$YMECyPnRDApaRfvw5f5yMMRyycF$98$pncg$wmxNESfQ5dVSLhDzeL52PtGNBM5c1yVfZ2vPXwXg8EHlVGws51ijST#XrM#TYNnf$Gb2zqe5ngrPWl6dG$MMZDONm6nYSLXn1V#P7LYvtLc2yIU$0UFslRHq$8VAsQwwrTV8h1VCQbFA76xrfQtwje#vJWUNZfmJ5fmR5NoYaZU3xhR3tefY$RM27lTWl9XIUt#2Ie3Pt1CNNEiBh2yVWAU4u55wdbdd6bLp0FqBNYVy5yglXVPy$FNU1inpyU5J1kWtCzI1tdYbpNkXsSjS5nbbMgB85wtgnlul7jJIXmFsKuR7AKHRNpuGJ8UtjU5AUVH#VKE3PLEJjCsDNRvN2yrFCinksshJvH6IuAGMkFKYxqM0uhZT93GFB9DoldkVatz#ZpZX7taBm#1dwQXDV55YNdsdIpNrsBMRYonqSWlPi2Qi2uwKQEChkATY7skP#hPJZ6j48#wFQhI7OyvIQwoWxpD7FksmTNz$MSPUQzbSuoizmzAMElPzBn3ut2NlfHkR#B#43MpVkPVIsG7xUwqsvxGv#xOFxuS#hjT3M3SnzUSDaVrx29iDhjJyjiRP9yzrlcNgd6NsT8#q9VxZfRGOJUziwAVxqn3H$E5Fwmy7hIcBzm7YpxeNtfqLr1nxsfedOZoTY7vxz8coElMZSczYBOE#Sc0h17YstWstZHEpnSczJpn4WDH1U78YRkxDWM$nEUxyQToIO8r5fon#kSphYZcUKfHq#NMS01FlOqhlyQMMQEVAt8Jx4aMUUEJNwrP$cmVrPutB#U1FpVAcfsRyr6sniOtmd4#j88kurSjHpa#RgdWgw9GJtMudfIWBxsTWy1s$yUB0DYYDOGytz4x$PWRtF7svYdbscna6mTophzUULFTyVJiKzMzd9ZhozZZpptA#SUPQREjN4pVppJ4IQURvVRf4fyxEjomViyzmIehhc#JWtp#KinnfJzqIJvXXZvkXt#KiSPQyi1FiHKz$n7ANHAAJ3p#jYdnfNnPyUTxMZdaJyNN$Su$67qt1Vb8Ors7EX8t#Q8n$tY9xz$dZy6RQckqt#9CZ7I7SysutVuwZ$7TQ1DlvumWF#S3spZyz$XbclhQqJ6nYSav3MswGPFw$tW8axRE3DDlgA$BJ217M3xfcyPZriECVe7VwyHl6ESFl0UWbzWd3k28nRjsX5yeWy90$A0pgCUtcvJduXzydzyW$vEsA$oL$bB$9pkLgkqYKUWpmeX#CyJBGKOyNJHAA5Q2wQYNO8TO3WFbvqXc1EY8iXkBSNk3yMGo2uTnV3nUCuZq7TFF6462KU5O#8XyL3OgHuK3mWHeY9OeAOgTeIM2r5MJbQmdlaepgbgMWa6egwuYdn96AfucGnIwT$AChWZB2OBvQ9fMA9M2pcYRdYLvtxYy0rMlm4#K6yBB6UYZF4Gh50V23UjsqWPkk#LI7V8Q#JryfxvJq8uLvT3eNS9U#Kj#kysyGgWRimiK9qahLaJLyTf4bukNn3nxwMkodWa6lbce3ubtA3rklb6lcDt2CtwjWs#RVyIywIhylN47iLxPIMxykvehki8Ql9ghAoh8IqpP1Da8rYWrWFlLhq4Bt4fQAdk4GaYWGHBpmYJbZ8mRL5V2U#5b#9hGXjanM1MW5INfRJxNbb8iwMz4YiSfBB11aFpSGVudVncxREVh5Fz1LNYIl5jQA$w2Uk4LUR7fIHfOGKHumL3uj3Of0OB6uIDufRnUtYDZ5Kt2lk4NUB#tN#GV6N#5FNAosJ90aXooBrMmZsz#8RiLDi5xl43h55x16xnJgnLfVz27bhn1T1jdn7u3edFaFeLWXyIzuYSULIT$PoCEGc27OhSf0SAA#ND#WwRulFJUs5Of7uL7mYFjQyFX9BTUe2iKJh3yMNyXNvifmfPyZfyYKvJRueNv3Fo#VaLEG#0dbOFYJ7Y581ZAw2d031F93j8TWNorn8Zgz4MtrkB1l9XYPbdZxNr#Tw4bT$cIpJVENh69sYV3RVFsLjI6f0orVuGdqSgPSxmhY7abcG34Ywn5LLje0qbyrCFcmfbq7GVxbOVYe$WOPjv29fM#OpKKVKbjK5SCH98aDaYjOYIumNuyGBseBFGvw3m3vY2kHPo6Jn3CwJ16mXJXUlwNBlGDuMqtHuZfWbtX2lwl1xuaLn6dH7yQvuIxmfpa7uND4Dvul4XJXVBj0pSRt0E8gR1LOkSOV0NaVS9uO9h4XYj1mfiL#GJMKJdB7pbPcQTs$JlylqkPVF7fVgSqyJkqIVrLgL95B4MEXaWLs7m0YAKo5dGx2Z4HT0W2Ik4mD4Rt6#w2BE4gVO6AALE47K4ZL53L5TL1DLHHLHMLGI5KK5KLwKC#sCaDYNotuIiqTUOz9wwFD59dQXFbyWxpVnyum#Lx7IeVEDxYwyyag95K##RgyIEC#4pyxGeUUqpxwc$3NSaU#79dP5g79k7$dzyn$v$NEKEGnP0Vb0B9Ttc58lGNuKhujNeAUBRD5Mv8XSNVe##G3EMESbrddve$nUufeklvLxvG$OlnnXgSGWH7yIXp3wnY7BZ7nBbX7kaFmqYvKd3b4wZbK0NWMa$uLwVv7wrIJca#yG$mvbAwACNomjbP3$D$8F0Fk0rd6iCl8h8tmGUGUXVqBU3eIt8jrBwhTQ$78lUI1nj1Zb5gED92sCVaQTdu5V1NMg87mOQOUXTwBSJfJFbqD8knFwVgJVZp9ALY1j1U8hW0tDgcfXj1Uo4dahaVSomdxXGV6YvVq0uK7nekLLo3Zm60ez5FM78ZmMUYpqBz2$eD$LmBiQydz7sk$GHxHOMXOYhEGZbFq8yOzWz#eeNnrfGej57oFlOwtZ7DfZ99wLHldIA2krS5fhv4V4VqHvMnYzHWaG3tq0$PuM3oJUX9KaEhGIhqChIIfGRXxqFE3C0uuTLfBeq4gy3gqagK2vMU0x2pnVXtuT#WteDw3V1FPyo6pWpqPPMnADUEa7bFi1VTiClHdbDyCsVo3y1y9lmIwOP4heGyJVXhpZapXw5pvQXZn64cWVwWr7MIKt5n3B5xv92uTOh2mmoY8#67Y3KUP6w1kXzoEFesqZjDx8zqYtZDH0NWtKpzTn6Fiuf7iWyKXJKjCM#fNKhtvnT8Rb2mtIOh5QYDT2Nh8MYuQ0sn2jbSH1FAmSofH3lbzRaBXyJL#XpYujZ8P13qFTOSXFGVaKb4c0zekb9H7XKYYdFdzeYqMheLT3vq4xPMcGB4UP#w1jYOEeE7UaMNGRv5RatGez1MbJ49xY2pCT7W4z0lMcGK#3Vb0BCpeEOj7j24$LmeoEWrYq0U4Dw4TjBN4G1k7q0CefUTR8GreulGJz4lGMQ2KZjN2Q3ZqT#WxeekHXBHQDXnuFlHiwNnxHOj44w0dGNqChULIBHHEX9q9$2PqlexHOD0bw4hJwrFO2w8tGmRB7o6Wj5Zq3$Goq#kxX9z2Re9to6DBKxuiy1$qSzAVGwjShna2FWNuU#dde9MJ$mixZq8z3lm3z0lHdqEfNafw0VWBwHUWNeLT1gr$VUXBwIUZ9q9EXFuV#7FefBHv87CI2S9g9j9b8cucqcKYRYRGrI5k3jAUXdqQQhHdTZV1Tq11MnnQw1#NlGRej7fg1j1a8svhH5reisWPTN9cBUdEXNu5#1VetwD#WRmaXS$u7Ty$ww0==");
    private WorkingParseResult fWorking;
    private final List<IRecoveryStrategy> recoveryStrategies;
    private JSFlexScanner fScanner;

    private void attachPostDocumentationBlocks(JSParseRootNode root, String source) {
        block3: for (Symbol block : this.fScanner.getVSDocComments()) {
            int index = block.getStart() - 1;
            while (index >= 0 && Character.isWhitespace(source.charAt(index))) {
                --index;
            }
            IParseNode node = root.getNodeAtOffset(index);
            if (!(node instanceof JSNode)) continue;
            switch (node.getNodeType()) {
                case 21: {
                    IParseNode parent = node.getParent();
                    if (parent.getNodeType() != 70) continue block3;
                    ((JSNode)parent).setPostDocumentation(block);
                    break;
                }
                default: {
                    ((JSNode)node).setPostDocumentation(block);
                }
            }
        }
    }

    private void attachPreDocumentationBlocks(JSParseRootNode root, String source) {
        List<Symbol> sDocComments = this.fScanner.getSDocComments();
        for (Symbol comment : sDocComments) {
            int index = comment.getEnd() + 1;
            while (index < source.length() && Character.isWhitespace(source.charAt(index))) {
                ++index;
            }
            IParseNode node = root.getNodeAtOffset(index);
            if (!(node instanceof JSNode)) continue;
            if (node instanceof JSGroupNode && node.getFirstChild() instanceof JSFunctionNode) {
                ((JSNode)node.getFirstChild()).setPreDocumentation(comment);
                continue;
            }
            if (node instanceof JSIdentifierNode && node.getParent() instanceof JSNameValuePairNode) {
                JSNameValuePairNode entry = (JSNameValuePairNode)node.getParent();
                ((JSNode)entry.getValue()).setPreDocumentation(comment);
                continue;
            }
            IParseNode statement = ((JSNode)node).getContainingStatementNode();
            if (statement instanceof JSAssignmentNode) {
                ((JSNode)statement.getLastChild()).setPreDocumentation(comment);
                continue;
            }
            switch (node.getNodeType()) {
                case 64: {
                    JSVarNode varNode = (JSVarNode)node;
                    ((JSNode)varNode.getFirstChild().getLastChild()).setPreDocumentation(comment);
                    break;
                }
                default: {
                    ((JSNode)node).setPreDocumentation(comment);
                }
            }
        }
    }

    protected Symbol getLastSymbol() {
        Symbol result = null;
        if (this.top >= 0 && this.top < this._symbols.length) {
            result = this._symbols[this.top];
        }
        return result;
    }

    public synchronized ParseResult parse(IParseState parseState) throws Exception {
        WorkingParseResult working;
        block2: {
            working = new WorkingParseResult();
            try {
                this.parse(parseState, working);
            }
            catch (Exception e) {
                JSParseState state;
                if (!(parseState instanceof JSParseState) || !(state = (JSParseState)parseState).isNeedThrowException()) break block2;
                throw e;
            }
        }
        return working.getImmutableResult();
    }

    protected synchronized void parse(IParseState parseState, WorkingParseResult working) throws Exception {
        this.fWorking = working;
        String source = parseState.getSource();
        this.fScanner = new JSFlexScanner();
        this.fScanner.setSource(source);
        this.fScanner.setEnablejsx(true);
        boolean attachComments = true;
        boolean collectComments = true;
        if (parseState instanceof JSParseState) {
            JSParseState jsParseState = (JSParseState)parseState;
            attachComments = jsParseState.attachComments();
            collectComments = jsParseState.attachComments() || jsParseState.collectComments();
        }
        this.fScanner.setCollectComments(collectComments);
        try {
            JSParseRootNode result;
            try {
                result = (JSParseRootNode)((Object)this.parse(this.fScanner, parseState.getNeedSleep()));
                if (attachComments) {
                    this.attachComments(source, result);
                }
                if (collectComments) {
                    this.collectComments(result);
                }
            }
            finally {
                if (this.fScanner != null) {
                    this.fScanner.yyclose();
                    this.fScanner = null;
                }
            }
            int start = parseState.getStartingOffset();
            int length = source.length();
            result.setLocation(0, length - 1);
            if (start != 0) {
                ParseUtil.addOffset((IParseNode)result, (int)start, (boolean)parseState.getNeedSleep());
            }
            this.fWorking.setParseResult((IParseRootNode)result);
        }
        finally {
            this.fWorking = null;
        }
    }

    private void attachComments(String source, JSParseRootNode result) {
        this.attachPreDocumentationBlocks(result, source);
        this.attachPostDocumentationBlocks(result, source);
    }

    private void collectComments(JSParseRootNode result) {
        List<Symbol> sDocComments = this.fScanner.getSDocComments();
        List<Symbol> vsDocComments = this.fScanner.getVSDocComments();
        List<Symbol> singleLineComments = this.fScanner.getSingleLineComments();
        List<Symbol> multiLineComments = this.fScanner.getMultiLineComments();
        ArrayList<JSCommentNode> comments = new ArrayList<JSCommentNode>(sDocComments.size() + vsDocComments.size() + singleLineComments.size() + multiLineComments.size());
        for (Symbol symbol : sDocComments) {
            comments.add(new JSCommentNode(90, symbol.getStart(), symbol.getEnd()));
        }
        for (Symbol symbol : vsDocComments) {
            comments.add(new JSCommentNode(91, symbol.getStart(), symbol.getEnd()));
        }
        for (Symbol symbol : singleLineComments) {
            comments.add(new JSCommentNode(92, symbol.getStart(), symbol.getEnd()));
        }
        for (Symbol symbol : multiLineComments) {
            comments.add(new JSCommentNode(93, symbol.getStart(), symbol.getEnd()));
        }
        result.setCommentNodes(comments.toArray(new IParseNode[comments.size()]));
    }

    protected void recoverFromError(Symbol token, Parser.TokenStream in) throws IOException, Parser.Exception {
        boolean success = false;
        if (this.recoveryStrategies != null) {
            for (IRecoveryStrategy strategy : this.recoveryStrategies) {
                if (!strategy.recover((IParser)this, this.getLastSymbol(), token, in, this.report)) continue;
                success = true;
                break;
            }
        }
        if (!success) {
            super.recoverFromError(token, in);
        }
    }

    public JSParser() {
        super(PARSING_TABLES);
        this.report = new JSEvents();
        this.recoveryStrategies = new ArrayList<IRecoveryStrategy>();
        this.recoveryStrategies.add((IRecoveryStrategy)new JSInsertionRecoveryStrategy(JSTokenType.SEMICOLON, ";", new JSTokenType[0]));
        this.recoveryStrategies.add((IRecoveryStrategy)new JSInsertionRecoveryStrategy(JSTokenType.RPAREN, ")", JSTokenType.SEMICOLON, ";", new JSTokenType[0]));
        this.recoveryStrategies.add((IRecoveryStrategy)new JSInsertionRecoveryStrategy(JSTokenType.IDENTIFIER, "", JSTokenType.SEMICOLON, ";", JSTokenType.DOT, JSTokenType.NEW, JSTokenType.EQUAL));
        this.recoveryStrategies.add((IRecoveryStrategy)new JSInsertionRecoveryStrategy(JSTokenType.IDENTIFIER, "", JSTokenType.DOT, JSTokenType.NEW, JSTokenType.EQUAL));
        this.recoveryStrategies.add((IRecoveryStrategy)new JSInsertionRecoveryStrategy(JSTokenType.IDENTIFIER, "", JSTokenType.LPAREN));
        this.recoveryStrategies.add((IRecoveryStrategy)new JSInsertionRecoveryStrategy(JSTokenType.IDENTIFIER, "", JSTokenType.COLON, ":", JSTokenType.DOT));
        this.recoveryStrategies.add((IRecoveryStrategy)new JSInsertionRecoveryStrategy(JSTokenType.LCURLY, "{", JSTokenType.RCURLY, "}", JSTokenType.RPAREN));
        this.recoveryStrategies.add(new IRecoveryStrategy(){

            public boolean recover(IParser parser, Symbol lastToken, Symbol currentToken, Parser.TokenStream in, Parser.Events report) throws IOException {
                boolean result = false;
                if (JSParser.this.top >= 3 && JSParser.this._symbols[1].getId() == JSTokenType.CLASS.getIndex() && lastToken instanceof JSIdentifierNode) {
                    int offset = currentToken.getStart();
                    Parser.Simulator sim = new Parser.Simulator((Parser)JSParser.this);
                    in.alloc(5);
                    in.insert(currentToken);
                    in.insert(new Symbol(JSTokenType.LCURLY.getIndex(), offset, offset - 1, (Object)"{"), new Symbol(JSTokenType.RCURLY.getIndex(), offset, offset - 1, (Object)"}"));
                    in.insert(new Symbol(JSTokenType.LPAREN.getIndex(), offset, offset - 1, (Object)"("), new Symbol(JSTokenType.RPAREN.getIndex(), offset, offset - 1, (Object)")"));
                    in.rewind();
                    if (sim.parse(in)) {
                        result = true;
                        in.rewind();
                    }
                }
                return result;
            }
        });
        this.recoveryStrategies.add(new IRecoveryStrategy(){

            public boolean recover(IParser parser, Symbol lastToken, Symbol currentToken, Parser.TokenStream in, Parser.Events report) throws IOException {
                boolean result = false;
                if (JSParser.this.top >= 2) {
                    Symbol symbol1 = JSParser.this._symbols[JSParser.this.top - 2];
                    Symbol symbol2 = JSParser.this._symbols[JSParser.this.top - 1];
                    if (lastToken.getId() == JSTokenType.COMMA.getIndex() && symbol2.value instanceof List && symbol1.getId() == JSTokenType.LPAREN.getIndex()) {
                        Symbol term = new Symbol(JSTokenType.IDENTIFIER.getIndex(), currentToken.getStart(), currentToken.getStart() - 1, (Object)"");
                        Parser.Simulator sim = new Parser.Simulator((Parser)JSParser.this);
                        in.alloc(2);
                        in.insert(term, currentToken);
                        in.rewind();
                        if (sim.parse(in)) {
                            result = true;
                            in.rewind();
                            report.missingTokenInserted(term);
                        }
                    }
                }
                return result;
            }
        });
        JSInsertionRecoveryStrategy completeProperty = new JSInsertionRecoveryStrategy(JSTokenType.IDENTIFIER, "", new JSTokenType[0]);
        completeProperty.addCurrentTokenTypes(new JSTokenType[]{JSTokenType.RCURLY});
        this.recoveryStrategies.add((IRecoveryStrategy)completeProperty);
        JSInsertionRecoveryStrategy completeProperty2 = new JSInsertionRecoveryStrategy(JSTokenType.COLON, ":", JSTokenType.IDENTIFIER, "", new JSTokenType[0]);
        completeProperty2.addCurrentTokenTypes(new JSTokenType[]{JSTokenType.RCURLY});
        this.recoveryStrategies.add((IRecoveryStrategy)completeProperty2);
    }

    protected Symbol invokeReduceAction(int rule_num, int offset) {
        switch (rule_num) {
            case 0: {
                Symbol _symbol_p = this._symbols[offset + 1];
                ArrayList _list_p = (ArrayList)_symbol_p.value;
                JSNode[] p = _list_p == null ? new JSNode[]{} : _list_p.toArray(new JSNode[_list_p.size()]);
                return new JSParseRootNode((Symbol[])p);
            }
            case 1: {
                return new JSParseRootNode();
            }
            case 2: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 3: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 9: {
                Symbol s = this._symbols[offset + 2];
                Symbol _symbol_from = this._symbols[offset + 3];
                JSNode from = (JSNode)((Object)_symbol_from.value);
                JSExportAllClauseNode node = new JSExportAllClauseNode(s);
                return new JSExportDeclarationNode(node, from);
            }
            case 10: {
                Symbol _symbol_ec = this._symbols[offset + 2];
                JSNode ec = (JSNode)((Object)_symbol_ec.value);
                Symbol _symbol_fc = this._symbols[offset + 3];
                JSNode fc = (JSNode)((Object)_symbol_fc.value);
                return new JSExportDeclarationNode(ec, fc);
            }
            case 11: {
                Symbol _symbol_ec = this._symbols[offset + 2];
                JSNode ec = (JSNode)((Object)_symbol_ec.value);
                return new JSExportDeclarationNode(ec, (JSNode)new JSEmptyNode(ec.getEnd()));
            }
            case 12: {
                Symbol _symbol_v = this._symbols[offset + 2];
                JSNode v = (JSNode)((Object)_symbol_v.value);
                return new JSExportDeclarationNode(v, (JSNode)new JSEmptyNode(v.getEnd()));
            }
            case 13: {
                Symbol _symbol_d = this._symbols[offset + 2];
                JSNode d = (JSNode)((Object)_symbol_d.value);
                return new JSExportDeclarationNode(d, (JSNode)new JSEmptyNode(d.getEnd()));
            }
            case 14: {
                Symbol _symbol_d = this._symbols[offset + 3];
                JSNode d = (JSNode)((Object)_symbol_d.value);
                JSExportDeclarationNode node = new JSExportDeclarationNode(d, (JSNode)new JSEmptyNode(d.getEnd()));
                node.setDefault(true);
                return node;
            }
            case 15: {
                Symbol _symbol_v = this._symbols[offset + 3];
                JSNode v = (JSNode)((Object)_symbol_v.value);
                JSExportDeclarationNode node = new JSExportDeclarationNode(v, (JSNode)new JSEmptyNode(v.getEnd()));
                node.setDefault(true);
                return node;
            }
            case 16: {
                Symbol _symbol_ident = this._symbols[offset + 3];
                JSNode ident = (JSNode)((Object)_symbol_ident.value);
                JSExportDeclarationNode node = new JSExportDeclarationNode(ident, (JSNode)new JSEmptyNode(ident.getEnd()));
                node.setDefault(true);
                return node;
            }
            case 17: {
                return new JSExportClauseNode();
            }
            case 18: {
                Symbol _symbol_list = this._symbols[offset + 2];
                JSNode list = (JSNode)((Object)_symbol_list.value);
                return new JSExportClauseNode(list);
            }
            case 19: {
                Symbol _symbol_list = this._symbols[offset + 2];
                JSNode list = (JSNode)((Object)_symbol_list.value);
                return new JSExportClauseNode(list);
            }
            case 20: {
                Symbol _symbol_spec = this._symbols[offset + 1];
                JSNode spec = (JSNode)((Object)_symbol_spec.value);
                return new JSExportsListNode(spec);
            }
            case 21: {
                Symbol _symbol_list = this._symbols[offset + 1];
                JSNode list = (JSNode)((Object)_symbol_list.value);
                Symbol _symbol_spec = this._symbols[offset + 3];
                JSNode spec = (JSNode)((Object)_symbol_spec.value);
                list.addChild((IParseNode)spec);
                return list;
            }
            case 22: {
                Symbol ident = this._symbols[offset + 1];
                JSIdentifierNode child = new JSIdentifierNode(ident);
                return new JSExportSpecifierNode(child);
            }
            case 23: {
                Symbol ident1 = this._symbols[offset + 1];
                Symbol as = this._symbols[offset + 2];
                Symbol ident2 = this._symbols[offset + 3];
                JSIdentifierNode child1 = new JSIdentifierNode(ident1);
                JSIdentifierNode child2 = new JSIdentifierNode(ident2);
                return new JSExportSpecifierNode(child1, as, (JSNode)child2);
            }
            case 27: {
                Symbol i = this._symbols[offset + 1];
                Symbol _symbol_ic = this._symbols[offset + 2];
                JSNode ic = (JSNode)((Object)_symbol_ic.value);
                Symbol _symbol_fc = this._symbols[offset + 3];
                JSNode fc = (JSNode)((Object)_symbol_fc.value);
                return new JSImportDeclarationNode(i, ic, fc);
            }
            case 28: {
                Symbol i = this._symbols[offset + 1];
                Symbol _symbol_spec = this._symbols[offset + 2];
                JSNode spec = (JSNode)((Object)_symbol_spec.value);
                return new JSImportDeclarationNode(i, spec);
            }
            case 29: {
                Symbol _symbol_bind = this._symbols[offset + 1];
                JSNode bind = (JSNode)((Object)_symbol_bind.value);
                return new JSImportClauseNode(bind);
            }
            case 30: {
                Symbol _symbol_ns = this._symbols[offset + 1];
                JSNode ns = (JSNode)((Object)_symbol_ns.value);
                return new JSImportClauseNode(ns);
            }
            case 31: {
                Symbol _symbol_names = this._symbols[offset + 1];
                JSNode names = (JSNode)((Object)_symbol_names.value);
                return new JSImportClauseNode(names);
            }
            case 32: {
                Symbol _symbol_bind = this._symbols[offset + 1];
                JSNode bind = (JSNode)((Object)_symbol_bind.value);
                Symbol _symbol_ns = this._symbols[offset + 3];
                JSNode ns = (JSNode)((Object)_symbol_ns.value);
                return new JSImportClauseNode(bind, ns);
            }
            case 33: {
                Symbol _symbol_bind = this._symbols[offset + 1];
                JSNode bind = (JSNode)((Object)_symbol_bind.value);
                Symbol _symbol_names = this._symbols[offset + 3];
                JSNode names = (JSNode)((Object)_symbol_names.value);
                return new JSImportClauseNode(bind, names);
            }
            case 35: {
                Symbol s = this._symbols[offset + 1];
                Symbol as = this._symbols[offset + 2];
                Symbol _symbol_bind = this._symbols[offset + 3];
                JSNode bind = (JSNode)((Object)_symbol_bind.value);
                return new JSNameSpaceImportNode(s, as, bind);
            }
            case 36: {
                return new JSNamedImportsNode();
            }
            case 37: {
                Symbol _symbol_list = this._symbols[offset + 2];
                JSNode list = (JSNode)((Object)_symbol_list.value);
                return new JSNamedImportsNode(list);
            }
            case 38: {
                Symbol _symbol_list = this._symbols[offset + 2];
                JSNode list = (JSNode)((Object)_symbol_list.value);
                return new JSNamedImportsNode(list);
            }
            case 39: {
                Symbol _symbol_spec = this._symbols[offset + 1];
                JSNode spec = (JSNode)((Object)_symbol_spec.value);
                return new JSImportSpecifierListNode(spec);
            }
            case 40: {
                Symbol _symbol_list = this._symbols[offset + 1];
                JSNode list = (JSNode)((Object)_symbol_list.value);
                Symbol _symbol_spec = this._symbols[offset + 3];
                JSNode spec = (JSNode)((Object)_symbol_spec.value);
                list.addChild((IParseNode)spec);
                return list;
            }
            case 41: {
                Symbol _symbol_bind = this._symbols[offset + 1];
                JSNode bind = (JSNode)((Object)_symbol_bind.value);
                return new JSImportSpecifierNode(bind);
            }
            case 42: {
                Symbol ident = this._symbols[offset + 1];
                Symbol as = this._symbols[offset + 2];
                Symbol _symbol_bind = this._symbols[offset + 3];
                JSNode bind = (JSNode)((Object)_symbol_bind.value);
                JSIdentifierNode child = new JSIdentifierNode(ident);
                return new JSImportSpecifierNode(bind, as, (JSNode)child);
            }
            case 43: {
                Symbol _symbol_spec = this._symbols[offset + 2];
                JSNode spec = (JSNode)((Object)_symbol_spec.value);
                return new JSFromClauseNode(spec);
            }
            case 45: {
                Symbol ident = this._symbols[offset + 1];
                return new JSIdentifierNode(ident);
            }
            case 46: {
                Symbol s = this._symbols[offset + 1];
                return new JSStringNode(s);
            }
            case 50: {
                Symbol ident = this._symbols[offset + 3];
                Symbol _symbol_params = this._symbols[offset + 4];
                JSNode params = (JSNode)((Object)_symbol_params.value);
                Symbol _symbol_body = this._symbols[offset + 5];
                JSNode body = (JSNode)((Object)_symbol_body.value);
                return new JSGeneratorFunctionNode(new JSIdentifierNode(ident), params, body);
            }
            case 51: {
                Symbol f = this._symbols[offset + 1];
                Symbol _symbol_params = this._symbols[offset + 3];
                JSNode params = (JSNode)((Object)_symbol_params.value);
                Symbol _symbol_body = this._symbols[offset + 4];
                JSNode body = (JSNode)((Object)_symbol_body.value);
                return new JSGeneratorFunctionNode(new JSEmptyNode(f), params, body);
            }
            case 52: {
                Symbol ident = this._symbols[offset + 2];
                Symbol _symbol_tail = this._symbols[offset + 3];
                JSNode tail = (JSNode)((Object)_symbol_tail.value);
                return new JSClassNode(new JSIdentifierNode(ident), tail);
            }
            case 53: {
                Symbol c = this._symbols[offset + 1];
                Symbol _symbol_tail = this._symbols[offset + 2];
                JSNode tail = (JSNode)((Object)_symbol_tail.value);
                return new JSClassNode(new JSEmptyNode(c), tail);
            }
            case 54: {
                Symbol _symbol_heri = this._symbols[offset + 1];
                JSNode heri = (JSNode)((Object)_symbol_heri.value);
                Symbol _symbol_body = this._symbols[offset + 2];
                JSNode body = (JSNode)((Object)_symbol_body.value);
                return new JSClassTailNode(body, heri);
            }
            case 55: {
                Symbol _symbol_body = this._symbols[offset + 1];
                JSNode body = (JSNode)((Object)_symbol_body.value);
                return new JSClassTailNode(body);
            }
            case 56: {
                return new JSClassBodyNode(new JSNode[0]);
            }
            case 57: {
                Symbol _symbol_list = this._symbols[offset + 2];
                ArrayList _list_list = (ArrayList)_symbol_list.value;
                JSNode[] list = _list_list == null ? new JSNode[]{} : _list_list.toArray(new JSNode[_list_list.size()]);
                return new JSClassBodyNode(list);
            }
            case 58: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 59: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 61: {
                Symbol _symbol_m = this._symbols[offset + 2];
                JSMethodNode m = (JSMethodNode)((Object)_symbol_m.value);
                m.setStatic(true);
                return m;
            }
            case 62: {
                Symbol _symbol_ident = this._symbols[offset + 1];
                JSNode ident = (JSNode)((Object)_symbol_ident.value);
                Symbol _symbol_params = this._symbols[offset + 2];
                JSNode params = (JSNode)((Object)_symbol_params.value);
                Symbol _symbol_body = this._symbols[offset + 3];
                JSNode body = (JSNode)((Object)_symbol_body.value);
                return new JSMethodNode(ident, params, body);
            }
            case 63: {
                Symbol _symbol_ident = this._symbols[offset + 2];
                JSNode ident = (JSNode)((Object)_symbol_ident.value);
                Symbol _symbol_params = this._symbols[offset + 3];
                JSNode params = (JSNode)((Object)_symbol_params.value);
                Symbol _symbol_body = this._symbols[offset + 4];
                JSNode body = (JSNode)((Object)_symbol_body.value);
                return new JSGeneratorMethodNode(ident, params, body);
            }
            case 64: {
                Symbol _symbol_ident = this._symbols[offset + 2];
                JSNode ident = (JSNode)((Object)_symbol_ident.value);
                Symbol _symbol_params = this._symbols[offset + 3];
                JSNode params = (JSNode)((Object)_symbol_params.value);
                Symbol _symbol_body = this._symbols[offset + 4];
                JSNode body = (JSNode)((Object)_symbol_body.value);
                return new JSGetMethodNode(ident, params, body);
            }
            case 65: {
                Symbol _symbol_ident = this._symbols[offset + 2];
                JSNode ident = (JSNode)((Object)_symbol_ident.value);
                Symbol _symbol_params = this._symbols[offset + 3];
                JSNode params = (JSNode)((Object)_symbol_params.value);
                Symbol _symbol_body = this._symbols[offset + 4];
                JSNode body = (JSNode)((Object)_symbol_body.value);
                return new JSSetMethodNode(ident, params, body);
            }
            case 66: {
                Symbol ex = this._symbols[offset + 1];
                Symbol _symbol_lhs = this._symbols[offset + 2];
                JSNode lhs = (JSNode)((Object)_symbol_lhs.value);
                return new JSClassExtendsNode(ex, lhs);
            }
            case 67: {
                Symbol ident = this._symbols[offset + 2];
                Symbol _symbol_params = this._symbols[offset + 3];
                JSNode params = (JSNode)((Object)_symbol_params.value);
                Symbol _symbol_body = this._symbols[offset + 4];
                JSNode body = (JSNode)((Object)_symbol_body.value);
                return new JSFunctionNode(new JSIdentifierNode(ident), params, body);
            }
            case 68: {
                Symbol f = this._symbols[offset + 1];
                Symbol _symbol_params = this._symbols[offset + 2];
                JSNode params = (JSNode)((Object)_symbol_params.value);
                Symbol _symbol_body = this._symbols[offset + 3];
                JSNode body = (JSNode)((Object)_symbol_body.value);
                return new JSFunctionNode(new JSEmptyNode(f), params, body);
            }
            case 71: {
                return new JSParametersNode(new JSNode[0]);
            }
            case 72: {
                Symbol _symbol_params = this._symbols[offset + 2];
                JSNode params = (JSNode)((Object)_symbol_params.value);
                return params;
            }
            case 73: {
                Symbol _symbol_params = this._symbols[offset + 2];
                JSNode params = (JSNode)((Object)_symbol_params.value);
                Symbol _symbol_rest = this._symbols[offset + 4];
                JSNode rest = (JSNode)((Object)_symbol_rest.value);
                params.addChild((IParseNode)rest);
                return params;
            }
            case 74: {
                Symbol _symbol_rest = this._symbols[offset + 2];
                JSNode rest = (JSNode)((Object)_symbol_rest.value);
                return new JSParametersNode(rest);
            }
            case 75: {
                Symbol _symbol_list = this._symbols[offset + 1];
                JSNode list = (JSNode)((Object)_symbol_list.value);
                Symbol _symbol_param = this._symbols[offset + 3];
                JSNode param = (JSNode)((Object)_symbol_param.value);
                list.addChild((IParseNode)param);
                return list;
            }
            case 76: {
                Symbol _symbol_param = this._symbols[offset + 1];
                JSNode param = (JSNode)((Object)_symbol_param.value);
                return new JSParametersNode(param);
            }
            case 78: {
                return new JSStatementsNode(new JSNode[0]);
            }
            case 79: {
                Symbol _symbol_s = this._symbols[offset + 2];
                ArrayList _list_s = (ArrayList)_symbol_s.value;
                JSNode[] s = _list_s == null ? new JSNode[]{} : _list_s.toArray(new JSNode[_list_s.size()]);
                return new JSStatementsNode(s);
            }
            case 83: {
                Symbol _symbol_e = this._symbols[offset + 1];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                e.setSemicolonIncluded(true);
                return e;
            }
            case 95: {
                return new JSErrorNode();
            }
            case 99: {
                Symbol _symbol_e = this._symbols[offset + 1];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                e.setSemicolonIncluded(true);
                return e;
            }
            case 111: {
                return new JSErrorNode();
            }
            case 112: {
                Symbol s = this._symbols[offset + 1];
                JSEmptyNode node = new JSEmptyNode(s);
                ((JSNode)node).setSemicolonIncluded(true);
                return node;
            }
            case 113: {
                Symbol v = this._symbols[offset + 1];
                Symbol _symbol_l = this._symbols[offset + 2];
                ArrayList _list_l = (ArrayList)_symbol_l.value;
                JSNode[] l = _list_l == null ? new JSNode[]{} : _list_l.toArray(new JSNode[_list_l.size()]);
                Symbol s = this._symbols[offset + 3];
                JSVarNode node = new JSVarNode(v, l);
                node.setSemicolonIncluded(s.getEnd() >= s.getStart());
                return node;
            }
            case 114: {
                return new JSYieldNode();
            }
            case 115: {
                Symbol _symbol_assin = this._symbols[offset + 2];
                JSNode assin = (JSNode)((Object)_symbol_assin.value);
                return new JSYieldNode(assin);
            }
            case 116: {
                Symbol _symbol_assin = this._symbols[offset + 3];
                JSNode assin = (JSNode)((Object)_symbol_assin.value);
                return new JSYieldNode(assin, true);
            }
            case 117: {
                return new JSStatementsNode(new JSNode[0]);
            }
            case 118: {
                Symbol _symbol_a = this._symbols[offset + 2];
                ArrayList _list_a = (ArrayList)_symbol_a.value;
                JSNode[] a = _list_a == null ? new JSNode[]{} : _list_a.toArray(new JSNode[_list_a.size()]);
                return new JSStatementsNode(a);
            }
            case 119: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 120: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 121: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 3].value);
                return this._symbols[offset + 1];
            }
            case 122: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 123: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 3].value);
                return this._symbols[offset + 1];
            }
            case 124: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 125: {
                Symbol i = this._symbols[offset + 1];
                return new JSDeclarationNode(new JSIdentifierNode(i), null, (JSNode)new JSEmptyNode(i));
            }
            case 126: {
                Symbol i = this._symbols[offset + 1];
                Symbol e = this._symbols[offset + 2];
                Symbol _symbol_expression = this._symbols[offset + 3];
                JSNode expression = (JSNode)((Object)_symbol_expression.value);
                return new JSDeclarationNode(new JSIdentifierNode(i), e, expression);
            }
            case 127: {
                Symbol _symbol_bind = this._symbols[offset + 1];
                JSNode bind = (JSNode)((Object)_symbol_bind.value);
                Symbol e = this._symbols[offset + 2];
                Symbol _symbol_expression = this._symbols[offset + 3];
                JSNode expression = (JSNode)((Object)_symbol_expression.value);
                return new JSDeclarationNode(bind, e, expression);
            }
            case 130: {
                return new JSObjectPatternNode();
            }
            case 131: {
                Symbol _symbol_list = this._symbols[offset + 2];
                ArrayList _list_list = (ArrayList)_symbol_list.value;
                JSNode[] list = _list_list == null ? new JSNode[]{} : _list_list.toArray(new JSNode[_list_list.size()]);
                return new JSObjectPatternNode(list);
            }
            case 132: {
                Symbol _symbol_list = this._symbols[offset + 2];
                ArrayList _list_list = (ArrayList)_symbol_list.value;
                JSNode[] list = _list_list == null ? new JSNode[]{} : _list_list.toArray(new JSNode[_list_list.size()]);
                return new JSObjectPatternNode(list);
            }
            case 133: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 3].value);
                return this._symbols[offset + 1];
            }
            case 134: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 135: {
                Symbol _symbol_s = this._symbols[offset + 1];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSBindingPropertyValueNode(s);
            }
            case 136: {
                Symbol _symbol_n = this._symbols[offset + 1];
                JSNode n = (JSNode)((Object)_symbol_n.value);
                Symbol c = this._symbols[offset + 2];
                Symbol _symbol_v = this._symbols[offset + 3];
                JSNode v = (JSNode)((Object)_symbol_v.value);
                return new JSBindingPropertyValueNode(new JSNameValuePairNode(n, c, v));
            }
            case 137: {
                return new JSArrayPatternNode(new JSNode[0]);
            }
            case 138: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                return new JSArrayPatternNode(e);
            }
            case 139: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol _symbol_rest = this._symbols[offset + 3];
                JSNode rest = (JSNode)((Object)_symbol_rest.value);
                return new JSArrayPatternNode(e, rest);
            }
            case 140: {
                Symbol _symbol_list = this._symbols[offset + 2];
                ArrayList _list_list = (ArrayList)_symbol_list.value;
                JSNode[] list = _list_list == null ? new JSNode[]{} : _list_list.toArray(new JSNode[_list_list.size()]);
                return new JSArrayPatternNode(list);
            }
            case 141: {
                Symbol _symbol_list = this._symbols[offset + 2];
                ArrayList _list_list = (ArrayList)_symbol_list.value;
                JSNode[] list = _list_list == null ? new JSNode[]{} : _list_list.toArray(new JSNode[_list_list.size()]);
                return new JSArrayPatternNode(list);
            }
            case 142: {
                Symbol _symbol_list = this._symbols[offset + 2];
                ArrayList _list_list = (ArrayList)_symbol_list.value;
                JSNode[] list = _list_list == null ? new JSNode[]{} : _list_list.toArray(new JSNode[_list_list.size()]);
                Symbol _symbol_rest = this._symbols[offset + 4];
                JSNode rest = (JSNode)((Object)_symbol_rest.value);
                JSArrayPatternNode node = new JSArrayPatternNode(list);
                node.addChild((IParseNode)rest);
                return node;
            }
            case 143: {
                Symbol _symbol_list = this._symbols[offset + 2];
                ArrayList _list_list = (ArrayList)_symbol_list.value;
                JSNode[] list = _list_list == null ? new JSNode[]{} : _list_list.toArray(new JSNode[_list_list.size()]);
                Symbol _symbol_e = this._symbols[offset + 4];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                JSArrayPatternNode node = new JSArrayPatternNode(list);
                node.addChild((IParseNode)e);
                return node;
            }
            case 144: {
                Symbol _symbol_list = this._symbols[offset + 2];
                ArrayList _list_list = (ArrayList)_symbol_list.value;
                JSNode[] list = _list_list == null ? new JSNode[]{} : _list_list.toArray(new JSNode[_list_list.size()]);
                Symbol _symbol_e = this._symbols[offset + 4];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol _symbol_rest = this._symbols[offset + 5];
                JSNode rest = (JSNode)((Object)_symbol_rest.value);
                JSArrayPatternNode node = new JSArrayPatternNode(list);
                node.addChild((IParseNode)e);
                node.addChild((IParseNode)rest);
                return node;
            }
            case 145: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 3].value);
                return this._symbols[offset + 1];
            }
            case 146: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 149: {
                Symbol r = this._symbols[offset + 2];
                JSIdentifierNode identifier = new JSIdentifierNode(r);
                return new JSRestElementNode(identifier);
            }
            case 150: {
                Symbol _symbol_o = this._symbols[offset + 2];
                JSNode o = (JSNode)((Object)_symbol_o.value);
                return new JSRestElementNode(o);
            }
            case 151: {
                Symbol i = this._symbols[offset + 1];
                return new JSDeclarationNode(new JSIdentifierNode(i), null, (JSNode)new JSEmptyNode(i));
            }
            case 152: {
                Symbol i = this._symbols[offset + 1];
                Symbol e = this._symbols[offset + 2];
                Symbol _symbol_expression = this._symbols[offset + 3];
                JSNode expression = (JSNode)((Object)_symbol_expression.value);
                return new JSDeclarationNode(new JSIdentifierNode(i), e, expression);
            }
            case 153: {
                Symbol _symbol_p = this._symbols[offset + 1];
                JSNode p = (JSNode)((Object)_symbol_p.value);
                Symbol e = this._symbols[offset + 2];
                Symbol _symbol_expression = this._symbols[offset + 3];
                JSNode expression = (JSNode)((Object)_symbol_expression.value);
                return new JSDeclarationNode(p, e, expression);
            }
            case 154: {
                Symbol _symbol_p = this._symbols[offset + 1];
                JSNode p = (JSNode)((Object)_symbol_p.value);
                return new JSDeclarationNode(p, null, (JSNode)new JSEmptyNode(p.getEnd()));
            }
            case 155: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 4];
                Symbol _symbol_sn = this._symbols[offset + 5];
                JSNode sn = (JSNode)((Object)_symbol_sn.value);
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSIfNode(l, e, r, sn, s);
            }
            case 156: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 4];
                Symbol _symbol_s = this._symbols[offset + 5];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSIfNode(l, e, r, s, (JSNode)new JSEmptyNode((Symbol)s));
            }
            case 157: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 4];
                Symbol _symbol_sn = this._symbols[offset + 5];
                JSNode sn = (JSNode)((Object)_symbol_sn.value);
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSIfNode(l, e, r, sn, s);
            }
            case 158: {
                Symbol _symbol_s = this._symbols[offset + 2];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                Symbol l = this._symbols[offset + 4];
                Symbol _symbol_e = this._symbols[offset + 5];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 6];
                JSDoNode node = new JSDoNode(s, l, e, r);
                node.setSemicolonIncluded(true);
                return node;
            }
            case 159: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 4];
                Symbol _symbol_s = this._symbols[offset + 5];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSWhileNode(l, e, r, s);
            }
            case 160: {
                Symbol l = this._symbols[offset + 2];
                Symbol s1 = this._symbols[offset + 3];
                Symbol s2 = this._symbols[offset + 4];
                Symbol r = this._symbols[offset + 5];
                Symbol _symbol_s = this._symbols[offset + 6];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSEmptyNode(l), s1, (JSNode)new JSEmptyNode(s1), s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 161: {
                Symbol l = this._symbols[offset + 2];
                Symbol s1 = this._symbols[offset + 3];
                Symbol s2 = this._symbols[offset + 4];
                Symbol _symbol_a = this._symbols[offset + 5];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSEmptyNode(l), s1, (JSNode)new JSEmptyNode(s1), s2, a, r, s);
            }
            case 162: {
                Symbol l = this._symbols[offset + 2];
                Symbol s1 = this._symbols[offset + 3];
                Symbol _symbol_c = this._symbols[offset + 4];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 5];
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSEmptyNode(l), s1, c, s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 163: {
                Symbol l = this._symbols[offset + 2];
                Symbol s1 = this._symbols[offset + 3];
                Symbol _symbol_c = this._symbols[offset + 4];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 5];
                Symbol _symbol_a = this._symbols[offset + 6];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSEmptyNode(l), s1, c, s2, a, r, s);
            }
            case 164: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol s1 = this._symbols[offset + 4];
                Symbol s2 = this._symbols[offset + 5];
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, i, s1, (JSNode)new JSEmptyNode(s1), s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 165: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol s1 = this._symbols[offset + 4];
                Symbol s2 = this._symbols[offset + 5];
                Symbol _symbol_a = this._symbols[offset + 6];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, i, s1, (JSNode)new JSEmptyNode(s1), s2, a, r, s);
            }
            case 166: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol s1 = this._symbols[offset + 4];
                Symbol _symbol_c = this._symbols[offset + 5];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 6];
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, i, s1, c, s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 167: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol s1 = this._symbols[offset + 4];
                Symbol _symbol_c = this._symbols[offset + 5];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 6];
                Symbol _symbol_a = this._symbols[offset + 7];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 8];
                Symbol _symbol_s = this._symbols[offset + 9];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, i, s1, c, s2, a, r, s);
            }
            case 168: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                ArrayList _list_i = (ArrayList)_symbol_i.value;
                JSNode[] i = _list_i == null ? new JSNode[]{} : _list_i.toArray(new JSNode[_list_i.size()]);
                Symbol s1 = this._symbols[offset + 5];
                Symbol s2 = this._symbols[offset + 6];
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSVarNode(v, i), s1, (JSNode)new JSEmptyNode(s1), s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 169: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                ArrayList _list_i = (ArrayList)_symbol_i.value;
                JSNode[] i = _list_i == null ? new JSNode[]{} : _list_i.toArray(new JSNode[_list_i.size()]);
                Symbol s1 = this._symbols[offset + 5];
                Symbol s2 = this._symbols[offset + 6];
                Symbol _symbol_a = this._symbols[offset + 7];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 8];
                Symbol _symbol_s = this._symbols[offset + 9];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSVarNode(v, i), s1, (JSNode)new JSEmptyNode(s1), s2, a, r, s);
            }
            case 170: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                ArrayList _list_i = (ArrayList)_symbol_i.value;
                JSNode[] i = _list_i == null ? new JSNode[]{} : _list_i.toArray(new JSNode[_list_i.size()]);
                Symbol s1 = this._symbols[offset + 5];
                Symbol _symbol_c = this._symbols[offset + 6];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 7];
                Symbol r = this._symbols[offset + 8];
                Symbol _symbol_s = this._symbols[offset + 9];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSVarNode(v, i), s1, c, s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 171: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                ArrayList _list_i = (ArrayList)_symbol_i.value;
                JSNode[] i = _list_i == null ? new JSNode[]{} : _list_i.toArray(new JSNode[_list_i.size()]);
                Symbol s1 = this._symbols[offset + 5];
                Symbol _symbol_c = this._symbols[offset + 6];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 7];
                Symbol _symbol_a = this._symbols[offset + 8];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 9];
                Symbol _symbol_s = this._symbols[offset + 10];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSVarNode(v, i), s1, c, s2, a, r, s);
            }
            case 172: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol in = this._symbols[offset + 4];
                Symbol _symbol_o = this._symbols[offset + 5];
                JSNode o = (JSNode)((Object)_symbol_o.value);
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForInNode(l, i, in, o, r, s);
            }
            case 173: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol in = this._symbols[offset + 5];
                Symbol _symbol_o = this._symbols[offset + 6];
                JSNode o = (JSNode)((Object)_symbol_o.value);
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForInNode(l, (JSNode)new JSVarNode(v, i), in, o, r, s);
            }
            case 174: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol in = this._symbols[offset + 4];
                Symbol _symbol_o = this._symbols[offset + 5];
                JSNode o = (JSNode)((Object)_symbol_o.value);
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForOfNode(l, i, in, o, r, s);
            }
            case 175: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol in = this._symbols[offset + 5];
                Symbol _symbol_o = this._symbols[offset + 6];
                JSNode o = (JSNode)((Object)_symbol_o.value);
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForOfNode(l, (JSNode)new JSVarNode(v, i), in, o, r, s);
            }
            case 176: {
                Symbol _symbol_s = this._symbols[offset + 2];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                Symbol l = this._symbols[offset + 4];
                Symbol _symbol_e = this._symbols[offset + 5];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 6];
                JSDoNode node = new JSDoNode(s, l, e, r);
                node.setSemicolonIncluded(true);
                return node;
            }
            case 177: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 4];
                Symbol _symbol_s = this._symbols[offset + 5];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSWhileNode(l, e, r, s);
            }
            case 178: {
                Symbol l = this._symbols[offset + 2];
                Symbol s1 = this._symbols[offset + 3];
                Symbol s2 = this._symbols[offset + 4];
                Symbol r = this._symbols[offset + 5];
                Symbol _symbol_s = this._symbols[offset + 6];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSEmptyNode(l), s1, (JSNode)new JSEmptyNode(s1), s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 179: {
                Symbol l = this._symbols[offset + 2];
                Symbol s1 = this._symbols[offset + 3];
                Symbol s2 = this._symbols[offset + 4];
                Symbol _symbol_a = this._symbols[offset + 5];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSEmptyNode(l), s1, (JSNode)new JSEmptyNode(s1), s2, a, r, s);
            }
            case 180: {
                Symbol l = this._symbols[offset + 2];
                Symbol s1 = this._symbols[offset + 3];
                Symbol _symbol_c = this._symbols[offset + 4];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 5];
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSEmptyNode(l), s1, c, s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 181: {
                Symbol l = this._symbols[offset + 2];
                Symbol s1 = this._symbols[offset + 3];
                Symbol _symbol_c = this._symbols[offset + 4];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 5];
                Symbol _symbol_a = this._symbols[offset + 6];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSEmptyNode(l), s1, c, s2, a, r, s);
            }
            case 182: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol s1 = this._symbols[offset + 4];
                Symbol s2 = this._symbols[offset + 5];
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, i, s1, (JSNode)new JSEmptyNode(s1), s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 183: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol s1 = this._symbols[offset + 4];
                Symbol s2 = this._symbols[offset + 5];
                Symbol _symbol_a = this._symbols[offset + 6];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, i, s1, (JSNode)new JSEmptyNode(s1), s2, a, r, s);
            }
            case 184: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol s1 = this._symbols[offset + 4];
                Symbol _symbol_c = this._symbols[offset + 5];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 6];
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, i, s1, c, s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 185: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol s1 = this._symbols[offset + 4];
                Symbol _symbol_c = this._symbols[offset + 5];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 6];
                Symbol _symbol_a = this._symbols[offset + 7];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 8];
                Symbol _symbol_s = this._symbols[offset + 9];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, i, s1, c, s2, a, r, s);
            }
            case 186: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                ArrayList _list_i = (ArrayList)_symbol_i.value;
                JSNode[] i = _list_i == null ? new JSNode[]{} : _list_i.toArray(new JSNode[_list_i.size()]);
                Symbol s1 = this._symbols[offset + 5];
                Symbol s2 = this._symbols[offset + 6];
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSVarNode(v, i), s1, (JSNode)new JSEmptyNode(s1), s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 187: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                ArrayList _list_i = (ArrayList)_symbol_i.value;
                JSNode[] i = _list_i == null ? new JSNode[]{} : _list_i.toArray(new JSNode[_list_i.size()]);
                Symbol s1 = this._symbols[offset + 5];
                Symbol s2 = this._symbols[offset + 6];
                Symbol _symbol_a = this._symbols[offset + 7];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 8];
                Symbol _symbol_s = this._symbols[offset + 9];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSVarNode(v, i), s1, (JSNode)new JSEmptyNode(s1), s2, a, r, s);
            }
            case 188: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                ArrayList _list_i = (ArrayList)_symbol_i.value;
                JSNode[] i = _list_i == null ? new JSNode[]{} : _list_i.toArray(new JSNode[_list_i.size()]);
                Symbol s1 = this._symbols[offset + 5];
                Symbol _symbol_c = this._symbols[offset + 6];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 7];
                Symbol r = this._symbols[offset + 8];
                Symbol _symbol_s = this._symbols[offset + 9];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSVarNode(v, i), s1, c, s2, (JSNode)new JSEmptyNode(s2), r, s);
            }
            case 189: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                ArrayList _list_i = (ArrayList)_symbol_i.value;
                JSNode[] i = _list_i == null ? new JSNode[]{} : _list_i.toArray(new JSNode[_list_i.size()]);
                Symbol s1 = this._symbols[offset + 5];
                Symbol _symbol_c = this._symbols[offset + 6];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol s2 = this._symbols[offset + 7];
                Symbol _symbol_a = this._symbols[offset + 8];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                Symbol r = this._symbols[offset + 9];
                Symbol _symbol_s = this._symbols[offset + 10];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForNode(l, (JSNode)new JSVarNode(v, i), s1, c, s2, a, r, s);
            }
            case 190: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol in = this._symbols[offset + 4];
                Symbol _symbol_o = this._symbols[offset + 5];
                JSNode o = (JSNode)((Object)_symbol_o.value);
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForInNode(l, i, in, o, r, s);
            }
            case 191: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol in = this._symbols[offset + 5];
                Symbol _symbol_o = this._symbols[offset + 6];
                JSNode o = (JSNode)((Object)_symbol_o.value);
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForInNode(l, (JSNode)new JSVarNode(v, i), in, o, r, s);
            }
            case 192: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_i = this._symbols[offset + 3];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol of = this._symbols[offset + 4];
                Symbol _symbol_o = this._symbols[offset + 5];
                JSNode o = (JSNode)((Object)_symbol_o.value);
                Symbol r = this._symbols[offset + 6];
                Symbol _symbol_s = this._symbols[offset + 7];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForOfNode(l, i, of, o, r, s);
            }
            case 193: {
                Symbol l = this._symbols[offset + 2];
                Symbol v = this._symbols[offset + 3];
                Symbol _symbol_i = this._symbols[offset + 4];
                JSNode i = (JSNode)((Object)_symbol_i.value);
                Symbol of = this._symbols[offset + 5];
                Symbol _symbol_o = this._symbols[offset + 6];
                JSNode o = (JSNode)((Object)_symbol_o.value);
                Symbol r = this._symbols[offset + 7];
                Symbol _symbol_s = this._symbols[offset + 8];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSForOfNode(l, (JSNode)new JSVarNode(v, i), of, o, r, s);
            }
            case 194: {
                JSContinueNode node = new JSContinueNode();
                node.setSemicolonIncluded(true);
                return node;
            }
            case 195: {
                Symbol i = this._symbols[offset + 2];
                JSContinueNode node = new JSContinueNode(i);
                node.setSemicolonIncluded(true);
                return node;
            }
            case 196: {
                JSBreakNode node = new JSBreakNode();
                node.setSemicolonIncluded(true);
                return node;
            }
            case 197: {
                Symbol i = this._symbols[offset + 2];
                JSBreakNode node = new JSBreakNode(i);
                node.setSemicolonIncluded(true);
                return node;
            }
            case 198: {
                Symbol r = this._symbols[offset + 1];
                JSReturnNode node = new JSReturnNode(new JSEmptyNode(r));
                node.setSemicolonIncluded(true);
                return node;
            }
            case 199: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                JSReturnNode node = new JSReturnNode(e);
                node.setSemicolonIncluded(true);
                return node;
            }
            case 200: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 4];
                Symbol _symbol_s = this._symbols[offset + 5];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSWithNode(l, e, r, s);
            }
            case 201: {
                Symbol l = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 4];
                Symbol _symbol_s = this._symbols[offset + 5];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                return new JSWithNode(l, e, r, s);
            }
            case 202: {
                Symbol lp = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol rp = this._symbols[offset + 4];
                Symbol lc = this._symbols[offset + 5];
                Symbol rc = this._symbols[offset + 6];
                return new JSSwitchNode(lp, e, rp, lc, rc, new JSNode[0]);
            }
            case 203: {
                Symbol lp = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol rp = this._symbols[offset + 4];
                Symbol lc = this._symbols[offset + 5];
                Symbol _symbol_c = this._symbols[offset + 6];
                ArrayList _list_c = (ArrayList)_symbol_c.value;
                JSNode[] c = _list_c == null ? new JSNode[]{} : _list_c.toArray(new JSNode[_list_c.size()]);
                Symbol rc = this._symbols[offset + 7];
                ArrayList<JSNode> nodes = new ArrayList<JSNode>();
                JSNode[] s = c;
                int _symbol_s = c.length;
                int r = 0;
                while (r < _symbol_s) {
                    JSNode statement = s[r];
                    nodes.add(statement);
                    ++r;
                }
                JSNode[] children = nodes.toArray(new JSNode[nodes.size()]);
                return new JSSwitchNode(lp, e, rp, lc, rc, children);
            }
            case 204: {
                Symbol lp = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol rp = this._symbols[offset + 4];
                Symbol lc = this._symbols[offset + 5];
                Symbol _symbol_d = this._symbols[offset + 6];
                JSNode d = (JSNode)((Object)_symbol_d.value);
                Symbol rc = this._symbols[offset + 7];
                return new JSSwitchNode(lp, e, rp, lc, rc, d);
            }
            case 205: {
                Symbol lp = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol rp = this._symbols[offset + 4];
                Symbol lc = this._symbols[offset + 5];
                Symbol _symbol_d = this._symbols[offset + 6];
                JSNode d = (JSNode)((Object)_symbol_d.value);
                Symbol _symbol_c = this._symbols[offset + 7];
                ArrayList _list_c = (ArrayList)_symbol_c.value;
                JSNode[] c = _list_c == null ? new JSNode[]{} : _list_c.toArray(new JSNode[_list_c.size()]);
                Symbol rc = this._symbols[offset + 8];
                ArrayList<JSNode> nodes = new ArrayList<JSNode>();
                nodes.add(d);
                JSNode[] jSNodeArray = c;
                int n = c.length;
                int s = 0;
                while (s < n) {
                    JSNode statement = jSNodeArray[s];
                    nodes.add(statement);
                    ++s;
                }
                JSNode[] children = nodes.toArray(new JSNode[nodes.size()]);
                return new JSSwitchNode(lp, e, rp, lc, rc, children);
            }
            case 206: {
                Symbol lp = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol rp = this._symbols[offset + 4];
                Symbol lc = this._symbols[offset + 5];
                Symbol _symbol_c = this._symbols[offset + 6];
                ArrayList _list_c = (ArrayList)_symbol_c.value;
                JSNode[] c = _list_c == null ? new JSNode[]{} : _list_c.toArray(new JSNode[_list_c.size()]);
                Symbol _symbol_d = this._symbols[offset + 7];
                JSNode d = (JSNode)((Object)_symbol_d.value);
                Symbol rc = this._symbols[offset + 8];
                ArrayList<JSNode> nodes = new ArrayList<JSNode>();
                JSNode[] jSNodeArray = c;
                int n = c.length;
                int s = 0;
                while (s < n) {
                    JSNode statement = jSNodeArray[s];
                    nodes.add(statement);
                    ++s;
                }
                nodes.add(d);
                JSNode[] children = nodes.toArray(new JSNode[nodes.size()]);
                return new JSSwitchNode(lp, e, rp, lc, rc, children);
            }
            case 207: {
                JSNode statement;
                Symbol lp = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol rp = this._symbols[offset + 4];
                Symbol lc = this._symbols[offset + 5];
                Symbol _symbol_c1 = this._symbols[offset + 6];
                ArrayList _list_c1 = (ArrayList)_symbol_c1.value;
                JSNode[] c1 = _list_c1 == null ? new JSNode[]{} : _list_c1.toArray(new JSNode[_list_c1.size()]);
                Symbol _symbol_d = this._symbols[offset + 7];
                JSNode d = (JSNode)((Object)_symbol_d.value);
                Symbol _symbol_c2 = this._symbols[offset + 8];
                ArrayList _list_c2 = (ArrayList)_symbol_c2.value;
                JSNode[] c2 = _list_c2 == null ? new JSNode[]{} : _list_c2.toArray(new JSNode[_list_c2.size()]);
                Symbol rc = this._symbols[offset + 9];
                ArrayList<JSNode> nodes = new ArrayList<JSNode>();
                JSNode[] jSNodeArray = c1;
                int n = c1.length;
                int n2 = 0;
                while (n2 < n) {
                    statement = jSNodeArray[n2];
                    nodes.add(statement);
                    ++n2;
                }
                nodes.add(d);
                jSNodeArray = c2;
                n = c2.length;
                n2 = 0;
                while (n2 < n) {
                    statement = jSNodeArray[n2];
                    nodes.add(statement);
                    ++n2;
                }
                JSNode[] children = nodes.toArray(new JSNode[nodes.size()]);
                return new JSSwitchNode(lp, e, rp, lc, rc, children);
            }
            case 208: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 209: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 210: {
                Symbol c = this._symbols[offset + 2];
                return new JSCaseNode(c, new JSNode[0]);
            }
            case 211: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol c = this._symbols[offset + 3];
                return new JSCaseNode(e, c, new JSNode[0]);
            }
            case 212: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol c = this._symbols[offset + 3];
                Symbol _symbol_s = this._symbols[offset + 4];
                ArrayList _list_s = (ArrayList)_symbol_s.value;
                JSNode[] s = _list_s == null ? new JSNode[]{} : _list_s.toArray(new JSNode[_list_s.size()]);
                return new JSCaseNode(e, c, s);
            }
            case 213: {
                Symbol c = this._symbols[offset + 2];
                return new JSDefaultNode(c, new JSNode[0]);
            }
            case 214: {
                Symbol c = this._symbols[offset + 2];
                Symbol _symbol_s = this._symbols[offset + 3];
                ArrayList _list_s = (ArrayList)_symbol_s.value;
                JSNode[] s = _list_s == null ? new JSNode[]{} : _list_s.toArray(new JSNode[_list_s.size()]);
                return new JSDefaultNode(c, s);
            }
            case 215: {
                Symbol i = this._symbols[offset + 1];
                Symbol c = this._symbols[offset + 2];
                Symbol _symbol_s = this._symbols[offset + 3];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                JSIdentifierNode id = new JSIdentifierNode(i);
                id.setLocation(i.getStart(), i.getEnd());
                return new JSLabelledNode(id, c, s);
            }
            case 218: {
                Symbol i = this._symbols[offset + 1];
                Symbol c = this._symbols[offset + 2];
                Symbol _symbol_s = this._symbols[offset + 3];
                JSNode s = (JSNode)((Object)_symbol_s.value);
                JSIdentifierNode id = new JSIdentifierNode(i);
                id.setLocation(i.getStart(), i.getEnd());
                return new JSLabelledNode(id, c, s);
            }
            case 219: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                JSThrowNode node = new JSThrowNode(e);
                node.setSemicolonIncluded(true);
                return node;
            }
            case 220: {
                Symbol _symbol_b = this._symbols[offset + 2];
                JSNode b = (JSNode)((Object)_symbol_b.value);
                Symbol _symbol_c = this._symbols[offset + 3];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                return new JSTryNode(b, c, new JSEmptyNode((Symbol)c));
            }
            case 221: {
                Symbol _symbol_b = this._symbols[offset + 2];
                JSNode b = (JSNode)((Object)_symbol_b.value);
                Symbol _symbol_f = this._symbols[offset + 3];
                JSNode f = (JSNode)((Object)_symbol_f.value);
                return new JSTryNode(b, new JSEmptyNode((Symbol)b), f);
            }
            case 222: {
                Symbol _symbol_b = this._symbols[offset + 2];
                JSNode b = (JSNode)((Object)_symbol_b.value);
                Symbol _symbol_c = this._symbols[offset + 3];
                JSNode c = (JSNode)((Object)_symbol_c.value);
                Symbol _symbol_f = this._symbols[offset + 4];
                JSNode f = (JSNode)((Object)_symbol_f.value);
                return new JSTryNode(b, c, f);
            }
            case 223: {
                Symbol d = this._symbols[offset + 1];
                return new JSDebuggerNode(d);
            }
            case 224: {
                Symbol i = this._symbols[offset + 3];
                Symbol _symbol_b = this._symbols[offset + 5];
                JSNode b = (JSNode)((Object)_symbol_b.value);
                JSIdentifierNode id = new JSIdentifierNode(i);
                return new JSCatchNode(id, b);
            }
            case 225: {
                Symbol _symbol_p = this._symbols[offset + 3];
                JSNode p = (JSNode)((Object)_symbol_p.value);
                Symbol _symbol_b = this._symbols[offset + 5];
                JSNode b = (JSNode)((Object)_symbol_b.value);
                return new JSCatchNode(p, b);
            }
            case 226: {
                Symbol i = this._symbols[offset + 3];
                Symbol e = this._symbols[offset + 5];
                Symbol _symbol_b = this._symbols[offset + 7];
                JSNode b = (JSNode)((Object)_symbol_b.value);
                JSIdentifierNode id = new JSIdentifierNode(i);
                JSNode conditionNode = (JSNode)((Object)e.value);
                return new JSCatchNode(id, conditionNode, b);
            }
            case 227: {
                Symbol _symbol_b = this._symbols[offset + 2];
                JSNode b = (JSNode)((Object)_symbol_b.value);
                return new JSFinallyNode(b);
            }
            case 230: {
                Symbol t = this._symbols[offset + 1];
                return new JSThisNode(t);
            }
            case 231: {
                Symbol i = this._symbols[offset + 1];
                return new JSIdentifierNode(i);
            }
            case 234: {
                Symbol l = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 3];
                return new JSGroupNode(l, e, r);
            }
            case 238: {
                Symbol _symbol_open = this._symbols[offset + 1];
                JSNode open = (JSNode)((Object)_symbol_open.value);
                Symbol _symbol_close = this._symbols[offset + 2];
                JSNode close = (JSNode)((Object)_symbol_close.value);
                JSXElementNode el = new JSXElementNode(open, close);
                return el;
            }
            case 239: {
                Symbol _symbol_open = this._symbols[offset + 1];
                JSNode open = (JSNode)((Object)_symbol_open.value);
                Symbol _symbol_children = this._symbols[offset + 2];
                ArrayList _list_children = (ArrayList)_symbol_children.value;
                JSNode[] children = _list_children == null ? new JSNode[]{} : _list_children.toArray(new JSNode[_list_children.size()]);
                Symbol _symbol_close = this._symbols[offset + 3];
                JSNode close = (JSNode)((Object)_symbol_close.value);
                JSXElementNode el = new JSXElementNode(open, close, children);
                return el;
            }
            case 240: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 241: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 242: {
                Symbol o = this._symbols[offset + 1];
                Symbol _symbol_name = this._symbols[offset + 2];
                JSNode name = (JSNode)((Object)_symbol_name.value);
                Symbol _symbol_attrs = this._symbols[offset + 3];
                JSNode attrs = (JSNode)((Object)_symbol_attrs.value);
                Symbol close = this._symbols[offset + 4];
                JSXOpeningElementNode open = new JSXOpeningElementNode(o, close, name, attrs);
                return new JSXElementNode((JSNode)open, true);
            }
            case 243: {
                Symbol o = this._symbols[offset + 1];
                Symbol _symbol_name = this._symbols[offset + 2];
                JSNode name = (JSNode)((Object)_symbol_name.value);
                Symbol close = this._symbols[offset + 3];
                JSXOpeningElementNode open = new JSXOpeningElementNode(o, close, name);
                return new JSXElementNode((JSNode)open, true);
            }
            case 244: {
                Symbol o = this._symbols[offset + 1];
                Symbol _symbol_name = this._symbols[offset + 2];
                JSNode name = (JSNode)((Object)_symbol_name.value);
                Symbol _symbol_attrs = this._symbols[offset + 3];
                JSNode attrs = (JSNode)((Object)_symbol_attrs.value);
                Symbol close = this._symbols[offset + 4];
                return new JSXOpeningElementNode(o, close, name, attrs);
            }
            case 245: {
                Symbol o = this._symbols[offset + 1];
                Symbol _symbol_name = this._symbols[offset + 2];
                JSNode name = (JSNode)((Object)_symbol_name.value);
                Symbol close = this._symbols[offset + 3];
                return new JSXOpeningElementNode(o, close, name);
            }
            case 246: {
                Symbol begin = this._symbols[offset + 1];
                Symbol _symbol_name = this._symbols[offset + 2];
                JSNode name = (JSNode)((Object)_symbol_name.value);
                Symbol end = this._symbols[offset + 3];
                return new JSXClosingElementNode(begin, name, end);
            }
            case 247: {
                Symbol s = this._symbols[offset + 1];
                return new JSXElementNameNode(s);
            }
            case 248: {
                Symbol s = this._symbols[offset + 1];
                return new JSXElementNameNode(s);
            }
            case 249: {
                Symbol s = this._symbols[offset + 1];
                return new JSXElementNameNode(s);
            }
            case 255: {
                Symbol _symbol_attr = this._symbols[offset + 1];
                JSNode attr = (JSNode)((Object)_symbol_attr.value);
                return new JSXAttributesNode(attr);
            }
            case 256: {
                Symbol _symbol_attrs = this._symbols[offset + 1];
                JSNode attrs = (JSNode)((Object)_symbol_attrs.value);
                Symbol _symbol_attr = this._symbols[offset + 2];
                JSNode attr = (JSNode)((Object)_symbol_attr.value);
                attrs.addChild((IParseNode)attr);
                return attrs;
            }
            case 257: {
                Symbol _symbol_attr = this._symbols[offset + 1];
                JSNode attr = (JSNode)((Object)_symbol_attr.value);
                return new JSXAttributesNode(attr);
            }
            case 258: {
                Symbol _symbol_attrs = this._symbols[offset + 1];
                JSNode attrs = (JSNode)((Object)_symbol_attrs.value);
                Symbol _symbol_attr = this._symbols[offset + 2];
                JSNode attr = (JSNode)((Object)_symbol_attr.value);
                attrs.addChild((IParseNode)attr);
                return attrs;
            }
            case 259: {
                Symbol l = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 4];
                return new JSXExpressionNode(l, e, r);
            }
            case 260: {
                Symbol l = this._symbols[offset + 1];
                Symbol e = this._symbols[offset + 2];
                Symbol r = this._symbols[offset + 3];
                return new JSXExpressionNode(l, (JSNode)new JSEmptyNode(e), r);
            }
            case 261: {
                Symbol _symbol_name = this._symbols[offset + 1];
                JSNode name = (JSNode)((Object)_symbol_name.value);
                Symbol eq = this._symbols[offset + 2];
                Symbol _symbol_value = this._symbols[offset + 3];
                JSNode value = (JSNode)((Object)_symbol_value.value);
                return new JSXAttributeNode(name, eq, value);
            }
            case 262: {
                Symbol id = this._symbols[offset + 1];
                return new JSXAttributeNameNode(id);
            }
            case 263: {
                Symbol name = this._symbols[offset + 1];
                return new JSXAttributeNameNode(name);
            }
            case 264: {
                Symbol s = this._symbols[offset + 1];
                return new JSStringNode(s);
            }
            case 266: {
                Symbol l = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 3];
                return new JSXExpressionNode(l, e, r);
            }
            case 267: {
                Symbol l = this._symbols[offset + 1];
                Symbol r = this._symbols[offset + 2];
                return new JSXExpressionNode(l, (JSNode)new JSEmptyNode(l.getEnd()), r);
            }
            case 268: {
                Symbol text = this._symbols[offset + 1];
                return new JSXTextNode(text);
            }
            case 271: {
                return new JSTemplateNode();
            }
            case 272: {
                Symbol cfr_ignored_0 = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol spans = this._symbols[offset + 3];
                JSTemplateNode tempNode = new JSTemplateNode();
                tempNode.addChild((IParseNode)e);
                if (spans.value instanceof JSTemplateExpressionListNode) {
                    JSTemplateExpressionListNode list = (JSTemplateExpressionListNode)((Object)spans.value);
                    Iterator open = list.iterator();
                    while (open.hasNext()) {
                        IParseNode child = (IParseNode)open.next();
                        tempNode.addChild(child);
                    }
                }
                return tempNode;
            }
            case 274: {
                Symbol _symbol_list = this._symbols[offset + 1];
                JSNode list = (JSNode)((Object)_symbol_list.value);
                return list;
            }
            case 275: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                JSTemplateExpressionListNode node = new JSTemplateExpressionListNode();
                node.addChild((IParseNode)e);
                return node;
            }
            case 276: {
                Symbol _symbol_list = this._symbols[offset + 1];
                JSNode list = (JSNode)((Object)_symbol_list.value);
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                list.addChild((IParseNode)e);
                return list;
            }
            case 277: {
                Symbol l = this._symbols[offset + 1];
                Symbol r = this._symbols[offset + 2];
                return new JSArrayNode(l, r, new JSNode[0]);
            }
            case 278: {
                Symbol l = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 3];
                e.addChild((IParseNode)new JSNullNode());
                return new JSArrayNode(l, r, e);
            }
            case 279: {
                Symbol l = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 3];
                ArrayList<JSNode> list = new ArrayList<JSNode>();
                Iterator open = e.iterator();
                while (open.hasNext()) {
                    IParseNode child = (IParseNode)open.next();
                    list.add((JSNode)child);
                }
                return new JSArrayNode(l, r, list.toArray(new JSNode[0]));
            }
            case 280: {
                Symbol l = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol r = this._symbols[offset + 4];
                ArrayList<JSNode> list = new ArrayList<JSNode>();
                Iterator open = e.iterator();
                while (open.hasNext()) {
                    IParseNode child = (IParseNode)open.next();
                    list.add((JSNode)child);
                }
                list.add(new JSNullNode());
                return new JSArrayNode(l, r, list.toArray(new JSNode[0]));
            }
            case 281: {
                Symbol l = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol _symbol_n = this._symbols[offset + 4];
                JSNode n = (JSNode)((Object)_symbol_n.value);
                Symbol r = this._symbols[offset + 5];
                ArrayList<JSNode> list = new ArrayList<JSNode>();
                Iterator iterator = e.iterator();
                while (iterator.hasNext()) {
                    IParseNode child = (IParseNode)iterator.next();
                    list.add((JSNode)child);
                }
                n.addChild((IParseNode)new JSNullNode());
                list.add(n);
                return new JSArrayNode(l, r, list.toArray(new JSNode[0]));
            }
            case 282: {
                Symbol _symbol_e = this._symbols[offset + 1];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                return new JSElementsNode(e);
            }
            case 283: {
                Symbol _symbol_n = this._symbols[offset + 1];
                JSNode n = (JSNode)((Object)_symbol_n.value);
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                return new JSElementsNode(n, e);
            }
            case 284: {
                Symbol _symbol_spread = this._symbols[offset + 1];
                JSNode spread = (JSNode)((Object)_symbol_spread.value);
                return new JSElementsNode(spread);
            }
            case 285: {
                Symbol _symbol_n = this._symbols[offset + 1];
                JSNode n = (JSNode)((Object)_symbol_n.value);
                Symbol _symbol_spread = this._symbols[offset + 2];
                JSNode spread = (JSNode)((Object)_symbol_spread.value);
                return new JSElementsNode(n, spread);
            }
            case 286: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_e = this._symbols[offset + 3];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                l.addChild((IParseNode)e);
                return l;
            }
            case 287: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_n = this._symbols[offset + 3];
                JSNode n = (JSNode)((Object)_symbol_n.value);
                Symbol _symbol_e = this._symbols[offset + 4];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                l.addChild((IParseNode)n);
                l.addChild((IParseNode)e);
                return l;
            }
            case 288: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_spread = this._symbols[offset + 3];
                JSNode spread = (JSNode)((Object)_symbol_spread.value);
                l.addChild((IParseNode)spread);
                return l;
            }
            case 289: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_n = this._symbols[offset + 3];
                JSNode n = (JSNode)((Object)_symbol_n.value);
                Symbol _symbol_spread = this._symbols[offset + 4];
                JSNode spread = (JSNode)((Object)_symbol_spread.value);
                l.addChild((IParseNode)n);
                l.addChild((IParseNode)spread);
                return l;
            }
            case 290: {
                Symbol _symbol_assign = this._symbols[offset + 2];
                JSNode assign = (JSNode)((Object)_symbol_assign.value);
                return new JSSpreadElementNode(assign);
            }
            case 291: {
                Symbol _symbol_e = this._symbols[offset + 1];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                e.addChild((IParseNode)new JSNullNode());
                return e;
            }
            case 292: {
                return new JSElisionNode(new JSNullNode());
            }
            case 293: {
                Symbol l = this._symbols[offset + 1];
                Symbol r = this._symbols[offset + 2];
                return new JSObjectNode(l, r, new JSNode[0]);
            }
            case 294: {
                Symbol l = this._symbols[offset + 1];
                Symbol _symbol_p = this._symbols[offset + 2];
                ArrayList _list_p = (ArrayList)_symbol_p.value;
                JSNode[] p = _list_p == null ? new JSNode[]{} : _list_p.toArray(new JSNode[_list_p.size()]);
                Symbol r = this._symbols[offset + 3];
                return new JSObjectNode(l, r, p);
            }
            case 295: {
                Symbol l = this._symbols[offset + 1];
                Symbol _symbol_p = this._symbols[offset + 2];
                ArrayList _list_p = (ArrayList)_symbol_p.value;
                JSNode[] p = _list_p == null ? new JSNode[]{} : _list_p.toArray(new JSNode[_list_p.size()]);
                Symbol r = this._symbols[offset + 4];
                return new JSObjectNode(l, r, p);
            }
            case 296: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 297: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 3].value);
                return this._symbols[offset + 1];
            }
            case 298: {
                Symbol _symbol_ref = this._symbols[offset + 1];
                JSNode ref = (JSNode)((Object)_symbol_ref.value);
                return new JSNameValuePairNode(ref, null, null);
            }
            case 299: {
                Symbol _symbol_cover = this._symbols[offset + 1];
                JSNode cover = (JSNode)((Object)_symbol_cover.value);
                return new JSNameValuePairNode(cover, null, null);
            }
            case 300: {
                Symbol _symbol_def = this._symbols[offset + 1];
                JSMethodNode def = (JSMethodNode)((Object)_symbol_def.value);
                return new JSNameValuePairNode(def, null, null);
            }
            case 301: {
                Symbol _symbol_n = this._symbols[offset + 1];
                JSNode n = (JSNode)((Object)_symbol_n.value);
                Symbol c = this._symbols[offset + 2];
                Symbol _symbol_v = this._symbols[offset + 3];
                JSNode v = (JSNode)((Object)_symbol_v.value);
                return new JSNameValuePairNode(n, c, v);
            }
            case 302: {
                Symbol _symbol_n = this._symbols[offset + 1];
                JSNode n = (JSNode)((Object)_symbol_n.value);
                Symbol c = this._symbols[offset + 2];
                Symbol cfr_ignored_1 = this._symbols[offset + 3];
                return new JSNameValuePairNode(n, c, (JSNode)new JSEmptyNode(c));
            }
            case 303: {
                Symbol i = this._symbols[offset + 1];
                return new JSIdentifierNode(i);
            }
            case 304: {
                Symbol _symbol_ref = this._symbols[offset + 1];
                JSNode ref = (JSNode)((Object)_symbol_ref.value);
                Symbol e = this._symbols[offset + 2];
                Symbol _symbol_expression = this._symbols[offset + 3];
                JSNode expression = (JSNode)((Object)_symbol_expression.value);
                return new JSDeclarationNode(ref, e, expression);
            }
            case 307: {
                Symbol _symbol_bind = this._symbols[offset + 1];
                JSNode bind = (JSNode)((Object)_symbol_bind.value);
                Symbol e = this._symbols[offset + 2];
                Symbol _symbol_expression = this._symbols[offset + 3];
                JSNode expression = (JSNode)((Object)_symbol_expression.value);
                return new JSDeclarationNode(bind, e, expression);
            }
            case 308: {
                Symbol i = this._symbols[offset + 1];
                return new JSIdentifierNode(i);
            }
            case 309: {
                Symbol i = this._symbols[offset + 1];
                Symbol e = this._symbols[offset + 2];
                Symbol _symbol_expression = this._symbols[offset + 3];
                JSNode expression = (JSNode)((Object)_symbol_expression.value);
                JSDeclarationNode expr = new JSDeclarationNode(new JSIdentifierNode(i), e, expression);
                return expr;
            }
            case 314: {
                Symbol i = this._symbols[offset + 1];
                return new JSIdentifierNode(i);
            }
            case 315: {
                Symbol s = this._symbols[offset + 1];
                return new JSStringNode(s);
            }
            case 316: {
                Symbol n = this._symbols[offset + 1];
                return new JSNumberNode(n);
            }
            case 318: {
                Symbol lb = this._symbols[offset + 1];
                Symbol _symbol_assign = this._symbols[offset + 2];
                JSNode assign = (JSNode)((Object)_symbol_assign.value);
                Symbol rb = this._symbols[offset + 3];
                return new JSComputedPropertyNode(lb, assign, rb);
            }
            case 321: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol lb = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                Symbol rb = this._symbols[offset + 4];
                return new JSGetElementNode(l, lb, r, rb);
            }
            case 322: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol r = this._symbols[offset + 3];
                return new JSGetPropertyNode(l, o, (JSNode)new JSIdentifierNode(r));
            }
            case 323: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_t = this._symbols[offset + 2];
                JSTemplateNode t = (JSTemplateNode)((Object)_symbol_t.value);
                t.setExpression(l);
                return t;
            }
            case 326: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol _symbol_a = this._symbols[offset + 3];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                return new JSConstructNode(e, a);
            }
            case 327: {
                return new JSMetaPropertyNode();
            }
            case 328: {
                Symbol s = this._symbols[offset + 1];
                Symbol lb = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                Symbol rb = this._symbols[offset + 4];
                JSSuperNode superNode = new JSSuperNode(s);
                return new JSGetElementNode(superNode, lb, r, rb);
            }
            case 329: {
                Symbol s = this._symbols[offset + 1];
                Symbol o = this._symbols[offset + 2];
                Symbol r = this._symbols[offset + 3];
                JSSuperNode superNode = new JSSuperNode(s);
                return new JSGetPropertyNode(superNode, o, (JSNode)new JSIdentifierNode(r));
            }
            case 331: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol lb = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                Symbol rb = this._symbols[offset + 4];
                return new JSGetElementNode(l, lb, r, rb);
            }
            case 332: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol r = this._symbols[offset + 3];
                return new JSGetPropertyNode(l, o, (JSNode)new JSIdentifierNode(r));
            }
            case 335: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol _symbol_a = this._symbols[offset + 3];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                return new JSConstructNode(e, a);
            }
            case 337: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                return new JSConstructNode(e, new JSEmptyNode((Symbol)e));
            }
            case 339: {
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                return new JSConstructNode(e, new JSEmptyNode((Symbol)e));
            }
            case 340: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_r = this._symbols[offset + 2];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSInvokeNode(l, r);
            }
            case 342: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_r = this._symbols[offset + 2];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSInvokeNode(l, r);
            }
            case 343: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol lb = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                Symbol rb = this._symbols[offset + 4];
                return new JSGetElementNode(l, lb, r, rb);
            }
            case 344: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol r = this._symbols[offset + 3];
                return new JSGetPropertyNode(l, o, (JSNode)new JSIdentifierNode(r));
            }
            case 345: {
                Symbol s = this._symbols[offset + 1];
                Symbol _symbol_r = this._symbols[offset + 2];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                JSSuperNode superNode = new JSSuperNode(s);
                return new JSInvokeNode(superNode, r);
            }
            case 346: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_r = this._symbols[offset + 2];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSInvokeNode(l, r);
            }
            case 348: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_r = this._symbols[offset + 2];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSInvokeNode(l, r);
            }
            case 349: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol lb = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                Symbol rb = this._symbols[offset + 4];
                return new JSGetElementNode(l, lb, r, rb);
            }
            case 350: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol r = this._symbols[offset + 3];
                return new JSGetPropertyNode(l, o, (JSNode)new JSIdentifierNode(r));
            }
            case 351: {
                return new JSArgumentsNode(new JSNode[0]);
            }
            case 352: {
                Symbol _symbol_a = this._symbols[offset + 2];
                JSNode a = (JSNode)((Object)_symbol_a.value);
                return a;
            }
            case 353: {
                Symbol _symbol_list = this._symbols[offset + 1];
                JSNode list = (JSNode)((Object)_symbol_list.value);
                Symbol _symbol_expr = this._symbols[offset + 3];
                JSNode expr = (JSNode)((Object)_symbol_expr.value);
                list.addChild((IParseNode)expr);
                return list;
            }
            case 354: {
                Symbol _symbol_list = this._symbols[offset + 1];
                JSNode list = (JSNode)((Object)_symbol_list.value);
                Symbol _symbol_expr = this._symbols[offset + 4];
                JSNode expr = (JSNode)((Object)_symbol_expr.value);
                list.addChild((IParseNode)new JSRestArgumentNode(expr));
                return list;
            }
            case 355: {
                Symbol _symbol_expr = this._symbols[offset + 1];
                JSNode expr = (JSNode)((Object)_symbol_expr.value);
                return new JSArgumentsNode(expr);
            }
            case 356: {
                Symbol _symbol_expr = this._symbols[offset + 2];
                JSNode expr = (JSNode)((Object)_symbol_expr.value);
                return new JSArgumentsNode(new JSRestArgumentNode(expr));
            }
            case 362: {
                Symbol _symbol_e = this._symbols[offset + 1];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol o = this._symbols[offset + 2];
                return new JSPostUnaryOperatorNode(o, e);
            }
            case 364: {
                Symbol _symbol_e = this._symbols[offset + 1];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                Symbol o = this._symbols[offset + 2];
                return new JSPostUnaryOperatorNode(o, e);
            }
            case 368: {
                Symbol o = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                return new JSPreUnaryOperatorNode(o, e);
            }
            case 370: {
                Symbol o = this._symbols[offset + 1];
                Symbol _symbol_e = this._symbols[offset + 2];
                JSNode e = (JSNode)((Object)_symbol_e.value);
                return new JSPreUnaryOperatorNode(o, e);
            }
            case 381: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 383: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 388: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 390: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 394: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 396: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 401: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 403: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 405: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 414: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 416: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 418: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 423: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 425: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 427: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 429: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 431: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 433: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 435: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 437: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 439: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryArithmeticOperatorNode(l, o, r);
            }
            case 441: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 443: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 445: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 447: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 449: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 451: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSBinaryBooleanOperatorNode(l, o, r);
            }
            case 454: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol q = this._symbols[offset + 2];
                Symbol _symbol_t = this._symbols[offset + 3];
                JSNode t = (JSNode)((Object)_symbol_t.value);
                Symbol c = this._symbols[offset + 4];
                Symbol _symbol_f = this._symbols[offset + 5];
                JSNode f = (JSNode)((Object)_symbol_f.value);
                return new JSConditionalNode(l, q, t, c, f);
            }
            case 455: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol q = this._symbols[offset + 2];
                Symbol _symbol_t = this._symbols[offset + 3];
                JSNode t = (JSNode)((Object)_symbol_t.value);
                Symbol c = this._symbols[offset + 4];
                return new JSConditionalNode(l, q, t, c);
            }
            case 456: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol q = this._symbols[offset + 2];
                Symbol _symbol_t = this._symbols[offset + 3];
                JSNode t = (JSNode)((Object)_symbol_t.value);
                return new JSConditionalNode(l, q, t);
            }
            case 457: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol q = this._symbols[offset + 2];
                return new JSConditionalNode(l, q);
            }
            case 459: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol q = this._symbols[offset + 2];
                Symbol _symbol_t = this._symbols[offset + 3];
                JSNode t = (JSNode)((Object)_symbol_t.value);
                Symbol c = this._symbols[offset + 4];
                Symbol _symbol_f = this._symbols[offset + 5];
                JSNode f = (JSNode)((Object)_symbol_f.value);
                return new JSConditionalNode(l, q, t, c, f);
            }
            case 460: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol q = this._symbols[offset + 2];
                Symbol _symbol_t = this._symbols[offset + 3];
                JSNode t = (JSNode)((Object)_symbol_t.value);
                Symbol c = this._symbols[offset + 4];
                return new JSConditionalNode(l, q, t, c, null);
            }
            case 461: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol q = this._symbols[offset + 2];
                Symbol _symbol_t = this._symbols[offset + 3];
                JSNode t = (JSNode)((Object)_symbol_t.value);
                return new JSConditionalNode(l, q, t, null, null);
            }
            case 462: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol q = this._symbols[offset + 2];
                return new JSConditionalNode(l, q, null, null, null);
            }
            case 464: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol q = this._symbols[offset + 2];
                Symbol _symbol_t = this._symbols[offset + 3];
                JSNode t = (JSNode)((Object)_symbol_t.value);
                Symbol c = this._symbols[offset + 4];
                Symbol _symbol_f = this._symbols[offset + 5];
                JSNode f = (JSNode)((Object)_symbol_f.value);
                return new JSConditionalNode(l, q, t, c, f);
            }
            case 466: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSAssignmentNode(l, o, r);
            }
            case 469: {
                Symbol _symbol_params = this._symbols[offset + 1];
                JSNode params = (JSNode)((Object)_symbol_params.value);
                Symbol _symbol_body = this._symbols[offset + 3];
                JSNode body = (JSNode)((Object)_symbol_body.value);
                return new JSArrowFunctionNode(params, body);
            }
            case 470: {
                Symbol i = this._symbols[offset + 1];
                return new JSArrowParametersNode(new JSIdentifierNode(i));
            }
            case 474: {
                return new JSArrowParametersNode(new JSNode[0]);
            }
            case 475: {
                Symbol _symbol_rest = this._symbols[offset + 2];
                JSNode rest = (JSNode)((Object)_symbol_rest.value);
                return new JSArrowParametersNode(rest);
            }
            case 476: {
                Symbol _symbol_expr = this._symbols[offset + 2];
                JSNode expr = (JSNode)((Object)_symbol_expr.value);
                return new JSArrowParametersNode(expr);
            }
            case 477: {
                Symbol _symbol_expr = this._symbols[offset + 2];
                JSNode expr = (JSNode)((Object)_symbol_expr.value);
                Symbol _symbol_rest = this._symbols[offset + 4];
                JSNode rest = (JSNode)((Object)_symbol_rest.value);
                return new JSArrowParametersNode(expr, rest);
            }
            case 479: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSAssignmentNode(l, o, r);
            }
            case 483: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol o = this._symbols[offset + 2];
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSAssignmentNode(l, o, r);
            }
            case 497: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSCommaNode(l, r);
            }
            case 499: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSCommaNode(l, r);
            }
            case 501: {
                Symbol _symbol_l = this._symbols[offset + 1];
                JSNode l = (JSNode)((Object)_symbol_l.value);
                Symbol _symbol_r = this._symbols[offset + 3];
                JSNode r = (JSNode)((Object)_symbol_r.value);
                return new JSCommaNode(l, r);
            }
            case 503: {
                Symbol n = this._symbols[offset + 1];
                return new JSNullNode(n);
            }
            case 504: {
                Symbol t = this._symbols[offset + 1];
                return new JSTrueNode(t);
            }
            case 505: {
                Symbol f = this._symbols[offset + 1];
                return new JSFalseNode(f);
            }
            case 506: {
                Symbol n = this._symbols[offset + 1];
                return new JSNumberNode(n);
            }
            case 507: {
                Symbol s = this._symbols[offset + 1];
                return new JSStringNode(s);
            }
            case 508: {
                Symbol r = this._symbols[offset + 1];
                return new JSRegexNode(r);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 24: 
            case 25: 
            case 26: 
            case 34: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 60: 
            case 69: 
            case 70: 
            case 77: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 128: 
            case 129: 
            case 147: 
            case 216: 
            case 217: 
            case 228: 
            case 229: 
            case 232: 
            case 233: 
            case 235: 
            case 236: 
            case 237: 
            case 250: 
            case 251: 
            case 265: 
            case 269: 
            case 270: 
            case 273: 
            case 305: 
            case 306: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 317: 
            case 319: 
            case 320: 
            case 324: 
            case 325: 
            case 330: 
            case 333: 
            case 334: 
            case 336: 
            case 338: 
            case 341: 
            case 347: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 363: 
            case 365: 
            case 366: 
            case 367: 
            case 369: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 384: 
            case 385: 
            case 386: 
            case 387: 
            case 389: 
            case 391: 
            case 392: 
            case 393: 
            case 395: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 402: 
            case 404: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 415: 
            case 417: 
            case 419: 
            case 420: 
            case 421: 
            case 422: 
            case 424: 
            case 426: 
            case 428: 
            case 430: 
            case 432: 
            case 434: 
            case 436: 
            case 438: 
            case 440: 
            case 442: 
            case 444: 
            case 446: 
            case 448: 
            case 450: 
            case 452: 
            case 453: 
            case 458: 
            case 463: 
            case 465: 
            case 467: 
            case 468: 
            case 471: 
            case 472: 
            case 473: 
            case 478: 
            case 480: 
            case 481: 
            case 482: 
            case 484: 
            case 485: 
            case 486: 
            case 487: 
            case 488: 
            case 489: 
            case 490: 
            case 491: 
            case 492: 
            case 493: 
            case 494: 
            case 495: 
            case 496: 
            case 498: 
            case 500: 
            case 502: {
                return this._symbols[offset + 1];
            }
            case 148: {
                return this._symbols[offset + 2];
            }
            case 252: 
            case 253: 
            case 254: {
                return this._symbols[offset + 3];
            }
        }
        throw new IllegalArgumentException("unknown production #" + rule_num);
    }

    private class JSEvents
    extends Parser.Events {
        private JSEvents() {
        }

        public void scannerError(Scanner.Exception e) {
        }

        public void syntaxError(Symbol token) {
            if (token != null && JSParser.this.fWorking != null) {
                JSParser.this.fWorking.addError((IParseError)new ParseError("com.aptana.contenttype.js", token, IParseError.Severity.ERROR));
            }
        }

        public void unexpectedTokenRemoved(Symbol token) {
        }

        public void missingTokenInserted(Symbol token) {
        }

        public void missingTokensInserted(List<Symbol> tokens) {
            if (tokens != null && tokens.size() == 1 && tokens.get(0).getId() == 29 && JSParser.this.fWorking != null) {
                IParseError lastError;
                List errors = JSParser.this.fWorking.getErrors();
                IParseError iParseError = lastError = errors.isEmpty() ? null : (IParseError)errors.get(errors.size() - 1);
                if (lastError != null) {
                    JSParser.this.fWorking.removeError(lastError);
                }
            }
            super.missingTokensInserted(tokens);
        }

        public void misspelledTokenReplaced(Symbol token) {
        }

        public void errorPhraseRemoved(Symbol error) {
        }
    }
}

