/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.parsing;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.js.JSPlugin;
import com.aptana.parsing.IParseStateCacheKey;
import com.aptana.parsing.ParseState;
import com.aptana.parsing.ParseStateCacheKeyWithComments;
import java.util.Stack;
import org.eclipse.core.runtime.Plugin;

public class JSParseState
extends ParseState {
    private Stack<CommentContext> commentContentStack = new Stack();
    private boolean enableJsx = false;
    private boolean fNeedThrowExpcetion = true;

    public JSParseState(String source) {
        this(source, 0, true, true);
    }

    public void setThrowException(boolean throwEx) {
        this.fNeedThrowExpcetion = throwEx;
    }

    public JSParseState(String source, int startingOffset, boolean attachComments, boolean collectComments) {
        super(source, startingOffset);
        this.commentContentStack.push(new CommentContext());
        this.setAttachComments(attachComments);
        this.setCollectComments(collectComments);
    }

    public boolean attachComments() {
        return this.getCurrentCommentContext().attachComments;
    }

    public boolean collectComments() {
        return this.getCurrentCommentContext().attachComments;
    }

    protected CommentContext getCurrentCommentContext() {
        return this.commentContentStack.peek();
    }

    public void popCommentContext() {
        if (this.commentContentStack.size() > 1) {
            this.commentContentStack.pop();
        } else {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)"Tried to pop an empty comment context stack in JSParseState");
        }
    }

    public void pushCommentContext() {
        this.commentContentStack.push(new CommentContext(this.getCurrentCommentContext()));
    }

    private void setAttachComments(boolean flag) {
        this.commentContentStack.peek().attachComments = flag;
    }

    private void setCollectComments(boolean flag) {
        this.commentContentStack.peek().attachComments = flag;
    }

    public IParseStateCacheKey getCacheKey(String contentTypeId) {
        IParseStateCacheKey cacheKey = super.getCacheKey(contentTypeId);
        return new ParseStateCacheKeyWithComments(this.attachComments(), this.collectComments(), cacheKey);
    }

    public boolean isEnableJsx() {
        return this.enableJsx;
    }

    public void setEnableJsx(boolean jsx) {
        this.enableJsx = jsx;
    }

    public boolean isNeedThrowException() {
        return this.fNeedThrowExpcetion;
    }

    private static class CommentContext {
        boolean collectComments;
        boolean attachComments;

        public CommentContext() {
            this.collectComments = true;
            this.attachComments = true;
        }

        public CommentContext(CommentContext oldContext) {
            this.collectComments = oldContext.collectComments;
            this.attachComments = oldContext.attachComments;
        }
    }
}

