/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.outline;

import com.aptana.editor.common.outline.CommonOutlineItem;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.lexer.IRange;
import java.util.ArrayList;
import java.util.List;

public class JSOutlineItem
extends CommonOutlineItem {
    private String fLabel;
    private Type fType;
    private int fChildrenCount;
    private List<IParseNode> fVirtualChildren;

    public JSOutlineItem(String label, Type type, IRange sourceRange, IParseNode referenceNode) {
        this(label, type, sourceRange, referenceNode, 0);
    }

    public JSOutlineItem(String label, Type type, IRange sourceRange, IParseNode referenceNode, int childrenCount) {
        super(sourceRange, referenceNode);
        this.fLabel = label;
        this.fType = type;
        this.fChildrenCount = childrenCount;
    }

    public void addVirtualChild(IParseNode target) {
        if (this.fVirtualChildren == null) {
            this.fVirtualChildren = new ArrayList<IParseNode>();
        }
        this.fVirtualChildren.add(target);
    }

    public int getChildrenCount() {
        if (this.hasVirtualChildren()) {
            return this.fChildrenCount + this.fVirtualChildren.size();
        }
        return this.fChildrenCount;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public IParseNode[] getAllReferenceNodes() {
        if (this.hasVirtualChildren()) {
            IParseNode[] result = new IParseNode[this.fVirtualChildren.size() + 1];
            result = this.fVirtualChildren.toArray(result);
            result[result.length - 1] = this.getReferenceNode();
            return result;
        }
        return new IParseNode[]{this.getReferenceNode()};
    }

    public Type getType() {
        return this.fType;
    }

    private boolean hasVirtualChildren() {
        return this.fVirtualChildren != null && this.fVirtualChildren.size() > 0;
    }

    public void setLabel(String text) {
        this.fLabel = text;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JSOutlineItem)) {
            return false;
        }
        JSOutlineItem other = (JSOutlineItem)((Object)obj);
        return this.fLabel.equals(other.fLabel) && super.equals(obj);
    }

    public int hashCode() {
        return 31 * this.fLabel.hashCode() + super.hashCode();
    }

    public static enum Type {
        PROPERTY,
        ARRAY,
        BOOLEAN,
        FUNCTION,
        NULL,
        NUMBER,
        OBJECT_LITERAL,
        REGEX,
        STRING;

    }
}

