/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.internal;

import com.aptana.core.IFilter;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.js.contentassist.JSIndexQueryHelper;
import com.aptana.editor.js.contentassist.JSLocationIdentifier;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.index.core.Index;
import com.aptana.parsing.ast.IParseNode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IEditorPart;

public class JSModelUtil {
    private JSModelUtil() {
    }

    public static Collection<PropertyElement> getProperties(AbstractThemeableEditor editor, IParseNode node) {
        JSLocationIdentifier identifier = new JSLocationIdentifier(node.getStartingOffset() + 1, node);
        switch (identifier.getType()) {
            case IN_GLOBAL: 
            case IN_CONSTRUCTOR: 
            case IN_VARIABLE_NAME: 
            case IN_VARIABLE_DECLARATION: {
                JSIndexQueryHelper queryHelper = new JSIndexQueryHelper();
                Index index = EditorUtil.getIndex((AbstractThemeableEditor)editor);
                IProject project = EditorUtil.getProject((AbstractThemeableEditor)editor);
                String fileName = EditorUtil.getFileName((IEditorPart)editor);
                return queryHelper.getGlobals(index, project, fileName, node.getText());
            }
            case IN_PROPERTY_NAME: {
                JSIndexQueryHelper queryHelper = new JSIndexQueryHelper();
                Index index = EditorUtil.getIndex((AbstractThemeableEditor)editor);
                JSGetPropertyNode propertyNode = ParseUtil.getGetPropertyNode(identifier.getTargetNode(), identifier.getStatementNode());
                List<String> types = ParseUtil.getParentObjectTypes(index, EditorUtil.getURI((IEditorPart)editor), identifier.getTargetNode(), propertyNode, node.getStartingOffset());
                String typeName = null;
                String methodName = null;
                if (!CollectionsUtil.isEmpty(types)) {
                    typeName = types.get(0);
                    methodName = propertyNode.getLastChild().getText();
                }
                if (typeName == null || methodName == null) break;
                Collection<PropertyElement> properties = queryHelper.getTypeMembers(index, typeName, methodName);
                return CollectionsUtil.filter(properties, (IFilter)new IFilter<PropertyElement>(){

                    public boolean include(PropertyElement item) {
                        return item instanceof FunctionElement;
                    }
                });
            }
        }
        return Collections.emptyList();
    }
}

