/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.inferencing;

import com.aptana.core.IFilter;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.JSTypeConstants;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.contentassist.inferencing.JSAssistNodeTypeInferrer;
import com.aptana.editor.js.contentassist.inferencing.JSAssistSymbolTypeInferrer;
import com.aptana.editor.js.contentassist.model.AliasFunctionElement;
import com.aptana.editor.js.contentassist.model.AliasPropertyElement;
import com.aptana.editor.js.contentassist.model.ClassElement;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.FunctionTypeElement;
import com.aptana.editor.js.contentassist.model.ParameterElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.ReturnTypeElement;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.editor.js.contentassist.model.ValueElement;
import com.aptana.editor.js.inferencing.JSObjectPropertiesCollector;
import com.aptana.editor.js.inferencing.JSPropertyCollection;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.parsing.ast.JSAssignmentNode;
import com.aptana.editor.js.parsing.ast.JSDeclarationNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSMethodNode;
import com.aptana.editor.js.parsing.ast.JSNameValuePairNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSObjectNode;
import com.aptana.editor.js.parsing.ast.JSParametersNode;
import com.aptana.editor.js.parsing.ast.JSReturnNode;
import com.aptana.editor.js.sdoc.model.AliasTag;
import com.aptana.editor.js.sdoc.model.DescriptionTag;
import com.aptana.editor.js.sdoc.model.DocumentationBlock;
import com.aptana.editor.js.sdoc.model.ExampleTag;
import com.aptana.editor.js.sdoc.model.FunctionType;
import com.aptana.editor.js.sdoc.model.ParamTag;
import com.aptana.editor.js.sdoc.model.PropertyTag;
import com.aptana.editor.js.sdoc.model.ReturnTag;
import com.aptana.editor.js.sdoc.model.Tag;
import com.aptana.editor.js.sdoc.model.TagType;
import com.aptana.editor.js.sdoc.model.Type;
import com.aptana.editor.js.sdoc.model.TypeTag;
import com.aptana.editor.js.sdoc.parsing.SDocParser;
import com.aptana.index.core.Index;
import com.aptana.parsing.ast.IParseNode;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentType;

public class JSTypeUtil {
    private static final Pattern TYPE_NAME_PATTERN = Pattern.compile("[\\$a-zA-Z\\-_\\(\\)\\[\\]]+[\\.\\w\\$\\-/<>\\(\\)\\,\\[\\]]*");
    private static final Set<String> FILTERED_TYPES = CollectionsUtil.newSet((Object[])new String[]{"Array", "Boolean", "Function", "Number", "Object", "RegExp", "String", "undefined", "void", "Window", "window"});

    public static PropertyElement applyDocumentation(PropertyElement propertyElement, JSPropertyCollection property) {
        propertyElement = JSTypeUtil.applyDocumentation(propertyElement, property.getValues());
        if (!CollectionsUtil.isEmpty(property.getSDocTags())) {
            for (Tag tag : property.getSDocTags()) {
                if (!(tag instanceof PropertyTag)) continue;
                PropertyTag propTag = (PropertyTag)tag;
                propertyElement.setDescription(propTag.getDescription());
                for (Type type : propTag.getTypes()) {
                    if (propertyElement instanceof FunctionElement) {
                        if (!(type instanceof FunctionType)) continue;
                        FunctionType funcType = (FunctionType)type;
                        FunctionElement funcElement = (FunctionElement)propertyElement;
                        for (Type rtnType : funcType.getReturnTypes()) {
                            funcElement.addReturnType(rtnType.getName());
                        }
                        int minParamSize = Math.min(funcType.getParameterTypes().size(), funcElement.getParameters().size());
                        int i = 0;
                        while (i < minParamSize) {
                            ParameterElement paramEl = funcElement.getParameters().get(i);
                            paramEl.addType(funcType.getParameterType(i).getName());
                            ++i;
                        }
                        continue;
                    }
                    propertyElement.addType(type.getName());
                }
            }
        }
        return propertyElement;
    }

    public static PropertyElement applyDocumentation(PropertyElement property, List<JSNode> values) {
        if (property != null && !CollectionsUtil.isEmpty(values)) {
            LinkedList<JSNode> queue = new LinkedList<JSNode>();
            HashSet<JSNode> visitedSymbols = new HashSet<JSNode>();
            queue.addAll(values);
            while (!queue.isEmpty()) {
                IParseNode rhs;
                JSNode node = (JSNode)((Object)queue.poll());
                if (visitedSymbols.contains((Object)node)) continue;
                visitedSymbols.add(node);
                DocumentationBlock docs = node.getDocumentation();
                if (docs != null) {
                    property = JSTypeUtil.applyDocumentation(property, node, docs);
                    continue;
                }
                if (property instanceof FunctionElement && node instanceof JSFunctionNode) {
                    FunctionElement functionElement = (FunctionElement)property;
                    JSFunctionNode functionNode = (JSFunctionNode)node;
                    for (IParseNode parameterNode : functionNode.getParameters()) {
                        ParameterElement parameterElement = new ParameterElement();
                        parameterElement.setName(parameterNode.getText());
                        parameterElement.addType("Object");
                        functionElement.addParameter(parameterElement);
                    }
                    continue;
                }
                if (node instanceof JSIdentifierNode) {
                    String symbol = node.getText();
                    JSAssistSymbolTypeInferrer symbolTypeInferrer = new JSAssistSymbolTypeInferrer();
                    JSScope activeScope = ParseUtil.getScopeAtOffset((IParseNode)node, node.getStartingOffset());
                    JSPropertyCollection p = symbolTypeInferrer.getSymbolProperty(activeScope.getObject(), symbol);
                    if (p == null) continue;
                    for (JSNode value : p.getValues()) {
                        queue.offer(value);
                    }
                    continue;
                }
                if (!(node instanceof JSAssignmentNode) || !((rhs = node.getLastChild()) instanceof JSNode)) continue;
                queue.offer((JSNode)rhs);
            }
        }
        return property;
    }

    public static PropertyElement applyDocumentation(FunctionElement function, JSNode node, DocumentationBlock block) {
        if (block != null) {
            ReturnTypeElement returnType;
            ReturnTag returnTag;
            if (block.hasTag(TagType.DESCRIPTION)) {
                List<Tag> descriptionTags = block.getTags(TagType.DESCRIPTION);
                for (Tag tag : descriptionTags) {
                    DescriptionTag descriptionTag = (DescriptionTag)tag;
                    function.setDescription(descriptionTag.getText());
                }
            } else {
                function.setDescription(block.getText());
            }
            if (block.hasTag(TagType.CONSTRUCTOR)) {
                function.setIsConstructor(true);
            }
            if (block.hasTag(TagType.PARAM)) {
                if (!CollectionsUtil.isEmpty(function.getParameters())) {
                    function.getParameters().clear();
                }
                for (Tag tag : block.getTags(TagType.PARAM)) {
                    ParamTag paramTag = (ParamTag)tag;
                    ParameterElement parameter = new ParameterElement();
                    parameter.setName(paramTag.getName());
                    parameter.setDescription(paramTag.getText());
                    parameter.setUsage(paramTag.getUsage().getName());
                    for (Type type : paramTag.getTypes()) {
                        parameter.addType(type.toSource());
                    }
                    if (paramTag.getParameter() != null && !CollectionsUtil.isEmpty(paramTag.getParameter().getValues())) {
                        for (String value : paramTag.getParameter().getValues()) {
                            ValueElement valueEl = new ValueElement();
                            valueEl.setName(value);
                            parameter.addValue(valueEl);
                        }
                    }
                    function.addParameter(parameter);
                }
            } else if (node instanceof JSFunctionNode) {
                JSFunctionNode functionNode = (JSFunctionNode)node;
                for (IParseNode iParseNode : functionNode.getParameters()) {
                    ParameterElement parameterElement = new ParameterElement();
                    parameterElement.setName(iParseNode.getText());
                    parameterElement.addType("Object");
                    function.addParameter(parameterElement);
                }
            }
            for (Tag tag : block.getTags(TagType.RETURN)) {
                returnTag = (ReturnTag)tag;
                for (Type type : returnTag.getTypes()) {
                    returnType = new ReturnTypeElement();
                    returnType.setType(type.toSource());
                    returnType.setDescription(returnTag.getText());
                    function.addReturnType(returnType);
                }
            }
            for (Tag tag : block.getTags(TagType.RETURNS)) {
                returnTag = (ReturnTag)tag;
                for (Type type : returnTag.getTypes()) {
                    returnType = new ReturnTypeElement();
                    returnType.setType(type.toSource());
                    returnType.setDescription(returnTag.getText());
                    function.addReturnType(returnType);
                }
            }
            for (Tag tag : block.getTags(TagType.EXAMPLE)) {
                ExampleTag exampleTag = (ExampleTag)tag;
                function.addExample(exampleTag.getText());
            }
        }
        return function;
    }

    public static PropertyElement applyDocumentation(PropertyElement property, JSNode node, DocumentationBlock block) {
        AliasTag aliasTag;
        if (property instanceof FunctionElement) {
            property = JSTypeUtil.applyDocumentation((FunctionElement)property, node, block);
        } else if (block != null) {
            if (block.hasTag(TagType.DESCRIPTION)) {
                List<Tag> descriptionTags = block.getTags(TagType.DESCRIPTION);
                for (Tag tag : descriptionTags) {
                    DescriptionTag descriptionTag = (DescriptionTag)tag;
                    property.setDescription(descriptionTag.getText());
                }
            } else {
                property.setDescription(block.getText());
            }
            for (Tag tag : block.getTags(TagType.TYPE)) {
                TypeTag typeTag = (TypeTag)tag;
                for (Type type : typeTag.getTypes()) {
                    ReturnTypeElement returnType = new ReturnTypeElement();
                    returnType.setType(type.toSource());
                    returnType.setDescription(typeTag.getText());
                    property.addType(returnType);
                }
            }
            for (Tag tag : block.getTags(TagType.EXAMPLE)) {
                ExampleTag exampleTag = (ExampleTag)tag;
                property.addExample(exampleTag.getText());
            }
        }
        if (block != null && block.hasTag(TagType.ALIAS) && StringUtil.isNotEmpty((String)(aliasTag = (AliasTag)block.getTags(TagType.ALIAS).get(0)).getText())) {
            property = property instanceof FunctionElement ? new AliasFunctionElement(aliasTag.getText(), (FunctionElement)property) : new AliasPropertyElement(aliasTag.getText(), property);
        }
        return property;
    }

    public static void applySignature(PropertyElement property, String typeName) {
        if (property instanceof FunctionElement) {
            JSTypeUtil.applySignature((FunctionElement)property, typeName);
        } else {
            property.addType(typeName);
        }
    }

    public static void applySignature(PropertyElement property, TypeElement type) {
        if (type == null || type instanceof FunctionTypeElement) {
            return;
        }
        if (property instanceof FunctionElement) {
            FunctionElement fElement = (FunctionElement)property;
            JSTypeUtil.applySignature(fElement, type.getName());
            if (!CollectionsUtil.isEmpty(type.getReturnTypes())) {
                for (ReturnTypeElement rType : type.getReturnTypes()) {
                    if (rType.getTypeElement() == null) continue;
                    fElement.addReturnType(rType.getTypeElement().getName());
                }
            } else {
                fElement.addReturnType("void");
            }
        } else {
            property.addType(type.getName());
        }
    }

    public static TypeElement createEmptyType(String typeName) {
        TypeElement type = new TypeElement();
        type.setName(typeName);
        return type;
    }

    public static List<TypeElement> createEmptyTypes(List<String> typeNames) {
        if (CollectionsUtil.isEmpty(typeNames)) {
            return Collections.emptyList();
        }
        ArrayList<TypeElement> types = new ArrayList<TypeElement>(typeNames.size());
        for (String typeName : typeNames) {
            types.add(JSTypeUtil.createEmptyType(typeName));
        }
        return types;
    }

    public static void applyReturnType(FunctionElement func, TypeElement type) {
        if (func == null || type == null) {
            return;
        }
        ReturnTypeElement returnType = new ReturnTypeElement();
        returnType.setType(type.getName());
        returnType.setTypeElement(type);
        returnType.setDescription(type.getDescription());
        func.addReturnType(returnType);
    }

    public static void applyPropertyCollection(TypeElement type, JSPropertyCollection props, Index projectIndex, URI location) {
        if (type == null || props == null) {
            return;
        }
        if (props.hasProperties()) {
            for (String propertyName : props.getPropertyNames()) {
                JSPropertyCollection property = props.getProperty(propertyName);
                for (JSNode value : property.getValues()) {
                    PropertyElement prop = null;
                    if (value instanceof JSFunctionNode) {
                        prop = new FunctionElement();
                        JSFunctionNode funcNode = (JSFunctionNode)value;
                        if (funcNode.getDocumentation() != null) {
                            JSTypeUtil.applyDocumentation(prop, (JSNode)funcNode, funcNode.getDocumentation());
                        } else {
                            IParseNode parameterNodes = funcNode.getParameters();
                            if (parameterNodes instanceof JSParametersNode && !parameterNodes.isEmpty()) {
                                JSParametersNode pNode = (JSParametersNode)parameterNodes;
                                Iterator<Object> iterator = pNode.iterator();
                                while (iterator.hasNext()) {
                                    IParseNode child = (IParseNode)iterator.next();
                                    if (!(child instanceof JSIdentifierNode)) continue;
                                    ParameterElement pElement = new ParameterElement();
                                    pElement.setName(child.getText());
                                    ((FunctionElement)prop).addParameter(pElement);
                                }
                            }
                        }
                        if (funcNode.getDocumentation() == null || !funcNode.getDocumentation().hasTag(TagType.RETURN)) {
                            JSScope scope = ParseUtil.getScopeAtOffset((IParseNode)funcNode, funcNode.getBody().getStartingOffset());
                            List<JSReturnNode> returnNodes = funcNode.getReturnNodes();
                            if (!CollectionsUtil.isEmpty(returnNodes)) {
                                for (JSReturnNode returnNode : returnNodes) {
                                    JSAssistNodeTypeInferrer returnTypeInferrer = new JSAssistNodeTypeInferrer(scope, projectIndex, location);
                                    returnTypeInferrer.visit(returnNode);
                                    List<TypeElement> typeElements = returnTypeInferrer.getTypes();
                                    for (TypeElement typeElement : typeElements) {
                                        ReturnTypeElement returnType = new ReturnTypeElement();
                                        returnType.setType(typeElement.getName());
                                        returnType.setTypeElement(typeElement);
                                        ((FunctionElement)prop).addReturnType(returnType);
                                    }
                                }
                            }
                        }
                    } else {
                        prop = new PropertyElement();
                        JSScope scope = ParseUtil.getScopeAtOffset((IParseNode)value, value.getStartingOffset());
                        JSAssistNodeTypeInferrer typeInferrer = new JSAssistNodeTypeInferrer(scope, projectIndex, location);
                        typeInferrer.visit(value);
                        List<String> typeElements = typeInferrer.getTypeNames();
                        for (String typeEl : typeElements) {
                            prop.addType(typeEl);
                        }
                    }
                    prop.setName(property.getName());
                    type.addProperty(prop);
                }
            }
        }
    }

    public static boolean hasType(Collection<TypeElement> types, TypeElement type) {
        if (types == null || type == null || types.isEmpty()) {
            return false;
        }
        return JSTypeUtil.hasType(types, type.getName());
    }

    public static boolean hasType(Collection<TypeElement> types, String typeName) {
        if (types == null || StringUtil.isEmpty((String)typeName)) {
            return false;
        }
        for (TypeElement typeElement : types) {
            if (typeElement == null || StringUtil.isEmpty((String)typeElement.getName()) || !typeElement.getName().equals(typeName)) continue;
            return true;
        }
        return false;
    }

    public static void applySignature(FunctionElement function, String typeName) {
        if (function != null && typeName != null) {
            int index;
            try {
                List<Type> fTypes = JSTypeUtil.getFunction(typeName);
                if (!CollectionsUtil.isEmpty(fTypes)) {
                    for (Type fType : fTypes) {
                        if (!(fType instanceof FunctionType)) continue;
                        FunctionType functionType = (FunctionType)fType;
                        if (!CollectionsUtil.isEmpty(functionType.getReturnTypes())) {
                            for (Type rType : functionType.getReturnTypes()) {
                                function.addReturnType(rType.getName());
                            }
                        }
                        if (CollectionsUtil.isEmpty(functionType.getParameterTypes())) continue;
                        int index2 = 0;
                        for (Type pType : functionType.getParameterTypes()) {
                            ParameterElement parameter = new ParameterElement();
                            parameter.setName("param" + index2++);
                            parameter.addType(pType.getName());
                            function.addParameter(parameter);
                        }
                    }
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)e.getMessage());
            }
            if ((index = JSTypeUtil.findFunctionType(typeName)) != -1) {
                String types = typeName.substring(0, index);
                String[] stringArray = types.split(",");
                int n = stringArray.length;
                int functionType = 0;
                while (functionType < n) {
                    String type = stringArray[functionType];
                    if (type.length() > 0) {
                        function.addType(type);
                    }
                    ++functionType;
                }
                function.addType("Function");
                String functionWithReturnTypes = typeName.substring(index);
                for (String returnType : JSTypeUtil.getFunctionSignatureReturnTypeNames(functionWithReturnTypes)) {
                    function.addReturnType(returnType);
                }
            }
        }
    }

    private static int findFunctionType(String typeName) {
        int index = -1;
        do {
            if ((index = typeName.indexOf("Function", index + 1)) != -1) continue;
            return -1;
        } while (JSTypeUtil.getStack(typeName, '<', '>', index) != 0);
        return index;
    }

    private static int getStack(String string, char open, char close, int offset) {
        int stack = 0;
        int end = Math.min(offset, string.length());
        int i = 0;
        while (i < end) {
            char c = string.charAt(i);
            if (c == open) {
                ++stack;
            } else if (c == close) {
                --stack;
            }
            ++i;
        }
        return stack;
    }

    public static String createGenericArrayType(String elementType) {
        return "Array<" + elementType + ">";
    }

    public static String getArrayElementType(String type) {
        String result = null;
        if (type != null && type.length() > 0) {
            if (type.endsWith("[]")) {
                result = type.substring(0, type.length() - 2);
            } else if (type.startsWith("Array<") && type.endsWith(">")) {
                result = type.substring("Array<".length(), type.length() - 1);
            } else if (type.equals("Array")) {
                result = "Object";
            } else if (type.equals("NodeList")) {
                result = "HTMLElement";
            } else if (type.indexOf("<") > 0 && type.endsWith(">")) {
                result = type.substring(type.indexOf("<") + 1, type.length() - 1);
            }
        }
        return result;
    }

    public static String getClassType(String typeName) {
        String result = typeName;
        if (JSTypeUtil.isClassType(typeName)) {
            result = typeName.substring("Class<".length(), typeName.length() - ">".length());
        }
        return result;
    }

    public static String toClassType(String typeName) {
        if (JSTypeUtil.isClassType(typeName)) {
            return typeName;
        }
        return "Class<" + typeName + ">";
    }

    public static boolean hasContains(List<TypeElement> container, String typeName) {
        if (StringUtil.isEmpty((String)typeName) || CollectionsUtil.isEmpty(container)) {
            return false;
        }
        for (TypeElement type : container) {
            if (!typeName.equals(type.getName())) continue;
            return true;
        }
        return false;
    }

    public static List<Type> getFunction(String fullType) throws Exception {
        if (StringUtil.isEmpty((String)fullType)) {
            return Collections.emptyList();
        }
        if (fullType.startsWith("Function<")) {
            ArrayList<Type> results = new ArrayList<Type>(2);
            List<String> typeNames = JSTypeUtil.getFunctionSignatureReturnTypeNames(fullType);
            FunctionType resultType = new FunctionType();
            if (!CollectionsUtil.isEmpty(typeNames)) {
                for (String typeName : typeNames) {
                    resultType.addReturnType(new Type(typeName));
                }
            } else {
                resultType.addReturnType(new Type("void"));
            }
            results.add(resultType);
            return results;
        }
        SDocParser parser = new SDocParser();
        List<Type> resultTypes = parser.parseType(fullType);
        return resultTypes;
    }

    public static List<String> getFunctionSignatureReturnTypeNames(String typeName) {
        if (typeName != null && typeName.startsWith("Function<")) {
            int startingIndex = "Function<".length();
            int endingIndex = typeName.lastIndexOf(">");
            if (endingIndex != -1) {
                String returnTypes = typeName.substring(startingIndex, endingIndex);
                if (returnTypes.indexOf(44) == -1) {
                    return CollectionsUtil.newList((Object[])new String[]{returnTypes});
                }
                ArrayList<String> returnTypeNames = new ArrayList<String>();
                int length = returnTypes.length();
                int pointer = 0;
                int stack = 0;
                int i = 0;
                while (i < length) {
                    char c = returnTypes.charAt(i);
                    switch (c) {
                        case '<': {
                            ++stack;
                            break;
                        }
                        case '>': {
                            --stack;
                            break;
                        }
                        case ',': {
                            if (stack != 0) break;
                            returnTypeNames.add(returnTypes.substring(pointer, i));
                            pointer = i + 1;
                            break;
                        }
                    }
                    ++i;
                }
                returnTypeNames.add(returnTypes.substring(pointer));
                return returnTypeNames;
            }
        }
        return Collections.emptyList();
    }

    public static String validateTypeName(String type) {
        int genericOpenIndex;
        if (StringUtil.isEmpty((String)type)) {
            IdeLog.logTrace((Plugin)JSPlugin.getDefault(), (String)"Null or Empty type name attempting to be recorded for a return type.");
            return "";
        }
        if (type.indexOf("(") > 0 && type.indexOf(")") > 0) {
            try {
                SDocParser parser = new SDocParser();
                parser.parseType(type);
                return type;
            }
            catch (Exception exception) {}
        }
        if ((genericOpenIndex = type.indexOf(60)) != -1) {
            if (type.charAt(type.length() - 1) != '>') {
                int genericCloseIndex = type.indexOf(62);
                String baseType = type.substring(0, genericOpenIndex);
                if (genericCloseIndex != -1) {
                    try {
                        baseType = type.substring(genericOpenIndex, genericCloseIndex);
                    }
                    catch (Exception exception) {}
                }
                return baseType;
            }
        } else if (!TYPE_NAME_PATTERN.matcher(type).matches()) {
            if (type.endsWith("[]")) {
                return JSTypeUtil.validateTypeName(JSTypeUtil.createGenericArrayType(JSTypeUtil.getArrayElementType(type)));
            }
            IdeLog.logWarning((Plugin)JSPlugin.getDefault(), (Throwable)new IllegalArgumentException(MessageFormat.format("Bad type name being set, something is going haywire: ''{0}''", type)));
            int index = type.indexOf(44);
            if (index != -1) {
                return type.substring(0, index);
            }
            return "";
        }
        return type;
    }

    public static String getName(JSNode node) {
        String result = null;
        if (node != null) {
            ArrayList<String> parts = new ArrayList<String>();
            JSNode current = node;
            while (current != null) {
                switch (current.getNodeType()) {
                    case 19: {
                        parts.add(current.getText());
                        break;
                    }
                    case 70: {
                        JSFunctionNode function = (JSFunctionNode)current;
                        IParseNode functionName = function.getName();
                        if (functionName.isEmpty()) break;
                        parts.add(functionName.getText());
                        break;
                    }
                    case 76: {
                        JSNameValuePairNode entry = (JSNameValuePairNode)current;
                        IParseNode entryName = entry.getName();
                        String name = entryName.getText();
                        if (entryName.getNodeType() == 17) {
                            name = name.substring(1, name.length() - 1);
                        }
                        parts.add(name);
                        break;
                    }
                    case 63: {
                        JSDeclarationNode declaration = (JSDeclarationNode)current;
                        IParseNode declarationName = declaration.getIdentifier();
                        parts.add(declarationName.getText());
                        break;
                    }
                    case 1: {
                        JSAssignmentNode assignment = (JSAssignmentNode)current;
                        IParseNode lhs = assignment.getLeftHandSide();
                        if (!(lhs instanceof JSIdentifierNode)) break;
                        parts.add(lhs.getText());
                        break;
                    }
                }
                IParseNode parent = current.getParent();
                JSNode jSNode = current = parent instanceof JSNode ? (JSNode)parent : null;
            }
            if (parts.size() > 0) {
                Collections.reverse(parts);
                result = StringUtil.join((String)".", parts);
            }
        }
        if (FILTERED_TYPES.contains(result)) {
            result = null;
        }
        return result;
    }

    public static String getUniqueTypeName() {
        return "-dynamic-type-" + UUID.randomUUID();
    }

    public static boolean isClassType(String typeName) {
        return typeName != null && typeName.startsWith("Class<") && typeName.endsWith(">");
    }

    public static boolean isArrayType(String typeName) {
        return typeName != null && typeName.startsWith("Array<") && typeName.endsWith(">");
    }

    public static boolean isFunctionPrefix(String type) {
        boolean result = false;
        if (type != null) {
            Matcher m = JSTypeConstants.FUNCTION_PREFIX.matcher(type);
            result = m.find();
        }
        return result;
    }

    public static String toFunctionType(Collection<String> returnTypes) {
        if (CollectionsUtil.isEmpty(returnTypes)) {
            return "Function";
        }
        return "Function<" + StringUtil.join((String)",", returnTypes) + ">";
    }

    public static String toFunctionType(String type) {
        if (type == null || type.length() == 0) {
            return "Function";
        }
        return "Function<" + type + ">";
    }

    public static List<ClassElement> typesToClasses(Collection<TypeElement> types) {
        ArrayList<ClassElement> classes = new ArrayList<ClassElement>();
        if (types != null) {
            HashMap<String, ClassElement> classesByName = new HashMap<String, ClassElement>();
            for (TypeElement type : types) {
                ClassElement clss;
                String baseName;
                String typeName = type.getName();
                boolean isClassType = JSTypeUtil.isClassType(typeName);
                String string = baseName = isClassType ? JSTypeUtil.getClassType(type.getName()) : typeName;
                if (!classesByName.containsKey(baseName)) {
                    clss = new ClassElement();
                    clss.setName(baseName);
                    classesByName.put(baseName, clss);
                }
                clss = (ClassElement)classesByName.get(baseName);
                if (isClassType) {
                    clss.addClassType(type);
                    continue;
                }
                clss.addInstanceType(type);
            }
            classes = new ArrayList(classesByName.values());
        }
        return classes;
    }

    private JSTypeUtil() {
    }

    public static String getDefaultGlobalType() {
        return "Window";
    }

    public static String getGlobalType(IProject project, String fileName) {
        IContentType type;
        if (!(fileName == null || (type = Platform.getContentTypeManager().getContentType("com.aptana.contenttype.js")).isAssociatedWith(fileName) || fileName.endsWith("jsca") || fileName.endsWith("json") || fileName.endsWith("sdocml"))) {
            return "Window";
        }
        if (project != null) {
            try {
                String[] natureIds = project.getDescription().getNatureIds();
                String matchingNature = (String)CollectionsUtil.find(Arrays.asList(natureIds), (IFilter)new IFilter<String>(){

                    public boolean include(String item) {
                        return item.startsWith("com.appcelerator.");
                    }
                });
                if (matchingNature != null) {
                    return "Global";
                }
            }
            catch (CoreException e) {
                IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)"Failed to get project description", (Throwable)e, null);
            }
        }
        return "Window";
    }

    public static TypeElement createGlobalType(String globalTypeName) {
        TypeElement window = new TypeElement();
        window.setName(globalTypeName);
        if ("Window".equals(globalTypeName)) {
            window.addParentType("Global");
            window.addParentType("EventTarget");
        }
        return window;
    }

    public static PropertyElement getParentProperty(List<TypeElement> parentTypeElements, String memberName) {
        for (TypeElement type : parentTypeElements) {
            PropertyElement prop = type.getProperty(memberName);
            if (prop != null) {
                return prop;
            }
            if (type.getParentTypeElements().isEmpty()) continue;
            return JSTypeUtil.getParentProperty(type.getParentTypeElements(), memberName);
        }
        return null;
    }

    public static FunctionElement processFunctionNode(JSFunctionNode funcNode, Index index, URI location) {
        FunctionElement prop = new FunctionElement();
        if (funcNode == null) {
            return prop;
        }
        String funcName = funcNode.getName().getText();
        if (StringUtil.isNotEmpty((String)funcName)) {
            prop.setName(funcName);
        }
        if (funcNode instanceof JSMethodNode) {
            JSMethodNode method = (JSMethodNode)funcNode;
            prop.setIsClassProperty(method.isStatic());
            prop.setIsConstructor(method.isConstructor());
        }
        if (funcNode.getDocumentation() != null) {
            JSTypeUtil.applyDocumentation(prop, (JSNode)funcNode, funcNode.getDocumentation());
        } else {
            IParseNode parameterNodes = funcNode.getParameters();
            if (parameterNodes instanceof JSParametersNode && !parameterNodes.isEmpty()) {
                JSParametersNode pNode = (JSParametersNode)parameterNodes;
                Iterator<JSReturnNode> iterator = pNode.iterator();
                while (iterator.hasNext()) {
                    IParseNode child = (IParseNode)iterator.next();
                    if (!(child instanceof JSIdentifierNode)) continue;
                    ParameterElement pElement = new ParameterElement();
                    pElement.setName(child.getText());
                    prop.addParameter(pElement);
                }
            }
        }
        if (funcNode.getDocumentation() == null || !funcNode.getDocumentation().hasTag(TagType.RETURN)) {
            List<JSReturnNode> returnNodes = funcNode.getReturnNodes();
            JSScope funcScope = ParseUtil.getScopeAtOffset((IParseNode)funcNode, funcNode.getBody().getStartingOffset());
            for (JSReturnNode returnNode : returnNodes) {
                JSAssistNodeTypeInferrer returnTypeInferrer = new JSAssistNodeTypeInferrer(funcScope, index, location);
                returnTypeInferrer.visit(returnNode);
                for (TypeElement typeEl : returnTypeInferrer.getTypes()) {
                    JSTypeUtil.applyReturnType(prop, typeEl);
                }
            }
        }
        return prop;
    }

    public static void applyObjectPropertiesCollection(JSObjectNode value, TypeElement type, Index index, URI location) {
        JSObjectPropertiesCollector properties = new JSObjectPropertiesCollector();
        properties.visit(value);
        Map<String, JSNode> propsMap = properties.getProperties();
        for (Map.Entry<String, JSNode> entry : propsMap.entrySet()) {
            PropertyElement prop = null;
            JSNode entryValue = entry.getValue();
            if (entryValue instanceof JSIdentifierNode) {
                entryValue = ParseUtil.getEqualsExpressNode((IParseNode)entryValue);
            }
            if (entryValue.getNodeType() == 70) {
                JSFunctionNode funcNode = (JSFunctionNode)entryValue;
                prop = JSTypeUtil.processFunctionNode(funcNode, index, location);
            } else {
                prop = new PropertyElement();
            }
            prop.setName(entry.getKey());
            prop.setOwningType(type.getName());
            type.addProperty(prop);
        }
    }

    public static boolean isJQuerySymbol(String name) {
        return "jQuery".equals(name) || "$".equals(name);
    }

    public static boolean isMapType(String typeName) {
        return typeName != null && typeName.startsWith("Map<") && typeName.endsWith(">");
    }

    public static String getMapElementType(String typeName) {
        String[] types = (typeName = typeName.substring(4, typeName.length() - 1)).split(",");
        if (types.length == 2) {
            return types[1];
        }
        return "";
    }
}

