/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.inferencing;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.contentassist.JSIndexQueryHelper;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.contentassist.index.JSIndexWriter;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.editor.js.inferencing.JSNodeTypeInferrer;
import com.aptana.editor.js.inferencing.JSPropertyCollection;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.inferencing.JSTypeUtil;
import com.aptana.editor.js.parsing.ast.JSArrowFunctionNode;
import com.aptana.editor.js.parsing.ast.JSCatchNode;
import com.aptana.editor.js.parsing.ast.JSClassNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSObjectNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.editor.js.sdoc.model.DocumentationBlock;
import com.aptana.editor.js.sdoc.model.PropertyTag;
import com.aptana.editor.js.sdoc.model.Tag;
import com.aptana.editor.js.sdoc.model.TagType;
import com.aptana.index.core.Index;
import com.aptana.parsing.ast.IParseNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;

public abstract class JSSymbolTypeInferrer<T> {
    protected static final String NO_TYPE = "";
    protected Index index;
    protected JSScope activeScope;
    protected URI location;
    protected JSIndexWriter writer;

    protected static TypeElement generateType(JSPropertyCollection property, Set<String> types) {
        List<String> parentTypes;
        TypeElement result = new TypeElement();
        boolean isFunction = false;
        if (types != null) {
            for (String superType : types) {
                if (JSTypeUtil.isFunctionPrefix(superType)) {
                    isFunction = true;
                    result.addParentType("Function");
                    continue;
                }
                result.addParentType(superType);
            }
        }
        String name = null;
        List<JSNode> values = property.getValues();
        if (values != null && values.size() > 0) {
            int i = values.size() - 1;
            while (i >= 0) {
                JSNode value = values.get(i);
                String candidate = JSTypeUtil.getName(value);
                if (!StringUtil.isEmpty((String)candidate)) {
                    name = candidate;
                    break;
                }
                --i;
            }
        }
        if (StringUtil.isEmpty(name) && property.getParentProperty() != null && (parentTypes = property.getParentProperty().getTypeNames()) != null && !parentTypes.isEmpty()) {
            name = String.valueOf(parentTypes.get(0)) + "." + property.getName();
        }
        if (StringUtil.isEmpty(name)) {
            name = property.getQualifiedName();
            if ("window".equals(name)) {
                name = "Window";
            } else if (StringUtil.isNotEmpty((String)name) && name.startsWith("window.")) {
                name = name.substring("window".length() + 1);
            }
        }
        if (StringUtil.isEmpty(name)) {
            name = JSTypeUtil.getUniqueTypeName();
        }
        if (isFunction) {
            name = "Function<" + name + ">";
        }
        result.setName(name);
        return result;
    }

    public JSSymbolTypeInferrer() {
        this.index = null;
        this.activeScope = null;
        this.location = null;
    }

    public JSSymbolTypeInferrer(JSScope activeScope, Index index, URI location) {
        this.index = index;
        this.activeScope = activeScope;
        this.location = location;
    }

    protected abstract PropertyElement createPropertyElement(Set<T> var1);

    protected List<String> getAdditionalProperties(JSPropertyCollection activeObject, Set<String> types) {
        Map<String, PropertyElement> propertyMap = this.getTypePropertyMap(types);
        ArrayList<String> additionalProperties = new ArrayList<String>();
        ArrayList<String> filtersProperties = new ArrayList<String>();
        if (types.contains("HTMLElement")) {
            filtersProperties.add("action");
            filtersProperties.add("src");
            filtersProperties.add("href");
        }
        for (String name : activeObject.getPropertyNames()) {
            if ((propertyMap.containsKey(name) || filtersProperties.contains(name)) && !"prototype".equals(name)) continue;
            additionalProperties.add(name);
        }
        return additionalProperties;
    }

    protected abstract JSSymbolTypeInferrer<T> createSymbolTypeInferrer();

    public abstract List<PropertyElement> getScopeProperties();

    public JSPropertyCollection getSymbolProperty(JSPropertyCollection activeObject, String symbol) {
        JSPropertyCollection property = activeObject.getProperty(symbol);
        if (property == null && this.activeScope != null) {
            property = this.activeScope.getSymbol(symbol);
        }
        return property;
    }

    public PropertyElement getSymbolPropertyElement(JSPropertyCollection activeObject, String symbol) {
        JSPropertyCollection property = this.getSymbolProperty(activeObject, symbol);
        PropertyElement result = null;
        if (property != null) {
            LinkedHashSet types;
            block12: {
                types = new LinkedHashSet();
                if (property.hasTypes()) {
                    this.useCachedTypes(types, property);
                } else if (!property.isVisited()) {
                    try {
                        try {
                            property.setVisited(true);
                            property.addType("Object");
                            this.processValues(property, types);
                            this.processProperties(property, types);
                        }
                        catch (Exception e) {
                            IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
                            this.cachedTypes(types, property);
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        this.cachedTypes(types, property);
                        throw throwable;
                    }
                    this.cachedTypes(types, property);
                }
            }
            result = this.createPropertyElement(types);
            this.applySignature(result, types);
            result = JSTypeUtil.applyDocumentation(result, property);
            result.setIsDefine(property.isDefine());
        } else {
            result = new PropertyElement();
        }
        String relativeLocation = null;
        try {
            relativeLocation = this.index.getRelativeDocumentPath(this.location).toString();
        }
        catch (Exception exception) {}
        result.setSource(relativeLocation);
        result.setName(symbol);
        return result;
    }

    protected abstract void applySignature(PropertyElement var1, Set<T> var2);

    protected abstract void cachedTypes(Set<T> var1, JSPropertyCollection var2);

    protected abstract void useCachedTypes(Set<T> var1, JSPropertyCollection var2);

    public PropertyElement getSymbolPropertyElement(String symbol) {
        return this.getSymbolPropertyElement(this.activeScope.getObject(), symbol);
    }

    protected Map<String, PropertyElement> getTypePropertyMap(Set<String> typeNames) {
        JSIndexQueryHelper helper = new JSIndexQueryHelper();
        HashSet<String> ancestors = new HashSet<String>();
        for (String typeName : typeNames) {
            ancestors.add(typeName);
            ancestors.addAll(helper.getTypeAncestorNames(this.index, typeName));
        }
        ArrayList<String> typesAndAncestors = new ArrayList<String>(ancestors);
        Collection<PropertyElement> typeMembers = helper.getTypeMembers(this.index, typesAndAncestors);
        HashMap<String, PropertyElement> propertyMap = new HashMap<String, PropertyElement>();
        for (PropertyElement propertyElement : typeMembers) {
            propertyMap.put(propertyElement.getName(), propertyElement);
        }
        return propertyMap;
    }

    public abstract void processProperties(JSPropertyCollection var1, Set<T> var2);

    protected void processValues(JSPropertyCollection property, Set<T> types) {
        List<JSNode> values = property.getValues();
        if (values == null || values.isEmpty()) {
            this.addWindowMemberTypes(property, types);
            return;
        }
        for (JSNode value : values) {
            JSScope valueScope = ParseUtil.getScopeAtOffset((IParseNode)value, value.getStart());
            JSNodeTypeInferrer<T> inferrer = this.createNodeTypeInferrer(valueScope, this.index, this.location);
            if (value instanceof JSObjectNode) {
                this.addObjectType(property, types, value, inferrer);
            } else if (value instanceof JSClassNode) {
                types.add(this.getClassType(property, value));
            } else if (value instanceof JSFunctionNode || value instanceof JSArrowFunctionNode) {
                property.addType("Function");
                inferrer.visit(value);
            } else if (value instanceof JSIdentifierNode && value.getParent() instanceof JSCatchNode) {
                JSCatchNode catchNode = (JSCatchNode)value.getParent();
                this.addExceptionType(property, types, catchNode, inferrer);
            } else {
                inferrer.visit(value);
            }
            List<T> typeElements = inferrer.getTypes();
            types.addAll(typeElements);
        }
    }

    public abstract T getClassType(JSPropertyCollection var1, JSNode var2);

    protected abstract void addExceptionType(JSPropertyCollection var1, Set<T> var2, JSCatchNode var3, JSNodeTypeInferrer<T> var4);

    protected void addObjectType(JSPropertyCollection property, Set<T> types, JSNode value, JSNodeTypeInferrer<T> inferrer) {
        DocumentationBlock block = value.getDocumentation();
        if (block != null) {
            for (Tag tag : block.getTags(TagType.PROPERTY)) {
                PropertyTag propTag = (PropertyTag)tag;
                String text = propTag.getText();
                StringBuilder sBuilder = new StringBuilder();
                int length = text.length();
                int i = 0;
                while (i < length) {
                    if (Character.isWhitespace(text.charAt(i)) || '.' != text.charAt(i) && !Character.isJavaIdentifierPart(text.charAt(i))) break;
                    sBuilder.append(text.charAt(i));
                    ++i;
                }
                String namePath = sBuilder.toString();
                String[] paths = namePath.split("\\.");
                LinkedList<String> pathQueue = new LinkedList<String>();
                String[] stringArray = paths;
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    pathQueue.offer(path);
                    ++n2;
                }
                JSPropertyCollection subProperty = property;
                while (!pathQueue.isEmpty()) {
                    if (subProperty == null) break;
                    String path = (String)pathQueue.poll();
                    subProperty = subProperty.getProperty(path);
                }
                if (subProperty == null) continue;
                propTag.setDescription(text.substring(namePath.length()).trim());
                subProperty.addSDocTag(propTag);
            }
        }
    }

    protected abstract JSNodeTypeInferrer<T> createNodeTypeInferrer(JSScope var1, Index var2, URI var3);

    protected abstract void addWindowMemberTypes(JSPropertyCollection var1, Set<T> var2);

    protected abstract void processDocumentationBlock(JSPropertyCollection var1, Set<T> var2, JSNode var3, boolean var4, DocumentationBlock var5);

    protected JSFunctionNode getContainerFunction(JSNode jsnode) {
        if (jsnode == null) {
            return null;
        }
        JSNode current = jsnode;
        while (!(current instanceof JSParseRootNode)) {
            if (current.getParent() instanceof JSFunctionNode) {
                return (JSFunctionNode)current.getParent();
            }
            current = current.getParent();
        }
        return null;
    }

    protected void writeType(TypeElement type) {
        if (type != null) {
            for (PropertyElement property : type.getProperties()) {
                property.setHasAllUserAgents();
            }
            if (this.writer == null) {
                this.writer = new JSIndexWriter();
            }
            this.writer.writeType(this.index, type, this.location);
        }
    }
}

