/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.inferencing;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.js.contentassist.JSIndexQueryHelper;
import com.aptana.editor.js.inferencing.JSNodeTypeInferrer;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.inferencing.JSSymbolTypeInferrer;
import com.aptana.editor.js.inferencing.JSTypeUtil;
import com.aptana.editor.js.parsing.ast.JSConstructNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSGetElementNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSObjectNode;
import com.aptana.editor.js.parsing.ast.JSThisNode;
import com.aptana.index.core.Index;
import com.aptana.parsing.ast.IParseNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class JSSimpleNodeTypeInferrer
extends JSNodeTypeInferrer<String> {
    private List<String> _types = null;

    public JSSimpleNodeTypeInferrer(JSScope scope, Index projectIndex, URI location) {
        super(scope, projectIndex, location);
    }

    @Override
    protected void addParameterTypes(JSIdentifierNode identifierNode) {
    }

    @Override
    public List<String> getArgumentTypes(JSInvokeNode ivkNode, int index, JSScope scope) {
        return Collections.emptyList();
    }

    @Override
    protected JSSymbolTypeInferrer<String> createSymbolTypeInferrer(JSScope localScope, Index index, URI location) {
        return null;
    }

    @Override
    protected void addType(String type) {
        if (this._types == null) {
            this._types = new ArrayList<String>();
        }
        this._types.add(type);
    }

    @Override
    protected void addTypes(List<String> types) {
        if (this._types == null) {
            this._types = new ArrayList<String>();
        }
        this._types.addAll(types);
    }

    @Override
    public List<String> getTypeNames(IParseNode node) {
        return this.getTypes(node);
    }

    @Override
    public List<String> getTypeNames() {
        return this.getTypes();
    }

    @Override
    public List<String> getTypes(IParseNode node, JSScope scope) {
        if (node instanceof JSNode) {
            JSNodeTypeInferrer<String> simpleInferrer = this.createNodeTypeInferrer(scope, this._index, this._location, this._queryHelper);
            simpleInferrer.visit((JSNode)node);
            return simpleInferrer.getTypes();
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getTypes() {
        return CollectionsUtil.getListValue(this._types);
    }

    @Override
    protected JSNodeTypeInferrer<String> createNodeTypeInferrer(JSScope scope, Index index, URI location, JSIndexQueryHelper queryHelper) {
        return new JSSimpleNodeTypeInferrer(scope, index, location);
    }

    @Override
    public String getGenericArrayType(String type) {
        return JSTypeUtil.createGenericArrayType(type);
    }

    @Override
    public void visit(JSConstructNode node) {
        IParseNode exprNode = node.getExpression();
        switch (exprNode.getNodeType()) {
            case 19: 
            case 48: {
                this.addType(exprNode.getText());
                break;
            }
        }
    }

    @Override
    public void visit(JSThisNode node) {
    }

    @Override
    public void visit(JSFunctionNode node) {
        this.addType("Function");
    }

    @Override
    public void visit(JSGetElementNode node) {
    }

    @Override
    public void visit(JSGetPropertyNode node) {
    }

    @Override
    public void visit(JSIdentifierNode node) {
    }

    @Override
    public void visit(JSInvokeNode node) {
    }

    @Override
    protected String getGenericType(String typeName) {
        return typeName;
    }

    @Override
    protected String getTypeName(String type) {
        return type;
    }

    @Override
    public void visit(JSObjectNode node) {
        this.addType("Object");
    }

    @Override
    public Collection<String> getFunctionTypes(JSInvokeNode iNode, JSScope scope) {
        return Arrays.asList("Function");
    }
}

