/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.inferencing;

import com.aptana.build.util.AssistHelper;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.inferencing.JSPropertyCollection;
import com.aptana.editor.js.inferencing.JSTypeCollection;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class JSScope {
    private JSScope parent;
    private List<JSScope> children;
    private JSPropertyCollection object = new JSPropertyCollection();
    private JSTypeCollection types = new JSTypeCollection();
    private IRange range;
    private Map<String, Collection<PropertyElement>> cachedProperty = null;

    public void addScope(JSScope scope) {
        if (scope != null) {
            scope.setParent(this);
            if (this.children == null) {
                this.children = new ArrayList<JSScope>();
            }
            this.children.add(scope);
        }
    }

    public void addSymbol(String name, JSNode value, Object localData) {
        JSPropertyCollection property;
        AssistHelper.checkState();
        if (this.object.hasProperty(name)) {
            property = this.object.getProperty(name);
        } else {
            property = new JSPropertyCollection();
            this.object.setProperty(name, property);
            this.object.applyReferenceSymbol(name, property);
        }
        property.addValue(value);
        property.setLocalData(localData);
    }

    public void addSymbol(String name, JSNode value) {
        this.addSymbol(name, value, null);
    }

    public List<JSScope> getChildren() {
        List<JSScope> result = this.children;
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public JSPropertyCollection getLocalSymbol(String name) {
        return this.object.getProperty(name);
    }

    public List<String> getLocalSymbolNames() {
        return this.object.getPropertyNames();
    }

    public JSPropertyCollection getObject() {
        return this.object;
    }

    public JSScope getParentScope() {
        return this.parent;
    }

    public IRange getRange() {
        return this.range != null ? this.range : Range.EMPTY;
    }

    public JSScope getScopeAtOffset(int offset) {
        JSScope result = null;
        if (this.getRange().contains(offset)) {
            result = this;
            for (JSScope child : this.getChildren()) {
                JSScope candidate = child.getScopeAtOffset(offset);
                if (candidate == null) continue;
                result = candidate;
                break;
            }
        } else if (this.getRange().contains(offset - 1)) {
            result = this;
        }
        return result;
    }

    public JSScope getScopeWithSymbol(String name) {
        JSScope current = this;
        while (current != null) {
            if (current.hasLocalSymbol(name)) break;
            current = current.getParentScope();
        }
        return current;
    }

    public JSPropertyCollection getSymbol(String name) {
        JSScope current = this;
        JSPropertyCollection result = null;
        while (current != null) {
            if (current.hasLocalSymbol(name)) {
                result = current.getLocalSymbol(name);
                break;
            }
            current = current.getParentScope();
        }
        return result;
    }

    public List<String> getSymbolNames() {
        HashSet<String> result = new HashSet<String>();
        JSScope current = this;
        while (current != null) {
            result.addAll(current.getLocalSymbolNames());
            current = current.getParentScope();
        }
        return new ArrayList<String>(result);
    }

    public boolean hasLocalSymbol(String name) {
        return this.object.hasProperty(name);
    }

    public boolean hasSymbol(String name) {
        JSScope current = this;
        boolean result = false;
        while (current != null) {
            if (current.hasLocalSymbol(name)) {
                result = true;
                break;
            }
            current = current.getParentScope();
        }
        return result;
    }

    public JSTypeCollection getTypes() {
        return this.types;
    }

    public void addType(String typeName, JSPropertyCollection prop) {
        this.types.addType(typeName, prop);
    }

    public JSPropertyCollection getTypePropertyCollection(String typeName) {
        if (this.types.hasType(typeName)) {
            return this.types.getPropertyCollection(typeName);
        }
        JSScope current = this.getParentScope();
        if (current != null) {
            return current.getTypePropertyCollection(typeName);
        }
        return null;
    }

    protected void setParent(JSScope parent) {
        this.parent = parent;
    }

    public void setRange(IRange range) {
        this.range = range;
    }

    public Collection<PropertyElement> getCachedProperty(String propertyName) {
        if (this.cachedProperty == null) {
            return null;
        }
        return this.cachedProperty.get(propertyName);
    }

    public void addCachedProperty(String propertyName, Collection<PropertyElement> propertys) {
        if (this.cachedProperty == null) {
            this.cachedProperty = new HashMap<String, Collection<PropertyElement>>();
        }
        this.cachedProperty.put(propertyName, propertys);
    }

    public boolean hasType(String typeName) {
        if (this.types.hasType(typeName)) {
            return true;
        }
        JSScope current = this.getParentScope();
        return current != null && current.hasType(typeName);
    }

    public void reset() {
        if (this.getObject() != null && !CollectionsUtil.isEmpty(this.getObject().getPropertyNames())) {
            for (String name : this.getObject().getPropertyNames()) {
                JSPropertyCollection prop = this.getObject().getProperty(name);
                if (prop == null) continue;
                prop.reset();
            }
        }
        for (JSScope child : this.getChildren()) {
            child.reset();
        }
    }
}

